/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plumbing.CSPFilter;
import com.xebialabs.deployit.plumbing.IgnoreUrlFilter;
import com.xebialabs.deployit.plumbing.LogbackFilter;
import com.xebialabs.deployit.plumbing.ModifiedResourceFilter;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.plumbing.SlowdownFilter;
import com.xebialabs.deployit.plumbing.UrlRedirectRewriteFilter;
import com.xebialabs.deployit.plumbing.VersionEnforcerFilter;
import com.xebialabs.deployit.plumbing.XlrAccessControlFilter;
import com.xebialabs.deployit.plumbing.XssSecurityHeadersFilter;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.xlplatform.endpoints.servlet.PekkoStreamServlet;
import com.xebialabs.xlplatform.endpoints.servlet.PekkoStreamServletInitializer;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.security.HttpSessionListenerWithTimeout;
import com.xebialabs.xlrelease.server.jetty.JettyEmbeddedErrorHandler;
import com.xebialabs.xlrelease.server.jetty.SSLConstants$;
import com.xebialabs.xlrelease.service.XlrServiceManager;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.jetty12.server.TimedHandler;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.SessionTrackingMode;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventListener;
import org.eclipse.jetty.ee10.servlet.ErrorHandler;
import org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee10.servlets.CrossOriginFilter;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005ug\u0001B\u0010!\u0001-B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005{!AA\t\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003G\u0011!i\u0005A!b\u0001\n\u0003q\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011Y\u0003!\u0011!Q\u0001\n]C\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\u0006U\u0002!\ta\u001b\u0005\u0006g\u0002!\t\u0005\u001e\u0005\u0006w\u0002!\t\u0006 \u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\t\t\u0003\u0001C\u0005\u0003GAq!a\u000b\u0001\t\u0013\ti\u0003C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u0011\u0011\u000e\u0001\u0005\n\u0005-\u0004bBA8\u0001\u0011%\u0011\u0011\u000f\u0005\b\u0003k\u0002A\u0011BA<\u0011\u001d\tY\b\u0001C\u0005\u0003{Bq!!!\u0001\t\u0013\t\u0019\tC\u0004\u0002\b\u0002!I!!#\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\"9\u00111\u0013\u0001\u0005\n\u0005U\u0005bBAM\u0001\u0011%\u00111\u0014\u0005\b\u0003?\u0003A\u0011BAQ\u0011\u001d\t)\u000b\u0001C\u0005\u0003OCq!a,\u0001\t\u0013\t\t\fC\u0004\u00026\u0002!I!a.\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\n\u0019#+\u001a7fCN,'*\u001a;usN+'O\u001e7fi^+'mU3sm\u0016\u0014h)Y2u_JL(BA\u0011#\u0003\u0015QW\r\u001e;z\u0015\t\u0019C%\u0001\u0004tKJ4XM\u001d\u0006\u0003K\u0019\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u001dB\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0013aA2p[\u000e\u00011C\u0001\u0001-!\ti\u0013(D\u0001/\u0015\t\tsF\u0003\u00021c\u0005AQ-\u001c2fI\u0012,GM\u0003\u00023g\u0005\u0019q/\u001a2\u000b\u0005Q*\u0014\u0001\u00022p_RT!AN\u001c\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e/\u0005qQU\r\u001e;z'\u0016\u0014h\u000f\\3u/\u0016\u00147+\u001a:wKJ4\u0015m\u0019;pef\f1c]3sm\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:,\u0012!\u0010\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u001a\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003\u0005~\u00121cU3sm\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\fAc]3sm\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\u0004\u0013!\u0003=me\u000e{gNZ5h+\u00051\u0005CA$K\u001b\u0005A%BA%%\u0003\u0019\u0019wN\u001c4jO&\u00111\n\u0013\u0002\n12\u00148i\u001c8gS\u001e\f!\u0002\u001f7s\u0007>tg-[4!\u0003I\u0001XM]7jgNLwN\\#oM>\u00148-\u001a:\u0016\u0003=\u0003\"\u0001U*\u000e\u0003ES!AU \u0002\u0011M,7-\u001e:jifL!\u0001V)\u0003%A+'/\\5tg&|g.\u00128g_J\u001cWM]\u0001\u0014a\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'\u000fI\u0001\u000e[\u0016$XM\u001d*fO&\u001cHO]=\u0011\u0005a\u000bW\"A-\u000b\u0005i[\u0016AC5ogR\u0014X/\\3oi*\u0011A,X\u0001\u0005G>\u0014XM\u0003\u0002_?\u0006QQ.[2s_6,G/\u001a:\u000b\u0003\u0001\f!![8\n\u0005\tL&!D'fi\u0016\u0014(+Z4jgR\u0014\u00180\u0001\btKJ4\u0018nY3NC:\fw-\u001a:\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d$\u0013aB:feZL7-Z\u0005\u0003S\u001a\u0014\u0011\u0003\u00177s'\u0016\u0014h/[2f\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Q1AN\\8qcJ\u0004\"!\u001c\u0001\u000e\u0003\u0001BQaO\u0005A\u0002uBQ\u0001R\u0005A\u0002\u0019CQ!T\u0005A\u0002=CQAV\u0005A\u0002]CQaY\u0005A\u0002\u0011\f\u0001$[:SK\u001eL7\u000f^3s\t\u00164\u0017-\u001e7u'\u0016\u0014h\u000f\\3u)\u0005)\bC\u0001<z\u001b\u00059(\"\u0001=\u0002\u000bM\u001c\u0017\r\\1\n\u0005i<(a\u0002\"p_2,\u0017M\\\u0001\u0019a>\u001cH\u000f\u0015:pG\u0016\u001c8oV3c\u0003B\u00048i\u001c8uKb$HcA?\u0002\u0002A\u0011aO`\u0005\u0003\u007f^\u0014A!\u00168ji\"9\u00111A\u0006A\u0002\u0005\u0015\u0011aC2p]R,\u0007\u0010\u001e*p_R\u0004B!a\u0002\u0002\u00185\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0004xK\n\f\u0007\u000f\u001d\u0006\u0005\u0003\u001f\t\t\"\u0001\u0003fKF\u0002$bA\u0011\u0002\u0014)\u0019\u0011QC\u001c\u0002\u000f\u0015\u001cG.\u001b9tK&!\u0011\u0011DA\u0005\u000559VMY!qa\u000e{g\u000e^3yi\u0006Q1/\u001a;va*+G\u000f^=\u0015\u0007u\fy\u0002C\u0004\u0002\u00041\u0001\r!!\u0002\u00023\u001d,G/\u0012:s_J\u0004\u0016mZ3D_:4\u0017nZ;sCRLwN\u001c\u000b\u0003\u0003K\u0001B!a\u0002\u0002(%!\u0011\u0011FA\u0005\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006\u0011\u0012\r\u001a3KKR$\u00180\u0012:s_J\u0004\u0016mZ3t)\u0015i\u0018qFA \u0011\u001d\t\tD\u0004a\u0001\u0003g\tA\"\u001a:s_JD\u0015M\u001c3mKJ\u0004B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0005\u0003s\ti!A\u0004tKJ4H.\u001a;\n\t\u0005u\u0012q\u0007\u0002\r\u000bJ\u0014xN\u001d%b]\u0012dWM\u001d\u0005\b\u0003\u0003r\u0001\u0019AA\"\u0003))'O]8s!\u0006<Wm\u001d\t\u0007\u0003\u000b\ny%a\u0015\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\nA!\u001e;jY*\u0011\u0011QJ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002R\u0005\u001d#AC\"pY2,7\r^5p]B!\u0011QKA-\u001b\t\t9F\u0003\u0002$c%!\u00111LA,\u0005%)%O]8s!\u0006<W-\u0001\ntKR,\b\u000fT8hE\u0006\u001c7NR5mi\u0016\u0014HcA?\u0002b!9\u00111A\bA\u0002\u0005\u0015\u0011aC:fiV\u00048\u000b\u001d:j]\u001e$2!`A4\u0011\u001d\t\u0019\u0001\u0005a\u0001\u0003\u000b\tqb]3ukB\u001cuN]:GS2$XM\u001d\u000b\u0004{\u00065\u0004bBA\u0002#\u0001\u0007\u0011QA\u0001\u001eg\u0016$X\u000f\u001d-tgN+7-\u001e:jifDU-\u00193feN4\u0015\u000e\u001c;feR\u0019Q0a\u001d\t\u000f\u0005\r!\u00031\u0001\u0002\u0006\u0005q1/\u001a;vaV\u0013HNR5mi\u0016\u0014HcA?\u0002z!9\u00111A\nA\u0002\u0005\u0015\u0011aE:fiV\u00048\u000b\\8xI><hNR5mi\u0016\u0014HcA?\u0002\u0000!9\u00111\u0001\u000bA\u0002\u0005\u0015\u0011AD:fiV\u00048i\u0015)GS2$XM\u001d\u000b\u0004{\u0006\u0015\u0005bBA\u0002+\u0001\u0007\u0011QA\u0001\u0012g\u0016$X\u000f]#yi\u0016t7/[8o\u0003BLGcA?\u0002\f\"9\u00111\u0001\fA\u0002\u0005\u0015\u0011\u0001F:fiV\u0004h+\u001a:tS>tWI\u001c4pe\u000e,'\u000fF\u0002~\u0003#Cq!a\u0001\u0018\u0001\u0004\t)!A\ttKR,\bOU3rk\u0016\u001cH\u000fT8dC2$2!`AL\u0011\u001d\t\u0019\u0001\u0007a\u0001\u0003\u000b\tA#\u001a8bE2,'+Z:pkJ\u001cWm]\"bG\",GcA?\u0002\u001e\"9\u00111A\rA\u0002\u0005\u0015\u0011!E3oC\ndWm\u0012>ja\"\u000bg\u000e\u001a7feR\u0019Q0a)\t\u000f\u0005\r!\u00041\u0001\u0002\u0006\u0005\tb.Z<TKN\u001c\u0018n\u001c8IC:$G.\u001a:\u0016\u0005\u0005%\u0006\u0003BA\u001b\u0003WKA!!,\u00028\tq1+Z:tS>t\u0007*\u00198eY\u0016\u0014\u0018!G3oC\ndW-\u00138tiJ,X.\u001a8uK\u0012D\u0015M\u001c3mKJ$2!`AZ\u0011\u001d\t\u0019\u0001\ba\u0001\u0003\u000b\t\u0011c]3u!J|\u0007/\u001a:us&3g*\u001e7m)\u0015i\u0018\u0011XAj\u0011\u001d\tY,\ba\u0001\u0003{\u000b1a[3z!\u0011\ty,!4\u000f\t\u0005\u0005\u0017\u0011\u001a\t\u0004\u0003\u0007<XBAAc\u0015\r\t9MK\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-w/\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\f\tN\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017<\bbBAk;\u0001\u0007\u0011QX\u0001\u0006m\u0006dW/Z\u0001\u0019g\u0016$X\u000f]!dG\u0016\u001c8oQ8oiJ|GNR5mi\u0016\u0014HcA?\u0002\\\"9\u00111\u0001\u0010A\u0002\u0005\u0015\u0001")
public class ReleaseJettyServletWebServerFactory
extends JettyServletWebServerFactory {
    private final ServerConfiguration serverConfiguration;
    private final XlrConfig xlrConfig;
    private final PermissionEnforcer permissionEnforcer;
    private final MeterRegistry meterRegistry;
    private final XlrServiceManager serviceManager;

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public boolean isRegisterDefaultServlet() {
        return false;
    }

    public void postProcessWebAppContext(WebAppContext contextRoot) {
        this.setupJetty(contextRoot);
        this.setupLogbackFilter(contextRoot);
        this.setupSpring(contextRoot);
        this.setupCorsFilter(contextRoot);
        this.setupXssSecurityHeadersFilter(contextRoot);
        this.setupUrlFilter(contextRoot);
        this.setupCSPFilter(contextRoot);
        this.setupSlowdownFilter(contextRoot);
        this.setupExtensionApi(contextRoot);
        this.setupVersionEnforcer(contextRoot);
        this.setupRequestLocal(contextRoot);
        this.setupAccessControlFilter(contextRoot);
    }

    private void setupJetty(WebAppContext contextRoot) {
        contextRoot.setSessionHandler(this.newSessionHandler());
        contextRoot.setSecurityHandler((SecurityHandler)new ConstraintSecurityHandler());
        contextRoot.addConfiguration(new Configuration[]{this.getErrorPageConfiguration()});
        if (this.xlrConfig().metrics().enabled()) {
            this.enableInstrumentedHandler(contextRoot);
        }
        if (this.xlrConfig().server_http_gzip_enabled()) {
            this.enableGzipHandler(contextRoot);
        }
        if (this.xlrConfig().server_http_cache_enabled() && Environment.isProduction()) {
            this.enableResourcesCache(contextRoot);
            return;
        }
    }

    private Configuration getErrorPageConfiguration() {
        return new AbstractConfiguration(this){
            private final /* synthetic */ ReleaseJettyServletWebServerFactory $outer;

            public void configure(WebAppContext context) {
                JettyEmbeddedErrorHandler errorHandler = new JettyEmbeddedErrorHandler();
                errorHandler.setShowServlet(false);
                errorHandler.setShowStacks(false);
                errorHandler.setShowMessageInTitle(false);
                context.setErrorHandler((Request.Handler)errorHandler);
                this.$outer.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$addJettyErrorPages((ErrorHandler)errorHandler, this.$outer.getErrorPages());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new AbstractConfiguration.Builder());
            }
        };
    }

    public void com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$addJettyErrorPages(ErrorHandler errorHandler, Collection<ErrorPage> errorPages) {
        ErrorHandler errorHandler2 = errorHandler;
        if (errorHandler2 instanceof ErrorPageErrorHandler) {
            ErrorPageErrorHandler errorPageErrorHandler = (ErrorPageErrorHandler)errorHandler2;
            CollectionConverters$.MODULE$.CollectionHasAsScala(errorPages).asScala().foreach((Function1 & Serializable)errorPage -> {
                ReleaseJettyServletWebServerFactory.$anonfun$addJettyErrorPages$1(errorPageErrorHandler, errorPage);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void setupLogbackFilter(WebAppContext contextRoot) {
        contextRoot.addFilter(LogbackFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
    }

    private void setupSpring(WebAppContext contextRoot) {
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PROPERTY(), this.serverConfiguration().getKeyStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getKeyStorePassword());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PROPERTY(), this.serverConfiguration().getTrustStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getTrustStorePassword());
        contextRoot.addFilter(UrlRedirectRewriteFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        filter.setAsyncSupported(true);
        contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder encodingFilter = new FilterHolder(CharacterEncodingFilter.class);
        encodingFilter.setName("encodingFilter");
        encodingFilter.setInitParameter("encoding", "UTF-8");
        encodingFilter.setInitParameter("forceEncoding", "true");
        encodingFilter.setAsyncSupported(true);
        contextRoot.addFilter(encodingFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        ResourceFactory resourceFactory = contextRoot.getResourceFactory();
        URI path = Path.of(".", new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toUri();
        Resource baseResource = resourceFactory.newResource(path);
        contextRoot.setBaseResource(baseResource);
        if (!this.xlrConfig().server_session_storage_enabled()) {
            contextRoot.addEventListener((EventListener)((Object)new HttpSessionListenerWithTimeout()));
            return;
        }
    }

    private void setupCorsFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().api_corsEnabled()) {
            FilterHolder holder = new FilterHolder((Filter)new CrossOriginFilter());
            holder.setInitParameter("Access-Control-Allow-Origin", "*");
            holder.setInitParameter("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT");
            holder.setInitParameter("Access-Control-Allow-Headers", "x-requested-with, accept, origin, content-type");
            holder.setInitParameter("Access-Control-Max-Age", "3600");
            holder.setAsyncSupported(true);
            contextRoot.addFilter(holder, "/api/v1/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    private void setupXssSecurityHeadersFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new XssSecurityHeadersFilter());
        holder.setAsyncSupported(true);
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupUrlFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new IgnoreUrlFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSlowdownFilter(WebAppContext contextRoot) {
        if (Environment.isDevelopment()) {
            long slowDownInMs = this.xlrConfig().development_restSlowDownDelay().toMillis();
            if (slowDownInMs > 0L) {
                this.logger.warn((Object)("Configuring slow down filter with " + slowDownInMs + " milliseconds."));
                FilterHolder slowdownFilter = new FilterHolder(SlowdownFilter.class);
                slowdownFilter.setInitParameter("ms", String.valueOf(slowDownInMs));
                slowdownFilter.setAsyncSupported(true);
                contextRoot.addFilter(slowdownFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
                return;
            }
            return;
        }
    }

    private void setupCSPFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().server_http_csp_enabled()) {
            FilterHolder holder = new FilterHolder((Filter)new CSPFilter());
            holder.setAsyncSupported(true);
            holder.setInitParameter("policyDirectives", this.xlrConfig().server_http_csp_policyDirectives());
            contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    private void setupExtensionApi(WebAppContext contextRoot) {
        String apiExtensionRootPath = this.xlrConfig().serverExtension_rootPath();
        String apiExtensionContext = String.format("%s/*", apiExtensionRootPath);
        ServletHolder extensionApiServletHolder = new ServletHolder(PekkoStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        contextRoot.addEventListener((EventListener)new PekkoStreamServletInitializer(this.xlrConfig().extensionServletSystem().config()));
        contextRoot.addServlet(extensionApiServletHolder, apiExtensionContext);
    }

    private void setupVersionEnforcer(WebAppContext contextRoot) {
        if (!Environment.isDevelopment()) {
            contextRoot.addFilter(VersionEnforcerFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
            return;
        }
    }

    private void setupRequestLocal(WebAppContext contextRoot) {
        contextRoot.addFilter(RequestLocal.class, "*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
    }

    private void enableResourcesCache(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new ModifiedResourceFilter());
        holder.setInitParameter("startTimestamp", String.valueOf(System.currentTimeMillis()));
        holder.setAsyncSupported(true);
        contextRoot.addFilter(holder, "/static/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-module.js", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-plugins.js", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableGzipHandler(WebAppContext contextRoot) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setSyncFlush(true);
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT"});
        gzipHandler.setMinGzipSize(this.xlrConfig().server_http_gzip_minSize().intValue());
        gzipHandler.setExcludedPaths((String[])CollectionConverters$.MODULE$.ListHasAsScala(this.xlrConfig().server_http_gzip_excludedPaths()).asScala().toSeq().toArray(ClassTag$.MODULE$.apply(String.class)));
        gzipHandler.setDeflaterPool(new DeflaterPool(1024, this.xlrConfig().server_http_gzip_compression(), true));
        contextRoot.insertHandler((Handler.Singleton)gzipHandler);
    }

    private SessionHandler newSessionHandler() {
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
        sessionHandler.setHttpOnly(true);
        if (!this.serverConfiguration().isSsl()) {
            this.logger.debug((Object)("Setting up Secure Cookie Enabled to - " + this.serverConfiguration().isSecureCookieEnabled()));
            sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration().isSecureCookieEnabled());
        }
        sessionHandler.setSameSite(HttpCookie.SameSite.valueOf((String)this.xlrConfig().server_http_cookie_sameSite().getAttributeValue().toUpperCase()));
        return sessionHandler;
    }

    private void enableInstrumentedHandler(WebAppContext contextRoot) {
        TimedHandler handler = new TimedHandler(this.meterRegistry, (Iterable)Tags.empty());
        contextRoot.insertHandler((Handler.Singleton)handler);
    }

    private void setPropertyIfNull(String key, String value) {
        if (value != null) {
            if (System.getProperty(key) == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting system property - " + key));
                }
                System.setProperty(key, value);
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not overriding already specified system property - " + key));
                return;
            }
            return;
        }
    }

    private void setupAccessControlFilter(WebAppContext contextRoot) {
        FilterHolder filterHolder = new FilterHolder((Filter)new XlrAccessControlFilter(this.permissionEnforcer(), this.serviceManager, this.xlrConfig().maintenanceModeEnabled()));
        contextRoot.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    public static final /* synthetic */ void $anonfun$addJettyErrorPages$1(ErrorPageErrorHandler x2$1, ErrorPage errorPage) {
        if (errorPage.isGlobal()) {
            x2$1.addErrorPage("org.eclipse.jetty.server.error_page.global", errorPage.getPath());
            return;
        }
        if (errorPage.getExceptionName() != null) {
            x2$1.addErrorPage(errorPage.getExceptionName(), errorPage.getPath());
            return;
        }
        x2$1.addErrorPage(errorPage.getStatusCode(), errorPage.getPath());
    }

    public ReleaseJettyServletWebServerFactory(ServerConfiguration serverConfiguration, XlrConfig xlrConfig, PermissionEnforcer permissionEnforcer, MeterRegistry meterRegistry, XlrServiceManager serviceManager) {
        this.serverConfiguration = serverConfiguration;
        this.xlrConfig = xlrConfig;
        this.permissionEnforcer = permissionEnforcer;
        this.meterRegistry = meterRegistry;
        this.serviceManager = serviceManager;
    }
}

