package com.xebialabs.xlrelease.actors.extension

import com.xebialabs.xlrelease.actors.{ActorSystemHolder, ExceptionTranslate}
import com.xebialabs.xlrelease.domain.Release
import org.apache.pekko.actor.Actor.Receive
import org.apache.pekko.actor.{Actor, ActorRef, ActorSystem, Status}

import scala.util.{Failure, Success, Try}


trait ActorExtensionHandlerFactory extends ExceptionTranslate {
  def actorSystemHolder: ActorSystemHolder

  override def actorSystem: ActorSystem = actorSystemHolder.unmanagedActorSystem

  def supports(clazz: Class[_ <: Actor]): Boolean

  def getHandler(self: ActorRef, sender: () => ActorRef, release: => Release): Receive

  protected def replyOrFail[T](sender: () => ActorRef)(call: => T): Unit = sender() ! (Try(call) match {
    case Success(t) if t != null => t
    case Success(t) => Status.Failure(new NullPointerException("Method returned null and this cannot be processed"))
    case Failure(ex) => Status.Failure(translate(ex))
  })

}
