/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.license;

import com.xebialabs.license.DummyLicense;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseParseException;
import com.xebialabs.license.LicenseUtils;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.domain.management.ServiceStatus;
import com.xebialabs.xlrelease.license.XLRLicenseInstallService;
import com.xebialabs.xlrelease.service.XlrServiceLifecycle;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001\u0002\u0007\u000e\u0001YA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\ta\u0001\u0011\t\u0011)A\u0005c!)q\u0007\u0001C\u0001q!91\n\u0001b\u0001\n\u0003a\u0005BB,\u0001A\u0003%Q\nC\u0003Y\u0001\u0011\u0005\u0013\fC\u0003^\u0001\u0011\u0005a\fC\u0003c\u0001\u0011%1\rC\u0003n\u0001\u0011%a\u000eC\u0003x\u0001\u0011%\u0001\u0010\u0003\u0004\u0002P\u0001!\tA\u0018\u0002 \u0019&\u001cWM\\:f\t\n\u001b\u0016P\\2J]&$\u0018.\u00197ju\u0016\u00148+\u001a:wS\u000e,'B\u0001\b\u0010\u0003\u001da\u0017nY3og\u0016T!\u0001E\t\u0002\u0013ad'/\u001a7fCN,'B\u0001\n\u0014\u0003%AXMY5bY\u0006\u00147OC\u0001\u0015\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001q#H\u0013\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tq2%D\u0001 \u0015\t\u0001\u0013%A\u0003tY\u001a$$NC\u0001#\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0013 \u0005\u001daunZ4j]\u001e\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001K\b\u0002\u000fM,'O^5dK&\u0011!f\n\u0002\u001412\u00148+\u001a:wS\u000e,G*\u001b4fGf\u001cG.Z\u0001\u0016Y&\u001cWM\\:f\u0013:\u001cH/\u00197m'\u0016\u0014h/[2f!\tic&D\u0001\u000e\u0013\tySB\u0001\rY\u0019Jc\u0015nY3og\u0016Len\u001d;bY2\u001cVM\u001d<jG\u0016\fa\u0002\\5dK:\u001cXmU3sm&\u001cW\r\u0005\u00023k5\t1G\u0003\u0002)i)\u0011a\"E\u0005\u0003mM\u0012a\u0002T5dK:\u001cXmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0004siZ\u0004CA\u0017\u0001\u0011\u0015Y3\u00011\u0001-\u0011\u0015\u00014\u00011\u00012Q\t\u0019Q\b\u0005\u0002?\u00136\tqH\u0003\u0002A\u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\t\u001b\u0015a\u00024bGR|'/\u001f\u0006\u0003\t\u0016\u000bQAY3b]NT!AR$\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001S\u0001\u0004_J<\u0017B\u0001&@\u0005%\tU\u000f^8xSJ,G-A\u000bM\u0013\u000e+ejU#`\r&cUiX#O\u0007>#\u0015JT$\u0016\u00035\u0003\"AT+\u000e\u0003=S!\u0001U)\u0002\u000f\rD\u0017M]:fi*\u0011!kU\u0001\u0004]&|'\"\u0001+\u0002\t)\fg/Y\u0005\u0003->\u0013qa\u00115beN,G/\u0001\fM\u0013\u000e+ejU#`\r&cUiX#O\u0007>#\u0015JT$!\u0003!9W\r^(sI\u0016\u0014H#\u0001.\u0011\u0005aY\u0016B\u0001/\u001a\u0005\rIe\u000e^\u0001\bI>\u001cF/\u0019:u)\u0005y\u0006C\u0001\ra\u0013\t\t\u0017D\u0001\u0003V]&$\u0018\u0001H4fi2K7-\u001a8tK\u001a\u0013x.\\'f[>\u0014\u00180\u00134Fq&\u001cHo]\u000b\u0002IB\u0019\u0001$Z4\n\u0005\u0019L\"AB(qi&|g\u000e\u0005\u0002iW6\t\u0011N\u0003\u0002k'\u0006!A.\u00198h\u0013\ta\u0017N\u0001\u0004TiJLgnZ\u0001\u0010e\u0016\fG\rT5dK:\u001cXMR5mKR\u0011qm\u001c\u0005\u0006a&\u0001\r!]\u0001\fY&\u001cWM\\:f\r&dW\r\u0005\u0002sk6\t1O\u0003\u0002u'\u0006\u0011\u0011n\\\u0005\u0003mN\u0014AAR5mK\u0006\u0001\"/Z1e\r&dW\rV8TiJLgn\u001a\u000b\u0003OfDQA\u001f\u0006A\u0002E\fAAZ5mK\"\"!\u0002`A\u0003!\rARp`\u0005\u0003}f\u0011a\u0001\u001e5s_^\u001c\bc\u0001:\u0002\u0002%\u0019\u00111A:\u0003\u0017%{U\t_2faRLwN\\\u0019\b=\u0005\u001d\u00111DA'!\u0011\tI!a\u0006\u000f\t\u0005-\u00111\u0003\t\u0004\u0003\u001bIRBAA\b\u0015\r\t\t\"F\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005U\u0011$\u0001\u0004Qe\u0016$WMZ\u0005\u0004Y\u0006e!bAA\u000b3EJ1%!\b\u0002&\u0005\r\u0013qE\u000b\u0005\u0003?\t\t#\u0006\u0002\u0002\b\u00119\u00111E\u000bC\u0002\u00055\"!\u0001+\n\t\u0005\u001d\u0012\u0011F\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\u0005-\u0012$\u0001\u0004uQJ|wo]\t\u0005\u0003_\t)\u0004E\u0002\u0019\u0003cI1!a\r\u001a\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u000e\u0002>9\u0019\u0001$!\u000f\n\u0007\u0005m\u0012$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0012\u0011\t\u0002\n)\"\u0014xn^1cY\u0016T1!a\u000f\u001ac%\u0019\u0013QIA$\u0003\u0013\nYCD\u0002\u0019\u0003\u000fJ1!a\u000b\u001ac\u0015\u0011\u0003$GA&\u0005\u0015\u00198-\u00197bc\t1s0\u0001\u0004e_N#x\u000e\u001d\u0015\u0004\u0001\u0005M\u0003\u0003BA+\u00037j!!a\u0016\u000b\u0007\u0005eS)\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!\u0018\u0002X\tI1i\\7q_:,g\u000e\u001e")
public class LicenseDBSyncInitializerService
implements XlrServiceLifecycle {
    private final XLRLicenseInstallService licenseInstallService;
    private final LicenseService licenseService;
    private final Charset LICENSE_FILE_ENCODING;
    private Enumeration.Value state;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String serviceName() {
        return XlrServiceLifecycle.serviceName$(this);
    }

    @Override
    public void start() {
        XlrServiceLifecycle.start$(this);
    }

    @Override
    public void awaitStart() {
        XlrServiceLifecycle.awaitStart$(this);
    }

    @Override
    public void stop() {
        XlrServiceLifecycle.stop$(this);
    }

    @Override
    public void awaitStop() {
        XlrServiceLifecycle.awaitStop$(this);
    }

    @Override
    public boolean isRunning() {
        return XlrServiceLifecycle.isRunning$(this);
    }

    @Override
    public ServiceStatus serviceStatus() {
        return XlrServiceLifecycle.serviceStatus$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Enumeration.Value state() {
        return this.state;
    }

    @Override
    public void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        LicenseDBSyncInitializerService licenseDBSyncInitializerService = this;
        synchronized (licenseDBSyncInitializerService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Charset LICENSE_FILE_ENCODING() {
        return this.LICENSE_FILE_ENCODING;
    }

    public int getOrder() {
        return 45;
    }

    @Override
    public void doStart() {
        this.logger().trace((Function0 & Serializable)() -> "Initializing license DB sync");
        Option<String> option = this.getLicenseFromMemoryIfExists();
        if (option instanceof Some) {
            Some some = (Some)option;
            String memoryLicenseContent = (String)some.value();
            this.logger().trace((Function0 & Serializable)() -> "License exists on node's filesystem. Storing the license in DB...");
            this.licenseInstallService.storeInDB(memoryLicenseContent);
            this.licenseInstallService.broadcastLicenseRenewal();
            return;
        }
        if (None$.MODULE$.equals(option)) {
            Option<String> option2 = this.licenseInstallService.findLicenseInDB();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String dbLicenseContent = (String)some.value();
                this.logger().trace((Function0 & Serializable)() -> "License doesn't exist on node's filesystem. Pulling the existing license from DB...");
                this.licenseInstallService.install(dbLicenseContent);
            } else if (None$.MODULE$.equals(option2)) {
                this.logger().trace((Function0 & Serializable)() -> "License doesn't exist in DB and isn't installed in node's memory. Doing nothing");
            } else {
                throw new MatchError(option2);
            }
            return;
        }
        throw new MatchError(option);
    }

    private Option<String> getLicenseFromMemoryIfExists() {
        License inMemoryLicense = this.licenseService.getLicense();
        if (inMemoryLicense != null && !(inMemoryLicense instanceof DummyLicense)) {
            File licenseFile = new File(XlrConfig$.MODULE$.getInstance().license_location());
            String licenseContent = this.readLicenseFile(licenseFile);
            return new Some((Object)licenseContent);
        }
        return None$.MODULE$;
    }

    private String readLicenseFile(File licenseFile) {
        String string;
        try {
            String data = this.readFileToString(licenseFile);
            string = LicenseUtils.decodeIfNecessary((String)data);
        }
        catch (IOException e) {
            throw new LicenseParseException(String.format("Unable to read license file '%s'", licenseFile), (Throwable)e);
        }
        return string;
    }

    private String readFileToString(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()), this.LICENSE_FILE_ENCODING()).replaceAll("\\r\\n?", "\n");
    }

    @Override
    public void doStop() {
    }

    @Autowired
    public LicenseDBSyncInitializerService(XLRLicenseInstallService licenseInstallService, LicenseService licenseService) {
        this.licenseInstallService = licenseInstallService;
        this.licenseService = licenseService;
        Logging.$init$((Logging)this);
        XlrServiceLifecycle.$init$(this);
        this.LICENSE_FILE_ENCODING = StandardCharsets.UTF_8;
    }
}

