/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseRepository;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.IdAndStatus;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.service.TaskConcurrencyService;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\tmf\u0001B\u0016-\u0001UB\u0001b\u0013\u0001\u0003\u0006\u0004%\t\u0001\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005\u001b\"AA\u000b\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003W\u0011!Q\u0006A!b\u0001\n\u0003Y\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\u0001\u0004!Q1A\u0005\u0002\u0005D\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\tM\u0002\u0011)\u0019!C\u0001O\"Aa\u000e\u0001B\u0001B\u0003%\u0001\u000e\u0003\u0005p\u0001\t\u0015\r\u0011\"\u0001q\u0011!!\bA!A!\u0002\u0013\t\b\u0002C;\u0001\u0005\u000b\u0007I\u0011\u0001<\t\u0011i\u0004!\u0011!Q\u0001\n]D\u0001b\u001f\u0001\u0003\u0006\u0004%\t\u0001 \u0005\n\u0003\u0003\u0001!\u0011!Q\u0001\nuD!\"a\u0001\u0001\u0005\u000b\u0007I\u0011AA\u0003\u0011)\ti\u0001\u0001B\u0001B\u0003%\u0011q\u0001\u0005\u000b\u0003\u001f\u0001!Q1A\u0005\u0002\u0005E\u0001BCA\r\u0001\t\u0005\t\u0015!\u0003\u0002\u0014!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001\"CA*\u0001\t\u0007I\u0011AA+\u0011!\ty\b\u0001Q\u0001\n\u0005]\u0003bBAA\u0001\u0011\u0005\u00111\u0011\u0005\b\u0003o\u0003A\u0011AA]\u0011\u001d\t9\f\u0001C\u0001\u0003+Dq!!8\u0001\t\u0003\ty\u000eC\u0004\u0002x\u0002!\t!!?\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010!9!Q\u0003\u0001\u0005\u0002\t]\u0001b\u0002B\u0018\u0001\u0011\u0005!\u0011\u0007\u0005\b\u0005s\u0001A\u0011\u0001B\u001e\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0005\u000bBqAa\u0013\u0001\t\u0013\u0011i\u0005C\u0004\u0003T\u0001!\tA!\u0016\t\u000f\t\u001d\u0004\u0001\"\u0001\u0003j!9!1\u000f\u0001\u0005\u0002\tU\u0004b\u0002BB\u0001\u0011%!Q\u0011\u0005\b\u0005\u0013\u0003A\u0011\u0002BF\u0011\u001d\u0011\u0019\n\u0001C\t\u0005+CqAa'\u0001\t#\u0011i\nC\u0004\u0003\"\u0002!\tBa)\u0003#\u0011+\u0007/\u001a8eK:\u001c\u0017pU3sm&\u001cWM\u0003\u0002.]\u000591/\u001a:wS\u000e,'BA\u00181\u0003%AHN]3mK\u0006\u001cXM\u0003\u00022e\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002g\u0005\u00191m\\7\u0004\u0001M)\u0001A\u000e\u001fA\u0007B\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t1\u0011I\\=SK\u001a\u0004\"!\u0010 \u000e\u00031J!a\u0010\u0017\u0003%I+G.Z1tKR\u0013X-\u001a\"vS2$WM\u001d\t\u0003{\u0005K!A\u0011\u0017\u00039\u0011+\u0007/\u001a8eK:\u001c\u0017pQ1oI&$\u0017\r^3D_2dWm\u0019;peB\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\u0006g24GG\u001b\u0006\u0002\u0011\u0006AqM]5{u2,G-\u0003\u0002K\u000b\n9Aj\\4hS:<\u0017!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssV\tQ\n\u0005\u0002O#6\tqJ\u0003\u0002Q]\u0005Q!/\u001a9pg&$xN]=\n\u0005I{%!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006\u0011\"/\u001a7fCN,'+\u001a9pg&$xN]=!\u0003Q\u0011X\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dKV\ta\u000b\u0005\u0002>/&\u0011\u0001\f\f\u0002\u0015%\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0002+I,G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2fA\u0005\u0011\u0002\u000f\\1o\u0013R,WNU3q_NLGo\u001c:z+\u0005a\u0006C\u0001(^\u0013\tqvJ\u0001\nQY\u0006t\u0017\n^3n%\u0016\u0004xn]5u_JL\u0018a\u00059mC:LE/Z7SKB|7/\u001b;pef\u0004\u0013\u0001\u00063fa\u0016tG-\u001a8dsJ+\u0007o\\:ji>\u0014\u00180F\u0001c!\tq5-\u0003\u0002e\u001f\n!B)\u001a9f]\u0012,gnY=SKB|7/\u001b;pef\fQ\u0003Z3qK:$WM\\2z%\u0016\u0004xn]5u_JL\b%\u0001\u0005fm\u0016tGOQ;t+\u0005A\u0007CA5m\u001b\u0005Q'BA6/\u0003\u0019)g/\u001a8ug&\u0011QN\u001b\u0002\t\u000bZ,g\u000e\u001e\"vg\u0006IQM^3oi\n+8\u000fI\u0001\u000fi\u0006\u001c8NU3q_NLGo\u001c:z+\u0005\t\bC\u0001(s\u0013\t\u0019xJ\u0001\bUCN\\'+\u001a9pg&$xN]=\u0002\u001fQ\f7o\u001b*fa>\u001c\u0018\u000e^8ss\u0002\nq\u0002\u001d5bg\u0016\u0014V\r]8tSR|'/_\u000b\u0002oB\u0011a\n_\u0005\u0003s>\u0013q\u0002\u00155bg\u0016\u0014V\r]8tSR|'/_\u0001\u0011a\"\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0002\n1bY5JIN+'O^5dKV\tQ\u0010\u0005\u0002>}&\u0011q\u0010\f\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\u0007dS&#7+\u001a:wS\u000e,\u0007%\u0001\tbe\u000eD\u0017N^5oON+'O^5dKV\u0011\u0011q\u0001\t\u0004{\u0005%\u0011bAA\u0006Y\t\u0001\u0012I]2iSZLgnZ*feZL7-Z\u0001\u0012CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u0004\u0013A\u0006;bg.\u001cuN\\2veJ,gnY=TKJ4\u0018nY3\u0016\u0005\u0005M\u0001cA\u001f\u0002\u0016%\u0019\u0011q\u0003\u0017\u0003-Q\u000b7o[\"p]\u000e,(O]3oGf\u001cVM\u001d<jG\u0016\fq\u0003^1tW\u000e{gnY;se\u0016t7-_*feZL7-\u001a\u0011\u0002\rqJg.\u001b;?)Y\ty\"!\t\u0002$\u0005\u0015\u0012qEA\u0015\u0003W\ti#a\f\u00022\u0005M\u0002CA\u001f\u0001\u0011\u0015YU\u00031\u0001N\u0011\u0015!V\u00031\u0001W\u0011\u0015QV\u00031\u0001]\u0011\u0015\u0001W\u00031\u0001c\u0011\u00151W\u00031\u0001i\u0011\u0015yW\u00031\u0001r\u0011\u0015)X\u00031\u0001x\u0011\u0015YX\u00031\u0001~\u0011\u001d\t\u0019!\u0006a\u0001\u0003\u000fAq!a\u0004\u0016\u0001\u0004\t\u0019\u0002K\u0002\u0016\u0003o\u0001B!!\u000f\u0002P5\u0011\u00111\b\u0006\u0005\u0003{\ty$\u0001\u0006b]:|G/\u0019;j_:TA!!\u0011\u0002D\u00059a-Y2u_JL(\u0002BA#\u0003\u000f\nQAY3b]NTA!!\u0013\u0002L\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002N\u0005\u0019qN]4\n\t\u0005E\u00131\b\u0002\n\u0003V$xn^5sK\u0012\f\u0001$Y2uSZ,G)\u001a9f]\u0012,gnY=Ti\u0006$Xo]3t+\t\t9\u0006\u0005\u0004\u0002Z\u0005%\u0014q\u000e\b\u0005\u00037\n)G\u0004\u0003\u0002^\u0005\rTBAA0\u0015\r\t\t\u0007N\u0001\u0007yI|w\u000e\u001e \n\u0003eJ1!a\u001a9\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001b\u0002n\t\u00191+Z9\u000b\u0007\u0005\u001d\u0004\b\u0005\u0003\u0002r\u0005ed\u0002BA:\u0003k\u00022!!\u00189\u0013\r\t9\bO\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0014Q\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]\u0004(A\rbGRLg/\u001a#fa\u0016tG-\u001a8dsN#\u0018\r^;tKN\u0004\u0013AB2sK\u0006$X\r\u0006\u0004\u0002\u0006\u0006E\u00151\u0014\t\u0005\u0003\u000f\u000bi)\u0004\u0002\u0002\n*\u0019\u00111\u0012\u0018\u0002\r\u0011|W.Y5o\u0013\u0011\ty)!#\u0003\u0015\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010C\u0004\u0002\u0014b\u0001\r!!&\u0002\t\u001d\fG/\u001a\t\u0005\u0003\u000f\u000b9*\u0003\u0003\u0002\u001a\u0006%%\u0001C$bi\u0016$\u0016m]6\t\u000f\u0005u\u0005\u00041\u0001\u0002p\u0005\u0011B/\u0019:hKRLEm\u0014:WCJL\u0017M\u00197fQ\rA\u0012\u0011\u0015\t\u0005\u0003G\u000b\u0019,\u0004\u0002\u0002&*!\u0011QHAT\u0015\u0011\tI+a+\u0002\t\r|'/\u001a\u0006\u0005\u0003[\u000by+\u0001\u0006nS\u000e\u0014x.\\3uKJT!!!-\u0002\u0005%|\u0017\u0002BA[\u0003K\u0013Q\u0001V5nK\u0012\fA\"\u001e9eCR,G+\u0019:hKR$\u0002\"!\"\u0002<\u0006}\u0016\u0011\u0019\u0005\b\u0003{K\u0002\u0019AA8\u00031!W\r]3oI\u0016t7-_%e\u0011\u001d\ti*\u0007a\u0001\u0003_Bq!a1\u001a\u0001\u0004\t)-\u0001\u0006n_\u0012Lg-[3e\u0003R\u0004B!a2\u0002R6\u0011\u0011\u0011\u001a\u0006\u0005\u0003\u0017\fi-\u0001\u0003uS6,'\u0002BAh\u0003\u0017\nAA[8eC&!\u00111[Ae\u0005!!\u0015\r^3US6,GCBAC\u0003/\fI\u000eC\u0004\u0002>j\u0001\r!a\u001c\t\u000f\u0005u%\u00041\u0001\u0002p!\u001a!$!)\u0002\r\u0011,G.\u001a;f)\u0019\t\t/a:\u0002rB\u0019q'a9\n\u0007\u0005\u0015\bH\u0001\u0003V]&$\bbBAu7\u0001\u0007\u00111^\u0001\be\u0016dW-Y:f!\u0011\t9)!<\n\t\u0005=\u0018\u0011\u0012\u0002\b%\u0016dW-Y:f\u0011\u001d\t\u0019p\u0007a\u0001\u0003_\n!!\u001b3)\u0007m\t\t+A\u000bhKR\u001cu.\u001c9mKR\f'\r\\3HCR,\u0017\nZ:\u0015\t\u0005]\u00131 \u0005\b\u0003{d\u0002\u0019AA\u0000\u0003\u001d!\u0018M]4fiN\u0004b!!\u001d\u0003\u0002\t\u0015\u0011\u0002\u0002B\u0002\u0003{\u00121aU3u!\u0011\t9Ia\u0002\n\t\t%\u0011\u0011\u0012\u0002\t!2\fg.\u0013;f[\"\u001aA$!)\u00023\u0019,Go\u00195EKB,g\u000eZ3oi>\u0003XM\\$bi\u0016LEm\u001d\u000b\u0005\u0003/\u0012\t\u0002C\u0004\u0002~v\u0001\r!a@)\u0007u\t\t+A\rgS:$\u0017i\u0019;jm\u0016LenY8nS:<w)\u0019;f\u0013\u0012\u001cH\u0003\u0002B\r\u0005S\u0001bAa\u0007\u0003&\u0005=TB\u0001B\u000f\u0015\u0011\u0011yB!\t\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005G\tAA[1wC&!!q\u0005B\u000f\u0005\u0011a\u0015n\u001d;\t\u000f\t-b\u00041\u0001\u0002p\u0005I!/\u001a7fCN,\u0017\n\u001a\u0015\u0004=\u0005\u0005\u0016A\b4j]\u0012\f5\r^5wK&s7m\\7j]\u001e$U\r]3oI\u0016t7-[3t)\u0011\u0011\u0019D!\u000e\u0011\r\u0005e\u0013\u0011NAC\u0011\u001d\u00119d\ba\u0001\u0003_\n\u0001\u0002]1sK:$\u0018\nZ\u0001\u0013O\u0016$h)Y5mC\ndWmR1uK&#7\u000f\u0006\u0003\u0002X\tu\u0002b\u0002B A\u0001\u0007\u0011q`\u0001\u000fC\n|'\u000f^3e)\u0006\u0014x-\u001a;tQ\r\u0001\u0013\u0011U\u0001\u001cM&tG-Q2uSZ,w*\u001e;h_&tw\rV1sO\u0016$\u0018\nZ:\u0015\t\te!q\t\u0005\b\u0005W\t\u0003\u0019AA8Q\r\t\u0013\u0011U\u0001\u001aM&tG-Q2uSZ,w*\u001e;h_&tw\rV1sO\u0016$8\u000f\u0006\u0003\u0003P\tE\u0003CBA-\u0003S\u0012)\u0001C\u0004\u0003,\t\u0002\r!a\u001c\u0002\u001d\u001d,GOU3mK\u0006\u001cX\r\u0016:fKR!!q\u000bB2!\u0011\u0011IFa\u0018\u000e\u0005\tm#b\u0001B/]\u0005)a/[3xg&!!\u0011\rB.\u0005-\u0011V\r\\3bg\u0016$&/Z3\t\u000f\t-2\u00051\u0001\u0002p!\u001a1%!)\u0002'\u0005\u00148\r[5wK\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\r\u0005\u0005(1\u000eB7\u0011\u001d\u0011Y\u0003\na\u0001\u0003_BqAa\u001c%\u0001\u0004\t9&A\u0007eKB,g\u000eZ3oGfLEm\u001d\u0015\u0004I\u0005\u0005\u0016A\b4j]\u0012$U\r]3oI\u0016t7-\u001f+be\u001e,GOQ=UCJ<W\r^%e)\u0011\u00119H! \u0011\u0007u\u0012I(C\u0002\u0003|1\u00121\"\u00133B]\u0012\u001cF/\u0019;vg\"9!qP\u0013A\u0002\u0005=\u0014\u0001\u0003;be\u001e,G/\u00133)\u0007\u0015\n\t+A\u0005hKR\u001cF/\u0019;vgR!\u0011q\u000eBD\u0011\u001d\u0011yH\na\u0001\u0003_\na#\u001e9eCR,G+\u0019:hKR$U\r]3oI\u0016t7-\u001f\u000b\t\u0003\u000b\u0013iIa$\u0003\u0012\"9\u0011QX\u0014A\u0002\u0005=\u0004bBAOO\u0001\u0007\u0011q\u000e\u0005\b\u0003';\u0003\u0019AAK\u0003u1\u0017N\u001c3J]B\u0013xn\u001a:fgNLenY8nS:<w)\u0019;f\u0013\u0012\u001cH\u0003BA,\u0005/CqA!')\u0001\u0004\t9&A\u0005uCJ<W\r^%eg\u0006ya-\u001b8e\u001fB,gnR1uK&#7\u000f\u0006\u0003\u0002X\t}\u0005b\u0002BMS\u0001\u0007\u0011qK\u0001\u000bSN$V-\u001c9mCR,G\u0003\u0002BS\u0005W\u00032a\u000eBT\u0013\r\u0011I\u000b\u000f\u0002\b\u0005>|G.Z1o\u0011\u001d\tiL\u000ba\u0001\u0003_B3\u0001\u0001BX!\u0011\u0011\tLa.\u000e\u0005\tM&\u0002\u0002B[\u0003\u000f\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0011ILa-\u0003\u000fM+'O^5dK\u0002")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final EventBus eventBus;
    private final TaskRepository taskRepository;
    private final PhaseRepository phaseRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final TaskConcurrencyService taskConcurrencyService;
    private final scala.collection.immutable.Seq<String> activeDependencyStatuses;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public java.util.List<Dependency> findByReleaseId(String releaseId) {
        return DependencyCandidateCollector.findByReleaseId$(this, releaseId);
    }

    @Override
    @Timed
    public java.util.List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public scala.collection.immutable.Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, scala.collection.immutable.Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public PhaseRepository phaseRepository() {
        return this.phaseRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public TaskConcurrencyService taskConcurrencyService() {
        return this.taskConcurrencyService;
    }

    public scala.collection.immutable.Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't add a dependency to a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkCreateDependency((Task)gate);
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return dependency;
    }

    public Dependency updateTarget(String dependencyId, String targetIdOrVariable, DateTime modifiedAt) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        this.taskConcurrencyService().checkConcurrentModification((Task)gate, modifiedAt);
        return this.updateTargetDependency(dependencyId, targetIdOrVariable, gate);
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        return this.updateTargetDependency(dependencyId, targetIdOrVariable, gate);
    }

    @Timed
    public void delete(Release release, String id) {
        Option maybeDependency = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2.getDependencies()).asScala())).find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$delete$2(id, x$3)));
        Dependency dependency = (Dependency)maybeDependency.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Repository entity [" + id + "] not found", new Object[0]);
        });
        GateTask gate = dependency.getGateTask();
        LockedTaskOperationChecks$.MODULE$.checkDeleteDependency((Task)gate);
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public scala.collection.immutable.Seq<String> getCompletableGateIds(Set<PlanItem> targets) {
        scala.collection.immutable.Seq doneTargetIds = ((IterableOnceOps)((IterableOps)targets.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDone()))).map((Function1 & Serializable)x$5 -> x$5.getId())).toSeq();
        this.logger().trace((Function0 & Serializable)() -> "getCompletableGateIds doneTargetIds: " + doneTargetIds.mkString(", "));
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)doneTargetIds).map((Function1 & Serializable)id -> {
            GateTask item = (GateTask)this.taskRepository().findById((String)id);
            this.logger().trace((Function0 & Serializable)() -> "getCompletableGateIds item " + item.getId() + ": hasConditions = " + item.hasConditions() + ", hasDependencies = " + item.hasDependencies() + ", isOpen = " + item.isOpen() + ", status = " + item.getStatus());
            return item;
        })).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isCompletable()))).map((Function1 & Serializable)x$7 -> x$7.getId());
    }

    @Timed
    public scala.collection.immutable.Seq<String> fetchDependentOpenGateIds(Set<PlanItem> targets) {
        scala.collection.immutable.Seq targetIds = ((IterableOnceOps)targets.map((Function1 & Serializable)x$8 -> x$8.getId())).toSeq();
        this.logger().trace((Function0 & Serializable)() -> "fetchDependentOpenGateIds targetIds: " + targetIds.mkString(", "));
        return this.findOpenGateIds((scala.collection.immutable.Seq<String>)targetIds);
    }

    @Timed
    public java.util.List<String> findActiveIncomingGateIds(String releaseId) {
        Seq seq;
        if (this.releaseRepository().exists(releaseId)) {
            seq = (Seq)((SeqOps)this.findActiveIncomingDependencies(releaseId).map((Function1 & Serializable)dep -> Ids.getParentId((String)dep.getId()))).distinct();
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Release " + releaseId + " not found. It is either archived, or does not exist. Returning no dependencies");
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(seq).asJava();
    }

    public scala.collection.immutable.Seq<Dependency> findActiveIncomingDependencies(String parentId) {
        return this.dependencyRepository().findAllIncomingDependencies((scala.collection.immutable.Seq<String>)new .colon.colon((Object)parentId, (List)Nil$.MODULE$), this.activeDependencyStatuses(), true, false);
    }

    @Timed
    public scala.collection.immutable.Seq<String> getFailableGateIds(Set<PlanItem> abortedTargets) {
        return this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)((IterableOnceOps)abortedTargets.map((Function1 & Serializable)x$9 -> x$9.getId())).toSeq());
    }

    @Timed
    public java.util.List<String> findActiveOutgoingTargetIds(String releaseId) {
        java.util.List targetIds = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.findActiveOutgoingTargets(releaseId).map((Function1 & Serializable)x$10 -> x$10.getId())).asJava();
        return targetIds;
    }

    private scala.collection.immutable.Seq<PlanItem> findActiveOutgoingTargets(String releaseId) {
        java.util.List<Dependency> dependencies = this.findByReleaseId(releaseId);
        scala.collection.immutable.Seq targets = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(dependencies).asScala().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Dependency, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && (A1 = A12).hasResolvedTarget() && !A1.isDone()) {
                    return (B1)A1.getTarget();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Dependency x1) {
                Dependency dependency;
                Dependency dependency2 = x1;
                return dependency2 != null && (dependency = dependency2).hasResolvedTarget() && !dependency.isDone();
            }
        })).toSeq();
        return targets;
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        if (this.archivingService().exists(releaseId)) {
            return new ReleaseTree();
        }
        Map dependentReleases = (Map)Map$.MODULE$.empty();
        Release release = this.releaseRepository().findById(releaseId);
        this.toTreeItem(releaseId, (Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
        ReleaseTree tree = new ReleaseTree();
        tree.releaseId_$eq(releaseId);
        tree.dependentReleases_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)dependentReleases.values().toList()).asJava());
        return tree;
    }

    @Timed
    public void archiveDependencies(String releaseId, scala.collection.immutable.Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(referencingRelease.getAllGates()).asScala().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.getDependencies()).asScala())).filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable)x$12 -> {
            x$12.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (scala.collection.immutable.Seq<Dependency>)dependenciesToArchive.toSeq());
    }

    @Timed
    public IdAndStatus findDependencyTargetByTargetId(String targetId) {
        return new IdAndStatus(targetId, this.getStatus(targetId));
    }

    private String getStatus(String targetId) {
        Option option;
        Option option2;
        Option option3;
        String string = targetId;
        if (string != null && !(option3 = IdMatchers.ReleaseId$.MODULE$.unapply(string)).isEmpty()) {
            return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.releaseRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        return (B1)this.$outer.archivingService().getRelease(this.targetId$1).getStatus().toString();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return throwable != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException("Release [" + targetId + "] not found", new Object[0]);
            });
        }
        if (string != null && !(option2 = IdMatchers.PhaseId$.MODULE$.unapply(string)).isEmpty()) {
            return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.phaseRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 != null) {
                        return (B1)this.$outer.archivingService().getPhase(this.targetId$1).getStatus().toString();
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    return throwable != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException("Phase [" + targetId + "] not found", new Object[0]);
            });
        }
        if (string != null && !(option = IdMatchers.TaskId$.MODULE$.unapply(string)).isEmpty()) {
            return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.taskRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 != null) {
                        return (B1)this.$outer.archivingService().getTask(this.targetId$1).getStatus().toString();
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(Throwable x3) {
                    Throwable throwable = x3;
                    return throwable != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException("Task [" + targetId + "] not found", new Object[0]);
            });
        }
        throw new NotFoundException("Target is not plan item, targetId= " + targetId, new Object[0]);
    }

    private Dependency updateTargetDependency(String dependencyId, String targetIdOrVariable, GateTask gate) {
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't edit a dependency on a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkUpdateDependency((Task)gate);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        this.taskConcurrencyService().updateLastModifiedDetails((Task)gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    public scala.collection.immutable.Seq<String> findInProgressIncomingGateIds(scala.collection.immutable.Seq<String> targetIds) {
        return (scala.collection.immutable.Seq)((SeqOps)this.dependencyRepository().findAllIncomingDependencies(targetIds, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)TaskStatus.IN_PROGRESS.name(), (List)Nil$.MODULE$), false, this.dependencyRepository().findAllIncomingDependencies$default$4()).map((Function1 & Serializable)dep -> Ids.getParentId((String)dep.getId()))).distinct();
    }

    public scala.collection.immutable.Seq<String> findOpenGateIds(scala.collection.immutable.Seq<String> targetIds) {
        return (scala.collection.immutable.Seq)((SeqOps)this.dependencyRepository().findAllIncomingDependencies(targetIds, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)TaskStatus.IN_PROGRESS.name(), (List)new .colon.colon((Object)TaskStatus.FAILING.name(), (List)Nil$.MODULE$)), false, this.dependencyRepository().findAllIncomingDependencies$default$4()).map((Function1 & Serializable)dep -> Ids.getParentId((String)dep.getId()))).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    public static final /* synthetic */ boolean $anonfun$delete$2(String id$1, Dependency x$3) {
        String string = x$3.getId();
        String string2 = Ids.normalizeId((String)id$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, EventBus eventBus, TaskRepository taskRepository, PhaseRepository phaseRepository, CiIdService ciIdService, ArchivingService archivingService, TaskConcurrencyService taskConcurrencyService) {
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.phaseRepository = phaseRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        this.taskConcurrencyService = taskConcurrencyService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (scala.collection.immutable.Seq)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).$colon$plus((Object)TaskStatus.PLANNED)).map((Function1 & Serializable)x$1 -> x$1.name());
    }
}

