package com.xebialabs.xlrelease.api.internal

import com.xebialabs.deployit.plugin.api.reflect.{DescriptorRegistry, Type}
import com.xebialabs.xlrelease.domain.TaskDefinition._

import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._

case class TypeNode(@BeanProperty typeName: String,
                    @BeanProperty label: String,
                    @BeanProperty subtypes: java.util.List[TypeNode],
                    @BeanProperty virtual: Boolean)

object TypeNode {

  def apply(t: Type, subTypes: List[TypeNode] = Nil): TypeNode = new TypeNode(t.toString, getLabel(t), subTypes.asJava, t.getDescriptor.isVirtual)

  protected def buildTree(current: Type, typesMap: Map[Option[Type], List[Type]]): TypeNode = {
    val node = TypeNode(current)
    typesMap.get(Some(current)).fold(node) { children =>
      val rest = typesMap - Some(current)
      node.copy(subtypes = children.map(buildTree(_, rest)).asJava)
    }
  }

  def buildHierarchy(focusType: Type, topType: Type): TypeNode = {
    val subTypes: Map[Option[Type], Iterable[Type]] = DescriptorRegistry
      .getSubtypes(focusType)
      .asScala
      .groupBy(_.getDescriptor.getSuperClasses.asScala.headOption)

    val superTypes = focusType.getDescriptor.getSuperClasses.asScala.toList
    topType.getDescriptor.getSuperClasses.asScala.headOption
      .fold(superTypes)(top => superTypes.takeWhile(_ != top))
      .foldLeft(buildTree(focusType, subTypes.view.mapValues(_.toList).toMap)) {
        case (node: TypeNode, t: Type) => TypeNode(t, List(node))
      }
  }

  protected def getLabel(current: Type): String = s"${getDisplayGroup(current)}: ${getDisplayName(current)}"
}
