package com.xebialabs.xlrelease.upgrade.json

import com.xebialabs.xlrelease.domain.status.ReleaseStatus
import com.xebialabs.xlrelease.upgrade.json.XLReleaseEditTriggersPermissionJson.{PROPERTY_PERMISSIONS, PROPERTY_STATUS, PROPERTY_TEAMS}
import com.xebialabs.xlrelease.upgrade.{ImportUpgrade, UpgradeResult}
import org.codehaus.jettison.json.{JSONArray, JSONObject}

import scala.jdk.CollectionConverters._

trait XLReleaseEditTriggersPermissionJson extends ImportUpgrade {
  def performUpgrade(release: JSONObject): UpgradeResult = {

    val releaseStatus = release.optString(PROPERTY_STATUS)

    if (ReleaseStatus.TEMPLATE.value().equalsIgnoreCase(releaseStatus)) {

      val teams = Option(release.optJSONArray(PROPERTY_TEAMS)).getOrElse(new JSONArray())

      for (i <- 0 until teams.length()) {
        val permissionsJSONArray = Option(teams.getJSONObject(i).optJSONArray(PROPERTY_PERMISSIONS)).getOrElse(new JSONArray())
        val permissions = for {
          i <- 0 until permissionsJSONArray.length()
          permission: String = permissionsJSONArray.getString(i)
        } yield permission
        processPermissions(permissionsJSONArray, permissions)
      }
    }

    new UpgradeResult(true, List.empty.asJava)
  }

  protected def processPermissions(permissionsJSONArray: JSONArray, permissions: Seq[String]): Unit
}

object XLReleaseEditTriggersPermissionJson {
  val PROPERTY_STATUS: String = "status"
  val PROPERTY_TEAMS: String = "teams"
  val PROPERTY_PERMISSIONS: String = "permissions"
}
