/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.config.XlrConfig$FeaturesSettings$datacenter$stateChangeCoolDown$;
import com.xebialabs.xlrelease.domain.Datacenter;
import com.xebialabs.xlrelease.domain.DatacenterTargetState;
import com.xebialabs.xlrelease.domain.events.DatacenterCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DatacenterDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DatacenterUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.RateLimitReachedException;
import com.xebialabs.xlrelease.repository.DatacenterRepository;
import com.xebialabs.xlrelease.service.XlrServiceManager;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001B\f\u0019\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011!Y\u0006A!A!\u0002\u0013a\u0006\"\u00022\u0001\t\u0003\u0019\u0007\"C6\u0001\u0001\u0004\u0005\r\u0011\"\u0003m\u0011-\tI\u0001\u0001a\u0001\u0002\u0004%I!a\u0003\t\u0013q\u0004\u0001\u0019!A!B\u0013i\u0007\"CA\u0010\u0001\t\u0007I\u0011BA\u0011\u0011!\tY\u0004\u0001Q\u0001\n\u0005\r\u0002bBA\u001f\u0001\u0011\u0005\u0011q\b\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003KBq!a \u0001\t\u0013\t\t\tC\u0004\u0002\u000e\u0002!\t!a$\t\u000f\u0005M\u0005\u0001\"\u0001\u0002@!9\u0011Q\u0013\u0001\u0005\u0002\u0005}\u0002bBAL\u0001\u0011\u0005\u0011q\b\u0005\b\u00033\u0003A\u0011BAN\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!!-\u0001\t\u0013\t\u0019LA\tECR\f7-\u001a8uKJ\u001cVM\u001d<jG\u0016T!!\u0007\u000e\u0002\u000fM,'O^5dK*\u00111\u0004H\u0001\nq2\u0014X\r\\3bg\u0016T!!\b\u0010\u0002\u0013a,'-[1mC\n\u001c(\"A\u0010\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0011\u0003\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nQa\u001d7gi)T\u0011!L\u0001\tOJL'P\u001f7fI&\u0011qF\u000b\u0002\b\u0019><w-\u001b8h\u0003Q!\u0017\r^1dK:$XM\u001d*fa>\u001c\u0018\u000e^8ssB\u0011!'N\u0007\u0002g)\u0011AGG\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u001c4\u0005Q!\u0015\r^1dK:$XM\u001d*fa>\u001c\u0018\u000e^8ss\u0006I\u0001\u0010\u001c:D_:4\u0017n\u001a\t\u0003sqj\u0011A\u000f\u0006\u0003wi\taaY8oM&<\u0017BA\u001f;\u0005%AFN]\"p]\u001aLw-A\u0007uCN\\7k\u00195fIVdWM\u001d\t\u0003\u0001\u001ek\u0011!\u0011\u0006\u0003\u0005\u000e\u000b!b]2iK\u0012,H.\u001b8h\u0015\t!U)A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u00051\u0015aA8sO&\u0011\u0001*\u0011\u0002\u000e)\u0006\u001c8nU2iK\u0012,H.\u001a:)\t\rQE+\u0016\t\u0003\u0017Jk\u0011\u0001\u0014\u0006\u0003\u001b:\u000b!\"\u00198o_R\fG/[8o\u0015\ty\u0005+A\u0004gC\u000e$xN]=\u000b\u0005E\u001b\u0015!\u00022fC:\u001c\u0018BA*M\u0005%\tV/\u00197jM&,'/A\u0003wC2,X-I\u0001?\u0003EAHN]*feZL7-Z'b]\u0006<WM\u001d\t\u00031fk\u0011\u0001G\u0005\u00035b\u0011\u0011\u0003\u00177s'\u0016\u0014h/[2f\u001b\u0006t\u0017mZ3s\u0003!)g/\u001a8u\u0005V\u001c\bCA/a\u001b\u0005q&BA0\u001b\u0003\u0019)g/\u001a8ug&\u0011\u0011M\u0018\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0004eK\u001a<\u0017N\u001b\t\u00031\u0002AQ\u0001\r\u0004A\u0002EBQa\u000e\u0004A\u0002aBQA\u0010\u0004A\u0002}BCa\u001a&U+\")aK\u0002a\u0001/\")1L\u0002a\u00019\u0006\u00012\u000f^1uK\u000eCWmY6GkR,(/Z\u000b\u0002[B\u0012aN\u001f\t\u0004_ZDX\"\u00019\u000b\u0005E\u0014\u0018AC2p]\u000e,(O]3oi*\u00111\u000f^\u0001\u0005kRLGNC\u0001v\u0003\u0011Q\u0017M^1\n\u0005]\u0004(aD*dQ\u0016$W\u000f\\3e\rV$XO]3\u0011\u0005eTH\u0002\u0001\u0003\nw&\t\t\u0011!A\u0003\u0002u\u00141a\u0018\u00132\u0003E\u0019H/\u0019;f\u0007\",7m\u001b$viV\u0014X\rI\t\u0004}\u0006\r\u0001CA\u0012\u0000\u0013\r\t\t\u0001\n\u0002\b\u001d>$\b.\u001b8h!\r\u0019\u0013QA\u0005\u0004\u0003\u000f!#aA!os\u0006!2\u000f^1uK\u000eCWmY6GkR,(/Z0%KF$B!!\u0004\u0002\u0014A\u00191%a\u0004\n\u0007\u0005EAE\u0001\u0003V]&$\b\"CA\u000b\u0011\u0005\u0005\t\u0019AA\f\u0003\rAH%\r\u0019\u0005\u00033\ti\u0002\u0005\u0003pm\u0006m\u0001cA=\u0002\u001e\u0011Q10a\u0005\u0002\u0002\u0003\u0005)\u0011A?\u0002%\r,(O]3oiR\u000b'oZ3u'R\fG/Z\u000b\u0003\u0003G\u0001b!!\n\u0002,\u0005=RBAA\u0014\u0015\r\tI\u0003]\u0001\u0007CR|W.[2\n\t\u00055\u0012q\u0005\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026i\ta\u0001Z8nC&t\u0017\u0002BA\u001d\u0003g\u0011Q\u0003R1uC\u000e,g\u000e^3s)\u0006\u0014x-\u001a;Ti\u0006$X-A\ndkJ\u0014XM\u001c;UCJ<W\r^*uCR,\u0007%A\u000fwC2LG-\u0019;f\t\u0006$\u0018mY3oi\u0016\u00148\u000b^1uK\u000eC\u0017M\\4f)\t\ti!\u0001\bhKR$\u0015\r^1dK:$XM]:\u0015\u0005\u0005\u0015\u0003CBA$\u0003/\niF\u0004\u0003\u0002J\u0005Mc\u0002BA&\u0003#j!!!\u0014\u000b\u0007\u0005=\u0003%\u0001\u0004=e>|GOP\u0005\u0002K%\u0019\u0011Q\u000b\u0013\u0002\u000fA\f7m[1hK&!\u0011\u0011LA.\u0005\r\u0019V-\u001d\u0006\u0004\u0003+\"\u0003\u0003BA\u0019\u0003?JA!!\u0019\u00024\tQA)\u0019;bG\u0016tG/\u001a:\u0002%M,G\u000fR1uC\u000e,g\u000e^3s'R\fG/\u001a\u000b\u0007\u0003\u001b\t9'a\u001f\t\u000f\u0005%d\u00021\u0001\u0002l\u0005QA-\u0019;bG\u0016tG/\u001a:\u0011\t\u00055\u0014Q\u000f\b\u0005\u0003_\n\t\bE\u0002\u0002L\u0011J1!a\u001d%\u0003\u0019\u0001&/\u001a3fM&!\u0011qOA=\u0005\u0019\u0019FO]5oO*\u0019\u00111\u000f\u0013\t\u000f\u0005ud\u00021\u0001\u00020\u0005)1\u000f^1uK\u0006\u0011r-\u001a;DkJ\u0014XM\u001c;Vg\u0016\u0014h.Y7f+\t\t\u0019\t\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\r\tI\t^\u0001\u0005Y\u0006tw-\u0003\u0003\u0002x\u0005\u001d\u0015\u0001\u00053fY\u0016$X\rR1uC\u000e,g\u000e^3s)\u0011\ti!!%\t\u000f\u0005%\u0004\u00031\u0001\u0002l\u0005\u0011\"/Z4jgR,'\u000fR1uC\u000e,g\u000e^3s\u0003qiwN\\5u_J$\u0015\r^1dK:$XM\u001d+be\u001e,Go\u0015;bi\u0016\f\u0001cY1oG\u0016d7\u000b^1uK\u000eCWmY6\u0002%M\u001c\u0007.\u001a3vY\u0016\u001cF/\u0019;f\u0007\",7m\u001b\u000b\u0007\u0003\u001b\ti*a(\t\u000f\u0005%D\u00031\u0001\u0002l!9\u0011\u0011\u0015\u000bA\u0002\u0005=\u0012AD8mIR\u000b'oZ3u'R\fG/Z\u0001\u0012Q\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,G\u0003CA\u0018\u0003O\u000bI+!,\t\u000f\u0005%T\u00031\u0001\u0002l!9\u00111V\u000bA\u0002\u0005=\u0012\u0001\u00038foN#\u0018\r^3\t\u000f\u0005=V\u00031\u0001\u0002F\u0005\t\u0012m\u0019;jm\u0016$\u0015\r^1dK:$XM]:\u0002#\u001d,GoU3mM\u0012\u000bG/Y2f]R,'/\u0006\u0002\u0002l!\u001a\u0001!a.\u0011\t\u0005e\u0016qX\u0007\u0003\u0003wS1!!0D\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003\u0003\fYLA\u0004TKJ4\u0018nY3")
public class DatacenterService
implements Logging {
    private final DatacenterRepository datacenterRepository;
    private final XlrConfig xlrConfig;
    @Qualifier(value="taskScheduler")
    private final TaskScheduler taskScheduler;
    private final XlrServiceManager xlrServiceManager;
    private final XLReleaseEventBus eventBus;
    private ScheduledFuture<?> stateCheckFuture;
    private final AtomicReference<DatacenterTargetState> currentTargetState;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DatacenterService datacenterService = this;
        synchronized (datacenterService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private ScheduledFuture<?> stateCheckFuture() {
        return this.stateCheckFuture;
    }

    private void stateCheckFuture_$eq(ScheduledFuture<?> x$1) {
        this.stateCheckFuture = x$1;
    }

    private AtomicReference<DatacenterTargetState> currentTargetState() {
        return this.currentTargetState;
    }

    public void validateDatacenterStateChange() {
        XlrConfig$FeaturesSettings$datacenter$stateChangeCoolDown$ coolDown = this.xlrConfig.features().datacenter().stateChangeCoolDown();
        if (coolDown.enabled()) {
            Seq<Datacenter> allDatacenters = this.datacenterRepository.findAll();
            Seq nonSystemUpdatedDatacenters = (Seq)((SeqOps)((SeqOps)allDatacenters.filter((Function1 & Serializable)dc -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$validateDatacenterStateChange$1(dc)))).sortBy((Function1 & Serializable)x$2 -> x$2.getUpdatedDate(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).reverse();
            nonSystemUpdatedDatacenters.headOption().foreach((Function1 & Serializable)dc -> {
                DatacenterService.$anonfun$validateDatacenterStateChange$3(this, coolDown, dc);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.logger().trace((Function0 & Serializable)() -> "Datacenter state change cooldown is disabled");
    }

    public Seq<Datacenter> getDatacenters() {
        return this.datacenterRepository.findAll();
    }

    public void setDatacenterState(String datacenter, DatacenterTargetState state) {
        Predef$.MODULE$.require(StringUtils.hasText((String)datacenter), (Function0 & Serializable)() -> "Datacenter name cannot be empty");
        Seq<Datacenter> allDatacenters = this.datacenterRepository.findAll();
        Seq activeDatacenters = (Seq)allDatacenters.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$setDatacenterState$2(x$3)));
        Option existingDatacenter = allDatacenters.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$setDatacenterState$3(datacenter, x$4)));
        boolean bl = false;
        Some some = null;
        Option option = existingDatacenter;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Datacenter dc = (Datacenter)some.value();
            DatacenterTargetState datacenterTargetState = dc.getTargetState();
            DatacenterTargetState datacenterTargetState2 = state;
            if (!(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState2) : datacenterTargetState2 != null)) {
                this.logger().info((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' is already in the requested state '" + state + "'.");
                return;
            }
        }
        if (activeDatacenters.nonEmpty()) {
            DatacenterTargetState datacenterTargetState = state;
            DatacenterTargetState datacenterTargetState3 = DatacenterTargetState.ACTIVE;
            if (!(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState3) : datacenterTargetState3 != null)) {
                throw new IllegalStateException("An active datacenter already exists. Cannot set another to ACTIVE.");
            }
        }
        if (bl) {
            Datacenter dc = (Datacenter)some.value();
            this.datacenterRepository.update(datacenter, state, this.getCurrentUsername());
            this.eventBus.publish((XLReleaseEvent)new DatacenterUpdatedEvent(datacenter, dc.getTargetState(), state));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Datacenter '" + datacenter + "' does not exist");
        }
        throw new MatchError((Object)option);
    }

    private String getCurrentUsername() {
        return (String)Option$.MODULE$.apply((Object)User.AUTHENTICATED_USER.getName()).map((Function1 & Serializable)x$5 -> x$5.toLowerCase()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void deleteDatacenter(String datacenter) {
        Predef$.MODULE$.require(StringUtils.hasText((String)datacenter), (Function0 & Serializable)() -> "Datacenter name cannot be empty");
        this.datacenterRepository.delete(datacenter);
        this.eventBus.publish((XLReleaseEvent)new DatacenterDeletedEvent(datacenter));
    }

    public void registerDatacenter() {
        String datacenter = this.getSelfDatacenter();
        Option<Datacenter> option = this.datacenterRepository.find(datacenter);
        if (option instanceof Some) {
            this.logger().trace((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' already registered");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            this.logger().info((Function0 & Serializable)() -> "Registering datacenter '" + datacenter + "'");
            DatacenterTargetState state = this.datacenterRepository.count() > 0L ? DatacenterTargetState.WARM_STANDBY : DatacenterTargetState.ACTIVE;
            try {
                this.datacenterRepository.create(datacenter, state, User.SYSTEM.getName());
                this.eventBus.publish((XLReleaseEvent)new DatacenterCreatedEvent(datacenter, state));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> "Failed to register datacenter '" + datacenter + "'", (Function0 & Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void monitorDatacenterTargetState() {
        String datacenter = this.getSelfDatacenter();
        Seq<Datacenter> allDatacenters = this.datacenterRepository.findAll();
        Seq activeDatacenters = (Seq)allDatacenters.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$monitorDatacenterTargetState$1(x$6)));
        DatacenterTargetState requestedTargetState = (DatacenterTargetState)allDatacenters.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$monitorDatacenterTargetState$2(datacenter, x$7))).map((Function1 & Serializable)x$8 -> x$8.getTargetState()).getOrElse((Function0 & Serializable)() -> DatacenterTargetState.WARM_STANDBY);
        DatacenterTargetState actualTargetState = this.handleStateChange(datacenter, requestedTargetState, (Seq<Datacenter>)activeDatacenters);
        if (this.xlrConfig.features().datacenter().stateCheck().enabled()) {
            this.scheduleStateCheck(datacenter, actualTargetState);
            return;
        }
    }

    public void cancelStateCheck() {
        if (this.stateCheckFuture() != null && !this.stateCheckFuture().isCancelled()) {
            this.stateCheckFuture().cancel(true);
            this.logger().trace((Function0 & Serializable)() -> "Cancelled the scheduled datacenter target state check");
            return;
        }
    }

    private void scheduleStateCheck(String datacenter, DatacenterTargetState oldTargetState) {
        this.logger().info((Function0 & Serializable)() -> "Scheduling datacenter target state check for '" + datacenter + "'");
        long checkInterval = this.xlrConfig.features().datacenter().stateCheck().interval().toMillis();
        this.currentTargetState().set(oldTargetState);
        this.stateCheckFuture_$eq(this.taskScheduler.scheduleAtFixedRate(() -> {
            Seq<Datacenter> allDatacenters = $this.datacenterRepository.findAll();
            Seq activeDatacenters = (Seq)allDatacenters.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$scheduleStateCheck$3(x$9)));
            Option thisDatacenter = allDatacenters.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$scheduleStateCheck$4(datacenter, x$10)));
            Option option = thisDatacenter;
            if (None$.MODULE$.equals(option)) {
                this.logger().warn((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' is not registered. Registering now.");
                this.registerDatacenter();
                return;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Datacenter dc = (Datacenter)some.value();
                DatacenterTargetState datacenterTargetState = dc.getTargetState();
                DatacenterTargetState datacenterTargetState2 = this.currentTargetState().get();
                if (datacenterTargetState == null ? datacenterTargetState2 != null : !datacenterTargetState.equals(datacenterTargetState2)) {
                    this.currentTargetState().set(this.handleStateChange(datacenter, dc.getTargetState(), (Seq<Datacenter>)activeDatacenters));
                    return;
                }
                this.logger().trace((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' target state is still '" + this.currentTargetState() + "'");
                return;
            }
            throw new MatchError((Object)option);
        }, Duration.ofMillis(checkInterval)));
    }

    private DatacenterTargetState handleStateChange(String datacenter, DatacenterTargetState newState, Seq<Datacenter> activeDatacenters) {
        this.logger().info((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' target state changed to '" + newState + "'");
        boolean bl = false;
        DatacenterTargetState datacenterTargetState = null;
        DatacenterTargetState datacenterTargetState2 = newState;
        if (DatacenterTargetState.ACTIVE.equals(datacenterTargetState2)) {
            bl = true;
            datacenterTargetState = datacenterTargetState2;
            if (activeDatacenters.size() > 1) {
                this.logger().error((Function0 & Serializable)() -> "Multiple datacenters are in ACTIVE state. Services will not start.");
                return DatacenterTargetState.WARM_STANDBY;
            }
        }
        if (bl) {
            this.logger().info((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' is now ACTIVE. Starting services.");
            this.xlrServiceManager.startAsync();
            return DatacenterTargetState.ACTIVE;
        }
        if (DatacenterTargetState.WARM_STANDBY.equals(datacenterTargetState2)) {
            this.logger().warn((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' is no longer ACTIVE. Stopping services.");
            this.xlrServiceManager.stopAsync();
            return DatacenterTargetState.WARM_STANDBY;
        }
        throw new MatchError((Object)datacenterTargetState2);
    }

    private String getSelfDatacenter() {
        return (String)Option$.MODULE$.apply((Object)this.xlrConfig.clusterNode().datacenter()).filter((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$getSelfDatacenter$1(str))).map((Function1 & Serializable)x$11 -> x$11.toLowerCase().trim()).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Datacenter is not set in the configuration. Set value for 'xl.cluster.node.datacenter' configuration property.");
        });
    }

    public static final /* synthetic */ boolean $anonfun$validateDatacenterStateChange$1(Datacenter dc) {
        return StringUtils.hasText((String)dc.getUpdatedBy());
    }

    public static final /* synthetic */ void $anonfun$validateDatacenterStateChange$3(DatacenterService $this, XlrConfig$FeaturesSettings$datacenter$stateChangeCoolDown$ coolDown$1, Datacenter dc) {
        Duration coolDownPeriod;
        Duration elapsed;
        if (coolDown$1.onlyIfUserChanges()) {
            String string = dc.getUpdatedBy();
            String string2 = $this.getCurrentUsername();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                $this.logger().trace((Function0 & Serializable)() -> "Datacenter state change cooldown is skipped because the user is the same");
                return;
            }
        }
        if ((elapsed = Duration.between(dc.getUpdatedDate(), Instant.now())).compareTo(coolDownPeriod = Duration.ofSeconds(coolDown$1.interval().toSeconds())) < 0) {
            Duration remaining = coolDownPeriod.minus(elapsed);
            throw new RateLimitReachedException("Wait for " + remaining.toSeconds() + " seconds before attempting another state change");
        }
    }

    public static final /* synthetic */ boolean $anonfun$setDatacenterState$2(Datacenter x$3) {
        DatacenterTargetState datacenterTargetState = x$3.getTargetState();
        DatacenterTargetState datacenterTargetState2 = DatacenterTargetState.ACTIVE;
        return !(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState2) : datacenterTargetState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$setDatacenterState$3(String datacenter$1, Datacenter x$4) {
        String string = x$4.getTitle();
        String string2 = datacenter$1.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$monitorDatacenterTargetState$1(Datacenter x$6) {
        DatacenterTargetState datacenterTargetState = x$6.getTargetState();
        DatacenterTargetState datacenterTargetState2 = DatacenterTargetState.ACTIVE;
        return !(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState2) : datacenterTargetState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$monitorDatacenterTargetState$2(String datacenter$3, Datacenter x$7) {
        String string = x$7.getTitle();
        String string2 = datacenter$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$scheduleStateCheck$3(Datacenter x$9) {
        DatacenterTargetState datacenterTargetState = x$9.getTargetState();
        DatacenterTargetState datacenterTargetState2 = DatacenterTargetState.ACTIVE;
        return !(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState2) : datacenterTargetState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$scheduleStateCheck$4(String datacenter$4, Datacenter x$10) {
        String string = x$10.getTitle();
        String string2 = datacenter$4;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSelfDatacenter$1(String str) {
        return StringUtils.hasText((String)str);
    }

    public DatacenterService(DatacenterRepository datacenterRepository, XlrConfig xlrConfig, @Qualifier(value="taskScheduler") TaskScheduler taskScheduler, XlrServiceManager xlrServiceManager, XLReleaseEventBus eventBus) {
        this.datacenterRepository = datacenterRepository;
        this.xlrConfig = xlrConfig;
        this.taskScheduler = taskScheduler;
        this.xlrServiceManager = xlrServiceManager;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        this.currentTargetState = new AtomicReference();
    }
}

