/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.tasks.gate.TargetIdResolutionFailedException;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolverRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xltype.serialization.CiReference;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001\u0002\u0005\n\u0001IA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tM\u0001\u0011\t\u0011)A\u0005O!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u0003M\u0001\u0011\u0005Q\nC\u0003f\u0001\u0011\u0005a\rC\u0003j\u0001\u0011%!N\u0001\rEKB,g\u000eZ3oGf$\u0016M]4fiJ+7o\u001c7wKJT!AC\u0006\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\r\u001b\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u001d=\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003A\t1aY8n\u0007\u0001\u00192\u0001A\n\u001a!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fMB\u0011!dH\u0007\u00027)\u0011A$H\u0001\u0006g24GG\u001b\u0006\u0002=\u0005AqM]5{u2,G-\u0003\u0002!7\t9Aj\\4hS:<\u0017A\u00059mC:LE/Z7SKB|7/\u001b;pef\u0004\"a\t\u0013\u000e\u0003%I!!J\u0005\u0003%Ac\u0017M\\%uK6\u0014V\r]8tSR|'/_\u0001\u0013e\u0016\u001cx\u000e\u001c<feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002)]5\t\u0011F\u0003\u0002\u000bU)\u00111\u0006L\u0001\u0005UN|gN\u0003\u0002.\u0017\u0005i1/\u001a:jC2L'0\u0019;j_:L!aL\u0015\u0003%I+7o\u001c7wKJ\u0014V\r]8tSR|'/_\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u0004\"AM\u001b\u000e\u0003MR!\u0001N\u0006\u0002\u000fM,'O^5dK&\u0011ag\r\u0002\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtD\u0003B\u001d;wq\u0002\"a\t\u0001\t\u000b\u0005\"\u0001\u0019\u0001\u0012\t\u000b\u0019\"\u0001\u0019A\u0014\t\u000bA\"\u0001\u0019A\u0019)\u0005\u0011q\u0004CA K\u001b\u0005\u0001%BA!C\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0007\u0012\u000bqAZ1di>\u0014\u0018P\u0003\u0002F\r\u0006)!-Z1og*\u0011q\tS\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0011*A\u0002pe\u001eL!a\u0013!\u0003\u0013\u0005+Ho\\<je\u0016$\u0017!\u0004:fg>dg/\u001a+be\u001e,G\u000f\u0006\u0002O#B\u0011AcT\u0005\u0003!V\u0011A!\u00168ji\")!+\u0002a\u0001'\u0006QA-\u001a9f]\u0012,gnY=\u0011\u0005Q;V\"A+\u000b\u0005Y[\u0011A\u00023p[\u0006Lg.\u0003\u0002Y+\nQA)\u001a9f]\u0012,gnY=)\u0005\u0015Q\u0006CA.d\u001b\u0005a&BA!^\u0015\tqv,\u0001\u0003d_J,'B\u00011b\u0003)i\u0017n\u0019:p[\u0016$XM\u001d\u0006\u0002E\u0006\u0011\u0011n\\\u0005\u0003Ir\u0013Q\u0001V5nK\u0012\f\u0001\u0004]8qk2\fG/Z!sG\"Lg/\u001a3UCJ<W\r^%e)\tqu\rC\u0003S\r\u0001\u00071\u000b\u000b\u0002\u00075\u0006)\"/Z:pYZ,\u0017I]2iSZ,G\rV1sO\u0016$HcA6owB\u0011A\u000b\\\u0005\u0003[V\u0013\u0001\u0002\u00157b]&#X-\u001c\u0005\u0006_\u001e\u0001\r\u0001]\u0001\ti\u0006\u0014x-\u001a;JIB\u0011\u0011\u000f\u001f\b\u0003eZ\u0004\"a]\u000b\u000e\u0003QT!!^\t\u0002\rq\u0012xn\u001c;?\u0013\t9X#\u0001\u0004Qe\u0016$WMZ\u0005\u0003sj\u0014aa\u0015;sS:<'BA<\u0016\u0011\u0015ax\u00011\u0001q\u00031!W\r]3oI\u0016t7-_%eQ\t\u0001a\u0010E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\ra)\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a\u0002\u0002\u0002\tI1i\\7q_:,g\u000e\u001e")
public class DependencyTargetResolver
implements Logging {
    private final PlanItemRepository planItemRepository;
    private final ResolverRepository resolverRepository;
    private final ArchivingService archivingService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyTargetResolver dependencyTargetResolver = this;
        synchronized (dependencyTargetResolver) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void resolveTarget(Dependency dependency) {
        String targetId = dependency.getTargetId();
        if (Strings.isNotEmpty((String)targetId) && !VariableHelper$.MODULE$.containsVariables(targetId) && !dependency.isArchived()) {
            boolean dependencyTargetResolved = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                PropertyDescriptor targetProperty = dependency.getType().getDescriptor().getPropertyDescriptor("target");
                CiReference ciRef = new CiReference((ConfigurationItem)dependency, targetProperty, targetId);
                PlanItem planItem = (PlanItem)$this.resolverRepository.resolve(targetId, ciRef);
                if ($this.planItemRepository.exists(targetId)) {
                    dependency.setTarget(planItem);
                    return true;
                }
                return false;
            }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
            if (!dependencyTargetResolved) {
                Try$.MODULE$.apply((Function0 & Serializable)() -> this.resolveArchivedTarget(targetId, dependency.getId())).map((Function1 & Serializable)target -> {
                    DependencyTargetResolver.$anonfun$resolveTarget$4(dependency, target);
                    return BoxedUnit.UNIT;
                }).recoverWith((PartialFunction)new Serializable(null, dependency, targetId){
                    private static final long serialVersionUID = 0L;
                    private final Dependency dependency$1;
                    private final String targetId$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof NotFoundException) {
                            return (B1)new Failure((Throwable)new TargetIdResolutionFailedException("Could not find target on dependency " + this.dependency$1.getId() + " by ID " + this.targetId$1));
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        return throwable instanceof NotFoundException;
                    }
                    {
                        this.dependency$1 = dependency$1;
                        this.targetId$1 = targetId$1;
                    }
                }).get();
                return;
            }
            return;
        }
    }

    @Timed
    public void populateArchivedTargetId(Dependency dependency) {
        String targetId = dependency.getTargetId();
        boolean targetExists = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.planItemRepository.exists(targetId)).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        if (Strings.isNotEmpty((String)targetId) && !VariableHelper$.MODULE$.containsVariables(targetId) && !dependency.isArchived() && !targetExists) {
            Try$.MODULE$.apply((Function0 & Serializable)() -> this.resolveArchivedTarget(targetId, dependency.getId())).map((Function1 & Serializable)target -> {
                DependencyTargetResolver.$anonfun$populateArchivedTargetId$4(dependency, target);
                return BoxedUnit.UNIT;
            }).recover((PartialFunction)new Serializable(this, dependency, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyTargetResolver $outer;
                private final Dependency dependency$2;
                private final String targetId$2;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        A1 A12 = A1;
                        this.$outer.logger().error((Function0 & Serializable)() -> "Unable to populate target on dependency " + $this.dependency$2.getId() + " by ID " + $this.targetId$2, (Function0 & Serializable)() -> A12);
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return throwable != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dependency$2 = dependency$2;
                    this.targetId$2 = targetId$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.repository.DependencyTargetResolver$$anonfun$populateArchivedTargetId$5 ), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
                }
            });
            return;
        }
    }

    private PlanItem resolveArchivedTarget(String targetId, String dependencyId) {
        Option option;
        Option option2;
        Option option3;
        String string = targetId;
        if (string != null && !(option3 = IdMatchers.ReleaseId$.MODULE$.unapply(string)).isEmpty()) {
            return this.archivingService.getRelease(targetId);
        }
        if (string != null && !(option2 = IdMatchers.PhaseId$.MODULE$.unapply(string)).isEmpty()) {
            return this.archivingService.getPhase(targetId);
        }
        if (string != null && !(option = IdMatchers.TaskId$.MODULE$.unapply(string)).isEmpty()) {
            return this.archivingService.getTask(targetId);
        }
        throw new TargetIdResolutionFailedException("Invalid archived target on dependency " + dependencyId + ", it is not a plan item: " + targetId);
    }

    public static final /* synthetic */ void $anonfun$resolveTarget$4(Dependency dependency$1, PlanItem target) {
        dependency$1.setTarget(target);
        dependency$1.archive();
    }

    public static final /* synthetic */ void $anonfun$populateArchivedTargetId$4(Dependency dependency$2, PlanItem target) {
        dependency$2.setTarget(target);
        dependency$2.archive();
    }

    @Autowired
    public DependencyTargetResolver(PlanItemRepository planItemRepository, ResolverRepository resolverRepository, ArchivingService archivingService) {
        this.planItemRepository = planItemRepository;
        this.resolverRepository = resolverRepository;
        this.archivingService = archivingService;
        Logging.$init$((Logging)this);
    }
}

