/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.service.XlrServiceManager;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.springframework.boot.actuate.health.Status;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;

public class XlrAccessControlFilter
implements Filter {
    private final PermissionEnforcer permissionEnforcer;
    private final XlrServiceManager serviceManager;
    private final boolean isMaintenanceMode;

    public XlrAccessControlFilter(PermissionEnforcer permissionEnforcer, XlrServiceManager serviceManager, boolean isMaintenanceMode) {
        this.permissionEnforcer = permissionEnforcer;
        this.serviceManager = serviceManager;
        this.isMaintenanceMode = isMaintenanceMode;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean isServicesDown;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String requestPath = httpServletRequest.getRequestURI();
        String requestMethod = httpServletRequest.getMethod();
        if ("/".equals(requestPath) && "GET".equals(requestMethod)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        boolean bl = isServicesDown = this.isMaintenanceMode || this.serviceManager.getHealthStatus() != Status.UP;
        if (isServicesDown) {
            this.doFilterInternal(servletRequest, servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void doFilterInternal(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean isSessionlessAuthenticatedUser;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpSession session = httpServletRequest.getSession(false);
        Authentication currentUserAuthentication = Permissions.getAuthentication();
        boolean sessionExists = session != null;
        boolean isAnonymousUser = currentUserAuthentication instanceof AnonymousAuthenticationToken;
        boolean bl = isSessionlessAuthenticatedUser = currentUserAuthentication != null && !isAnonymousUser && !sessionExists;
        if (sessionExists) {
            boolean isUnsecuredResourceRequest;
            boolean isStaticResourceRequest = currentUserAuthentication == null;
            boolean bl2 = isUnsecuredResourceRequest = session.getAttribute("SPRING_SECURITY_CONTEXT") == null;
            if (isUnsecuredResourceRequest || isStaticResourceRequest) {
                chain.doFilter(request, response);
                return;
            }
            this.isAllowedAccessInMaintenanceMode(request, response, chain, currentUserAuthentication);
            return;
        }
        if (isSessionlessAuthenticatedUser) {
            this.isAllowedAccessInMaintenanceMode(request, response, chain, currentUserAuthentication);
            return;
        }
        chain.doFilter(request, response);
    }

    private void isAllowedAccessInMaintenanceMode(ServletRequest request, ServletResponse response, FilterChain chain, Authentication currentUserAuthentication) throws IOException, ServletException {
        if (this.permissionEnforcer.isAdmin(currentUserAuthentication)) {
            chain.doFilter(request, response);
        } else {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setStatus(HttpStatus.SERVICE_UNAVAILABLE.value());
        }
    }
}

