/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.Exceptions;
import com.xebialabs.deployit.Sanitizer;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import com.xebialabs.xlrelease.actors.RemoteException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Provider
@Component
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001\u0002\b\u0010\u0001aA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\n\u007f\u0001\u0001\r\u00111A\u0005\n\u0001C\u0011\"\u0013\u0001A\u0002\u0003\u0007I\u0011\u0002&\t\u0013M\u0003\u0001\u0019!A!B\u0013\t\u0005bB.\u0001\u0005\u0004%I\u0001\u0018\u0005\u0007K\u0002\u0001\u000b\u0011B/\t\u000f\u0019\u0004!\u0019!C\u0005O\"11\u000e\u0001Q\u0001\n!DQ\u0001\u001c\u0001\u0005\u00025DQ\u0001\u001f\u0001\u0005BeDQA \u0001\u0005\n}Dq!a\u0001\u0001\t\u0013\t)AA\u000bSK6|G/Z#yG\u0016\u0004H/[8o\u001b\u0006\u0004\b/\u001a:\u000b\u0005A\t\u0012\u0001\u00039mk6\u0014\u0017N\\4\u000b\u0005I\u0019\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005Q)\u0012!\u0003=fE&\fG.\u00192t\u0015\u00051\u0012aA2p[\u000e\u00011c\u0001\u0001\u001aCA\u0011!dH\u0007\u00027)\u0011A$H\u0001\u0005Y\u0006twMC\u0001\u001f\u0003\u0011Q\u0017M^1\n\u0005\u0001Z\"AB(cU\u0016\u001cG\u000fE\u0002#W5j\u0011a\t\u0006\u0003I\u0015\n1!\u001a=u\u0015\t1s%\u0001\u0002sg*\u0011\u0001&K\u0001\u0003oNT\u0011AK\u0001\bU\u0006\\\u0017M\u001d;b\u0013\ta3EA\bFq\u000e,\u0007\u000f^5p]6\u000b\u0007\u000f]3s!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0004bGR|'o\u001d\u0006\u0003eM\t\u0011\u0002\u001f7sK2,\u0017m]3\n\u0005Qz#a\u0004*f[>$X-\u0012=dKB$\u0018n\u001c8\u0002'M,'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005]BT\"A\t\n\u0005e\n\"aE*feZ,'oQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002=}A\u0011Q\bA\u0007\u0002\u001f!)QG\u0001a\u0001m\u00059!/Z9vKN$X#A!\u0011\u0005\t;U\"A\"\u000b\u0005\u0011+\u0015\u0001\u00025uiBT!AR\u0015\u0002\u000fM,'O\u001e7fi&\u0011\u0001j\u0011\u0002\u0013\u0011R$\boU3sm2,GOU3rk\u0016\u001cH/A\u0006sKF,Xm\u001d;`I\u0015\fHCA&R!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0005\u0011)f.\u001b;\t\u000fI#\u0011\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\u0002\u0011I,\u0017/^3ti\u0002B#!B+\u0011\u0005YKV\"A,\u000b\u0005a+\u0013\u0001B2pe\u0016L!AW,\u0003\u000f\r{g\u000e^3yi\u00061An\\4hKJ,\u0012!\u0018\t\u0003=\u000el\u0011a\u0018\u0006\u0003A\u0006\fQa\u001d7gi)T\u0011AY\u0001\u0004_J<\u0017B\u00013`\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013!\u00045jI\u0016Le\u000e^3s]\u0006d7/F\u0001i!\ta\u0015.\u0003\u0002k\u001b\n9!i\\8mK\u0006t\u0017A\u00045jI\u0016Le\u000e^3s]\u0006d7\u000fI\u0001\u000bO\u0016$8i\u001c8uK:$Hc\u00018rmB\u0011!d\\\u0005\u0003an\u0011aa\u0015;sS:<\u0007\"\u0002:\u000b\u0001\u0004\u0019\u0018!C7fI&\fG+\u001f9f!\t1F/\u0003\u0002v/\nIQ*\u001a3jCRK\b/\u001a\u0005\u0006o*\u0001\r!L\u0001\nKb\u001cW\r\u001d;j_:\f!\u0002^8SKN\u0004xN\\:f)\tQX\u0010\u0005\u0002Ww&\u0011Ap\u0016\u0002\t%\u0016\u001c\bo\u001c8tK\")qo\u0003a\u0001[\u0005i\u0001.\u00198eY\u0016dunZ4j]\u001e$2aSA\u0001\u0011\u00159H\u00021\u0001.\u0003q!W\r^3s[&tW-Q2dKB$\u0018M\u00197f\u001b\u0016$\u0017.\u0019+za\u0016$\u0012a\u001d\u0015\u0004\u0001\u0005%\u0001c\u0001\u0012\u0002\f%\u0019\u0011QB\u0012\u0003\u0011A\u0013xN^5eKJD3\u0001AA\t!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\t!b\u001d;fe\u0016|G/\u001f9f\u0015\r\tY\"Y\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&!\u0011qDA\u000b\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class RemoteExceptionMapper
implements ExceptionMapper<RemoteException> {
    @Context
    private HttpServletRequest request;
    private final Logger logger = LoggerFactory.getLogger(RemoteExceptionMapper.class);
    private final boolean hideInternals;

    private HttpServletRequest request() {
        return this.request;
    }

    private void request_$eq(HttpServletRequest x$1) {
        this.request = x$1;
    }

    private Logger logger() {
        return this.logger;
    }

    private boolean hideInternals() {
        return this.hideInternals;
    }

    public String getContent(MediaType mediaType, RemoteException exception) {
        String rawContent = Exceptions.getAllMessages((Exception)exception);
        MediaType mediaType2 = mediaType;
        if (mediaType2.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return "{ \"content\": \"" + rawContent.replace("\"", "'") + "\" }";
        }
        if (mediaType2.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            return "<![CDATA[" + rawContent.replace("]]>", "___") + "]]>";
        }
        return rawContent;
    }

    public Response toResponse(RemoteException exception) {
        this.handleLogging(exception);
        int responseStatusCode = exception.getResponseStatusCode();
        MediaType mediaType = this.determineAcceptableMediaType();
        String content = this.getContent(mediaType, exception);
        if (this.hideInternals()) {
            UUID uuid = UUID.randomUUID();
            this.logger().error("[UUID={}] Exception: {}", (Object)uuid, (Object)exception.getClass().getName());
            this.logger().error("[UUID={}] Error messages: {}", (Object)uuid, (Object)content);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)("An internal error has occurred, please notify your system administrator with the following code: " + uuid)).build();
        }
        Response.ResponseBuilder builder = Response.status((int)responseStatusCode).type(mediaType);
        builder.header("X-Exception-Type", (Object)exception.getClass().getName());
        builder.header("X-Remote-Exception", (Object)"true");
        builder.header("X-Path", PathInterceptor.PATH.get());
        builder.header("Date", (Object)new Date());
        builder.entity((Object)Sanitizer.sanitize((String)content));
        return builder.build();
    }

    private void handleLogging(RemoteException exception) {
        this.logger().info(exception.getMsg());
        String logMsg = "Intercepting RemoteException";
        if (exception.getSuppressStackTrace()) {
            this.logger().trace(logMsg, (Throwable)exception);
            return;
        }
        this.logger().info(logMsg, (Throwable)exception);
    }

    private MediaType determineAcceptableMediaType() {
        Enumeration accepted;
        Object object = this.request().getHeader("Accept-Type") != null ? new .colon.colon((Object)MediaType.valueOf((String)this.request().getHeader("Accept-Type")), (List)Nil$.MODULE$) : (this.request().getHeaders("Accept") != null ? ((accepted = this.request().getHeaders("Accept")) != null ? CollectionConverters$.MODULE$.EnumerationHasAsScala(accepted).asScala().flatMap((Function1 & Serializable)h -> Predef$.MODULE$.wrapRefArray((Object[])h.split(","))).map((Function1 & Serializable)e -> MediaType.valueOf((String)e.trim())).toList() : Nil$.MODULE$) : new .colon.colon((Object)MediaType.APPLICATION_XML_TYPE, (List)Nil$.MODULE$));
        .colon.colon mediaTypes = object;
        return (MediaType)mediaTypes.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MediaType.APPLICATION_JSON_TYPE.isCompatible(x$1))).getOrElse(() -> RemoteExceptionMapper.$anonfun$determineAcceptableMediaType$4((List)mediaTypes));
    }

    public static final /* synthetic */ MediaType $anonfun$determineAcceptableMediaType$4(List mediaTypes$1) {
        return (MediaType)mediaTypes$1.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MediaType.APPLICATION_XML_TYPE.isCompatible(x$1))).getOrElse((Function0 & Serializable)() -> MediaType.TEXT_PLAIN_TYPE);
    }

    public RemoteExceptionMapper(ServerConfiguration serverConfiguration) {
        this.hideInternals = serverConfiguration.isHideInternals();
    }
}

