/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.configuration.TenantLimit;
import com.xebialabs.xlrelease.domain.Tenant;
import com.xebialabs.xlrelease.domain.events.TenantLimitCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TenantLimitDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TenantLimitUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.TenantLimitRepository;
import com.xebialabs.xlrelease.service.TenantService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005Y4AAC\u0006\u0001)!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011!y\u0003A!A!\u0002\u0013\u0001\u0004\"\u0002\u001c\u0001\t\u00039\u0004\"\u0002\u001f\u0001\t\u0003i\u0004\"\u0002)\u0001\t\u0003\t\u0006\"\u0002/\u0001\t\u0003i\u0006\"B1\u0001\t\u0003\u0011\u0007\"\u00025\u0001\t\u0003I'A\u0005+f]\u0006tG\u000fT5nSR\u001cVM\u001d<jG\u0016T!\u0001D\u0007\u0002\u000fM,'O^5dK*\u0011abD\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001E\t\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\n\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039\u0005j\u0011!\b\u0006\u0003=}\tQa\u001d7gi)T\u0011\u0001I\u0001\tOJL'P\u001f7fI&\u0011!%\b\u0002\b\u0019><w-\u001b8h\u00035!XM\\1oiN+'O^5dKB\u0011QEJ\u0007\u0002\u0017%\u0011qe\u0003\u0002\u000e)\u0016t\u0017M\u001c;TKJ4\u0018nY3\u0002+Q,g.\u00198u\u0019&l\u0017\u000e\u001e*fa>\u001c\u0018\u000e^8ssB\u0011!&L\u0007\u0002W)\u0011A&D\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u0018,\u0005U!VM\\1oi2KW.\u001b;SKB|7/\u001b;pef\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003cQj\u0011A\r\u0006\u0003g5\ta!\u001a<f]R\u001c\u0018BA\u001b3\u0005!)e/\u001a8u\u0005V\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u00039siZ\u0004CA\u0013\u0001\u0011\u0015\u0019C\u00011\u0001%\u0011\u0015AC\u00011\u0001*\u0011\u0015yC\u00011\u00011\u000319W\r^!mY2KW.\u001b;t)\u0005q\u0004cA H\u0015:\u0011\u0001)\u0012\b\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007N\ta\u0001\u0010:p_Rt\u0014\"\u0001\r\n\u0005\u0019;\u0012a\u00029bG.\fw-Z\u0005\u0003\u0011&\u0013A\u0001T5ti*\u0011ai\u0006\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b6\tQbY8oM&<WO]1uS>t\u0017BA(M\u0005-!VM\\1oi2KW.\u001b;\u0002'\u0019Lg\u000e\u001a'j[&$()\u001f+f]\u0006tG/\u00133\u0015\u0005)\u0013\u0006\"B*\u0007\u0001\u0004!\u0016\u0001\u0003;f]\u0006tG/\u00133\u0011\u0005UKfB\u0001,X!\t\tu#\u0003\u0002Y/\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAv#A\u0006de\u0016\fG/\u001a'j[&$Hc\u0001&_?\")1k\u0002a\u0001)\")\u0001m\u0002a\u0001\u0015\u0006)A.[7ji\u0006YQ\u000f\u001d3bi\u0016d\u0015.\\5u)\r\u0019gm\u001a\t\u0003-\u0011L!!Z\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006'\"\u0001\r\u0001\u0016\u0005\u0006A\"\u0001\rAS\u0001\fI\u0016dW\r^3MS6LG\u000f\u0006\u0002dU\")1+\u0003a\u0001)\"\u0012\u0001\u0001\u001c\t\u0003[Rl\u0011A\u001c\u0006\u0003_B\f!b\u001d;fe\u0016|G/\u001f9f\u0015\t\t(/A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0019\u0018aA8sO&\u0011QO\u001c\u0002\b'\u0016\u0014h/[2f\u0001")
public class TenantLimitService
implements Logging {
    private final TenantService tenantService;
    private final TenantLimitRepository tenantLimitRepository;
    private final EventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TenantLimitService tenantLimitService = this;
        synchronized (tenantLimitService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public List<TenantLimit> getAllLimits() {
        return this.tenantLimitRepository.findAll().toList();
    }

    public TenantLimit findLimitByTenantId(String tenantId) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenantId), (String)"Tenant ID cannot be empty", (Object[])new Object[0]);
        return (TenantLimit)this.tenantLimitRepository.findByTenantId(tenantId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("No tenant limit found for tenant ID: " + tenantId, new Object[0]);
        });
    }

    public TenantLimit createLimit(String tenantId, TenantLimit limit) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenantId), (String)"Tenant ID cannot be empty", (Object[])new Object[0]);
        Checks.checkArgument((limit != null ? 1 : 0) != 0, (String)"Tenant limit cannot be null", (Object[])new Object[0]);
        Tenant tenant = this.tenantService.findTenantById(tenantId);
        limit.setTenantId(tenant.tenantId());
        TenantLimit createdTenantLimit = this.tenantLimitRepository.create(limit);
        this.eventBus.publish((XLReleaseEvent)new TenantLimitCreatedEvent(createdTenantLimit));
        return createdTenantLimit;
    }

    public void updateLimit(String tenantId, TenantLimit limit) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenantId), (String)"Tenant ID cannot be empty", (Object[])new Object[0]);
        Checks.checkArgument((limit != null ? 1 : 0) != 0, (String)"Tenant limit cannot be null", (Object[])new Object[0]);
        limit.setTenantId(tenantId);
        TenantLimit originalTenantLimit = this.findLimitByTenantId(tenantId);
        this.tenantLimitRepository.update(limit);
        this.eventBus.publish((XLReleaseEvent)new TenantLimitUpdatedEvent(originalTenantLimit, limit));
    }

    public void deleteLimit(String tenantId) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenantId), (String)"Tenant ID cannot be empty", (Object[])new Object[0]);
        TenantLimit tenantLimit = this.findLimitByTenantId(tenantId);
        this.tenantLimitRepository.delete(tenantId);
        this.eventBus.publish((XLReleaseEvent)new TenantLimitDeletedEvent(tenantLimit));
    }

    public TenantLimitService(TenantService tenantService, TenantLimitRepository tenantLimitRepository, EventBus eventBus) {
        this.tenantService = tenantService;
        this.tenantLimitRepository = tenantLimitRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

