package com.xebialabs.xlrelease.validation

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.plugin.api.validation.{ExtendedValidationContext, ValidationMessage}

import java.util
import java.util.{List => JList}

class ExtendedValidationContextImpl(var ci: ConfigurationItem) extends ExtendedValidationContext {
  private val messages: JList[ValidationMessage] = new util.ArrayList[ValidationMessage]
  private var propertyName: String = _

  override def focus(ci: ConfigurationItem): ExtendedValidationContext = {
    this.ci = ci
    this.propertyName = null
    this
  }

  override def focus(ci: ConfigurationItem, propertyName: String): ExtendedValidationContext = {
    this.ci = ci
    this.propertyName = propertyName
    this
  }

  override def getMessages: JList[ValidationMessage] = this.messages

  override def error(ci: ConfigurationItem, propertyName: String, message: String, params: AnyRef*): Unit = {
    messages.add(new ValidationMessage(ci.getId, propertyName, String.format(message, params: _*)))
  }

  override def error(message: String, params: AnyRef*): Unit = error(ci, propertyName, message, params: _*)
}
