/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskDefinition;
import com.xebialabs.xlrelease.domain.tasks.TaskViewConverter;
import com.xebialabs.xlrelease.views.AttachmentView;
import com.xebialabs.xlrelease.views.Flag;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.converters.DurationViewConverter;
import com.xebialabs.xlrelease.views.converters.PlanItemConverter;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseTaskViewConverter<T extends Task>
implements TaskViewConverter<T>,
PlanItemConverter {
    private UserViewConverter userViewConverter;

    @Autowired
    public void setUserViewConverter(UserViewConverter userViewConverter) {
        this.userViewConverter = userViewConverter;
    }

    @Override
    public TaskFullView toFullView(T task, List<Type> allowedTaskTypesForAuthenticatedUser) {
        Release release;
        TaskFullView view = new TaskFullView();
        this.populatePlanItemView(view, (PlanItem)task);
        view.setStatus(task.getStatus());
        if (task.getLastStatusChangeBy() != null) {
            view.setLastStatusChangeBy(this.userViewConverter.toUserView(task.getLastStatusChangeBy()));
        }
        view.setPrecondition(task.getPrecondition());
        view.setPreconditionEnabled(task.isPreconditionEnabled());
        view.setFailureHandler(task.getFailureHandler());
        view.setFailureHandlerEnabled(task.isFailureHandlerEnabled());
        view.setTaskFailureHandlerEnabled(task.isTaskFailureHandlerEnabled());
        view.setCheckAttributes(task.isCheckAttributes());
        view.setTaskRecoverOp(task.getTaskRecoverOp());
        view.setEditable(task.isUpdatable() && allowedTaskTypesForAuthenticatedUser.contains(task.getTaskType()));
        view.setFlag(Flag.toItemFlag(task));
        view.setStatusLine(task.getStatusLine());
        if (task.hasOwner()) {
            view.setOwner(this.userViewConverter.toUserView(task.getOwner()));
        }
        if (task.getPhase() != null) {
            view.setPhaseTitle(task.getPhase().getTitle());
        }
        if ((release = task.getRelease()) != null) {
            view.setReleaseId(release.getId());
            view.setReleaseTitle(release.getTitle());
            String releaseOwner = release.getOwner();
            view.setReleaseOwner(this.userViewConverter.toUserView(releaseOwner));
        }
        view.setTeam(task.getTeam());
        view.setNumberOfComments(task.getComments().size());
        view.setAutomated((Boolean)task.getProperty("automated"));
        view.setWaitForScheduledStartDate(task.isWaitForScheduledStartDate());
        view.setDelayDuringBlackout(task.isDelayDuringBlackout());
        if (task.getAttachments() != null) {
            view.setAttachments(task.getAttachments().stream().map(AttachmentView::new).collect(Collectors.toList()));
        }
        view.setFlagsCount(task.getFlaggedCount());
        view.setDelaysCount(task.getDelayedCount());
        view.setFailuresCount(task.getFailuresCount());
        view.setTypeDisplayGroup(TaskDefinition.getDisplayGroup((Type)task.getType()));
        view.setTypeDisplayName(TaskDefinition.getDisplayName((Type)task.getType()));
        view.setVariableMapping(task.getVariableMapping());
        view.setTags(task.getTags());
        view.setPostponedDueToBlackout(task.isPostponedDueToBlackout());
        view.setPostponedUntilEnvironmentsAreReserved(task.isPostponedUntilEnvironmentsAreReserved());
        view.setOriginalScheduledStartDate(task.getOriginalScheduledStartDate());
        view.setLocked(task.isLocked());
        view.setFacets(task.getFacets());
        view.setWatchers(task.getWatchers().stream().map(username -> this.userViewConverter.toUserView((String)username)).collect(Collectors.toSet()));
        if (task.get$ciAttributes().getLastModifiedAt() != null) {
            view.setLastModifiedAt(task.get$ciAttributes().getLastModifiedAt().toDate());
        }
        view.setLastModifiedBy(task.get$ciAttributes().getLastModifiedBy());
        return view;
    }

    protected abstract Class<T> getTaskClass();

    protected abstract T fromView(TaskFullView var1);

    @Override
    public T toTask(TaskFullView view) {
        T task = this.fromView(view);
        return this.fillCommonFields(view, task);
    }

    private T fillCommonFields(TaskFullView view, T task) {
        task.setId(view.getId());
        task.setTitle(view.getTitle());
        task.setDescription(view.getDescription());
        task.setScheduledStartDate(view.getScheduledStartDate());
        task.setDueDate(view.getDueDate());
        task.setStartDate(view.getStartDate());
        task.setEndDate(view.getEndDate());
        task.setPlannedDuration(DurationViewConverter.fromDurationView(view.getPlannedDuration()));
        task.setStatus(view.getStatus());
        task.setPrecondition(view.getPrecondition());
        task.setFailureHandler(view.getFailureHandler());
        task.setTaskFailureHandlerEnabled(view.isTaskFailureHandlerEnabled());
        task.setTaskRecoverOp(view.getTaskRecoverOp());
        task.setFlagStatus(view.getFlag().getStatus());
        task.setFlagComment(view.getFlag().getComment());
        if (view.hasOwner()) {
            task.setOwner(view.getOwner().getUsername());
        }
        task.setTeam(view.getTeam());
        task.setWaitForScheduledStartDate(view.isWaitForScheduledStartDate());
        task.setDelayDuringBlackout(view.isDelayDuringBlackout());
        this.fillVariableMappings(view, task);
        task.setTags(view.getTags());
        task.setOriginalScheduledStartDate(view.getOriginalScheduledStartDate());
        task.setPostponedDueToBlackout(view.isPostponedDueToBlackout());
        task.setPostponedUntilEnvironmentsAreReserved(view.isPostponedUntilEnvironmentsAreReserved());
        task.setLocked(view.isLocked());
        task.setCheckAttributes(view.isCheckAttributes());
        task.setWatchers(view.getWatchers().stream().map(UserView::getUsername).collect(Collectors.toSet()));
        task.set$ciAttributes(new CiAttributes(null, null, view.getLastModifiedBy(), view.getLastModifiedAt() != null ? new DateTime((Object)view.getLastModifiedAt()) : null, Long.valueOf(0L)));
        return task;
    }

    protected void fillVariableMappings(TaskFullView view, T task) {
        if (!task.hasVariableMapping()) {
            task.setVariableMapping(view.getVariableMapping());
        }
    }

    @Override
    public Type getTaskType() {
        return Type.valueOf(this.getTaskClass());
    }
}

