/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.StreamWrappingOverthereFile;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.configuration.CustomLogoContentType;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TemplateLogo;
import com.xebialabs.xlrelease.domain.events.TemplateLogoUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.utils.IdUtils;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.AttachmentSizeLimiter;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TemplateMetadataRepository;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.service.FileContentValidator;
import io.micrometer.core.annotation.Timed;
import jakarta.activation.FileTypeMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.jdk.javaapi.OptionConverters;
import scala.util.Try;

@Service
public class UploadService {
    private static final Logger logger = LoggerFactory.getLogger(UploadService.class);
    public static final String NEWLINES = "[\n\r]";
    private final AttachmentService attachmentService;
    private final ReleaseRepository releaseRepository;
    private final AttachmentRepository attachmentRepository;
    private final ReleaseActorService releaseActorService;
    private final TemplateMetadataRepository templateMetadataRepository;
    private final EventBus eventBus;
    private final FileContentValidator fileContentValidator;

    @Autowired
    public UploadService(AttachmentService attachmentService, ReleaseRepository releaseRepository, AttachmentRepository attachmentRepository, ReleaseActorService releaseActorService, TemplateMetadataRepository templateMetadataRepository, EventBus eventBus, FileContentValidator fileContentValidator) {
        this.attachmentService = attachmentService;
        this.releaseRepository = releaseRepository;
        this.attachmentRepository = attachmentRepository;
        this.releaseActorService = releaseActorService;
        this.templateMetadataRepository = templateMetadataRepository;
        this.eventBus = eventBus;
        this.fileContentValidator = fileContentValidator;
    }

    @Timed
    public Attachment addAttachment(String ciId, String fileName, byte[] fileByteArray) {
        return this.addAttachment(ciId, fileName, FileTypeMap.getDefaultFileTypeMap().getContentType(fileName), new ByteArrayInputStream(fileByteArray));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Timed
    public Attachment addAttachment(String ciId, String fileName, String contentType, InputStream inputStream) {
        Try<InputStream> validatedInputStreamTry;
        logger.debug("Attaching {} to {}", (Object)fileName.replaceAll(NEWLINES, "_"), (Object)ciId.replaceAll(NEWLINES, "_"));
        Release release = this.releaseRepository.findById(Ids.releaseIdFrom((String)ciId));
        Task task = null;
        if (!Ids.isReleaseId((String)ciId)) {
            task = release.getTask(ciId);
        }
        if ((validatedInputStreamTry = this.fileContentValidator.validate(fileName, inputStream)).isFailure()) {
            throw new DeployitException("Validation failed for file '%s'", new Object[]{fileName});
        }
        try (InputStream validatedInputStream = (InputStream)validatedInputStreamTry.get();){
            Attachment attachment2 = this.attachmentService.attachToRelease(release, fileName, contentType, validatedInputStream);
            if (task != null) {
                task.getAttachments().add(attachment2);
            }
            this.attachmentRepository.insertAttachment(release.getId(), attachment2);
            if (null != task) {
                Attachment attachment3 = this.releaseActorService.createAttachmentOnTask(task.getId(), attachment2);
                return attachment3;
            }
            Attachment attachment = this.releaseActorService.createAttachmentOnRelease(release.getId(), attachment2);
            return attachment;
        }
        catch (IOException e) {
            throw new DeployitException((Throwable)e, "Unable to attach '%s'", new Object[]{fileName});
        }
    }

    @Timed
    public TemplateLogo addLogo(String ciId, String filename, String contentType, InputStream content) throws IOException {
        if (!CustomLogoContentType.getAllTypes().contains(contentType)) {
            throw new IllegalArgumentException(String.format("Content type %s not allowed. Allowed content types are: %s", contentType, CustomLogoContentType.getBrowserTypes().toString()));
        }
        Try<InputStream> validatedInputStreamTry = this.fileContentValidator.validate(filename, content);
        if (validatedInputStreamTry.isFailure()) {
            throw new DeployitException("Validation failed for file '%s'", new Object[]{filename});
        }
        try (InputStream validatedInputStream = (InputStream)validatedInputStreamTry.get();){
            logger.debug("Attaching logo to {}", (Object)ciId);
            Optional maybeUid = OptionConverters.toJava(this.releaseRepository.getUid(ciId));
            TemplateLogo templateLogo = maybeUid.map(releaseUid -> {
                TemplateLogo logo = this.createLogo(ciId, filename, contentType, validatedInputStream);
                TemplateLogo createdLogo = this.templateMetadataRepository.createOrUpdateLogo((Long)releaseUid, logo);
                this.eventBus.publish((XLReleaseEvent)new TemplateLogoUpdatedEvent(ciId, createdLogo));
                return createdLogo;
            }).orElseThrow(() -> new NotFoundException("Repository entity [%s] not found", new Object[]{ciId}));
            return templateLogo;
        }
    }

    private TemplateLogo createLogo(String releaseId, String filename, String contentType, InputStream bytes) {
        AttachmentSizeLimiter limiter = new AttachmentSizeLimiter(TemplateLogo.getDefaultMaxLogoSize(), bytes);
        StreamWrappingOverthereFile file = new StreamWrappingOverthereFile(filename, (InputStream)((Object)limiter));
        String logoId = IdUtils.getUniqueId((Type)Type.valueOf(TemplateLogo.class), (String)releaseId);
        TemplateLogo templateLogo = new TemplateLogo((OverthereFile)file, contentType);
        templateLogo.setId(logoId);
        templateLogo.getExportFilename();
        String releaseTitle = this.releaseRepository.getTitle(releaseId);
        templateLogo.setProperty("parentTitle", (Object)releaseTitle);
        templateLogo.getPortableFilename();
        return templateLogo;
    }
}

