/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.PermissionsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TeamCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TeamDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TeamUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.initialize.TutorialsFolderInitializer;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.SecurityRepository;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.security.SecuredCi;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.TeamOperationsService;
import com.xebialabs.xlrelease.utils.Diff;
import com.xebialabs.xlrelease.views.TeamView;
import com.xebialabs.xlrelease.views.converters.TeamMemberViewConverter;
import io.micrometer.core.annotation.Timed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.StreamConverters;

@Service
@IsTransactional
public class TeamService
implements TeamOperationsService {
    public static final String GLOBAL_ROLES_ROOT = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/security/global";
    public static final String CACHE_KEY_SECURED_CI_FOR_CONTAINER_ID = "securedCiForContainerId:";
    public static final String CACHE_KEY_TEAMS_FOR_SECURED_CI = "teamsForSecuredCi:";
    private final TeamRepository teamRepository;
    private final ReleaseRepository releaseRepository;
    private final SecuredCis securedCis;
    private final XLReleaseEventBus eventBus;
    private final CiIdService ciIdService;
    private final SecurityRepository securityRepository;
    public final ArchivingService archivingService;

    @Autowired
    public TeamService(TeamRepository teamRepository, ReleaseRepository releaseRepository, ArchivingService archivingService, SecuredCis securedCis, XLReleaseEventBus eventBus, CiIdService ciIdService, SecurityRepository securityRepository) {
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.archivingService = archivingService;
        this.securedCis = securedCis;
        this.eventBus = eventBus;
        this.ciIdService = ciIdService;
        this.securityRepository = securityRepository;
    }

    @Timed
    public Team addTeam(Release release, Team team) {
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't add team to release '%s' because it is %s", (Object)release.getTitle(), (Object)release.getStatus());
        Preconditions.checkArgument((!Ids.isInFolder((String)release.getId()) ? 1 : 0) != 0, (String)"Can't add team to release '%s' because it is inside a folder", (Object)release.getTitle());
        this.generateIdIfNecessary(release.getId(), team);
        Team addedTeam = this.teamRepository.create(release.getId(), team);
        release.addTeam(addedTeam);
        this.eventBus.publish((XLReleaseEvent)TeamCreatedEvent.apply((Release)release, (Team)addedTeam));
        this.eventBus.publish((XLReleaseEvent)TeamsUpdatedEvent.apply((String)release.getId()));
        return addedTeam;
    }

    @Timed
    public Team addTeam(String containerId, Team team) {
        this.generateIdIfNecessary(containerId, team);
        Team addedTeam = this.teamRepository.create(containerId, team);
        this.eventBus.publish((XLReleaseEvent)TeamCreatedEvent.apply((String)containerId, (Team)addedTeam));
        this.eventBus.publish((XLReleaseEvent)TeamsUpdatedEvent.apply((String)containerId));
        return addedTeam;
    }

    @Timed
    public Team updateTeam(String teamId, Team newTeam) {
        String releaseId = Ids.releaseIdFrom((String)teamId);
        Release release = this.releaseRepository.findById(releaseId);
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't update team on release '%s' because it is %s", (Object)release.getTitle(), (Object)release.getStatus());
        Preconditions.checkArgument((!Ids.isInFolder((String)releaseId) ? 1 : 0) != 0, (String)"Can't update team on release '%s' because it is inside a folder", (Object)release.getTitle());
        this.decorateWithStoredTeams(release);
        Team team = release.getTeamWithId(teamId);
        if (team.isSystemTeam()) {
            Preconditions.checkArgument((boolean)newTeam.getTeamName().equals(team.getTeamName()), (Object)"Cannot rename a system release");
        }
        release.updateTeam(newTeam);
        this.saveTeamsToPlatform(release, false);
        this.eventBus.publish((XLReleaseEvent)TeamUpdatedEvent.apply((Release)release, (Team)team, (Team)newTeam));
        this.eventBus.publish((XLReleaseEvent)TeamsUpdatedEvent.apply((String)release.getId()));
        return team;
    }

    @Timed
    public List<Team> updateTeams(String releaseId, List<Team> updatedTeams) {
        Release release = this.releaseRepository.findById(releaseId);
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't update teams on release '%s' because it is %s", (Object)release.getTitle(), (Object)release.getStatus());
        Preconditions.checkArgument((!Ids.isInFolder((String)release.getId()) ? 1 : 0) != 0, (String)"Can't update teams on release '%s' because it is inside a folder", (Object)release.getTitle());
        this.decorateWithStoredTeams(release);
        List currentTeams = release.getTeams();
        Map<String, Set<String>> currentPermissions = this.getTeamsPermissions(currentTeams);
        Set updatedTeamIds = updatedTeams.stream().map(BaseConfigurationItem::getId).collect(Collectors.toSet());
        Set currentTeamIds = currentTeams.stream().map(BaseConfigurationItem::getId).collect(Collectors.toSet());
        Set<Team> toDelete = currentTeams.stream().filter(team -> !updatedTeamIds.contains(team.getId())).collect(Collectors.toSet());
        Set<Team> toUpdate = updatedTeams.stream().filter(team -> currentTeamIds.contains(team.getId())).collect(Collectors.toSet());
        Set<Team> toCreate = updatedTeams.stream().filter(team -> !currentTeamIds.contains(team.getId())).collect(Collectors.toSet());
        ArrayList<PermissionsUpdatedEvent> teamEvents = new ArrayList<PermissionsUpdatedEvent>();
        toDelete.forEach(team -> {
            release.deleteTeam(team.getId());
            teamEvents.add((PermissionsUpdatedEvent)TeamDeletedEvent.apply((Release)release, (Team)team));
        });
        toUpdate.forEach(team -> {
            Team currentTeam = release.getTeamWithId(team.getId());
            Team original = CiCloneHelper.cloneCi(currentTeam);
            release.updateTeam(team);
            if (!original.equals(team)) {
                teamEvents.add((PermissionsUpdatedEvent)TeamUpdatedEvent.apply((Release)release, (Team)original, (Team)team));
            }
        });
        toCreate.forEach(team -> {
            release.addTeam(team);
            teamEvents.add((PermissionsUpdatedEvent)TeamCreatedEvent.apply((Release)release, (Team)team));
        });
        Map<String, Set<String>> newPermissions = this.getTeamsPermissions(release.getTeams());
        if (!newPermissions.equals(currentPermissions)) {
            teamEvents.add(new PermissionsUpdatedEvent(release.getTeams()));
        }
        this.saveTeamsToPlatform(release, false);
        teamEvents.forEach(this.eventBus::publish);
        if (!teamEvents.isEmpty()) {
            this.eventBus.publish((XLReleaseEvent)TeamsUpdatedEvent.apply((String)releaseId));
        }
        return release.getTeams();
    }

    @Timed
    public void deleteTeam(Release release, String teamId) {
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't delete team from release '%s' because it is %s", (Object)release.getTitle(), (Object)release.getStatus());
        Preconditions.checkArgument((!Ids.isInFolder((String)release.getId()) ? 1 : 0) != 0, (String)"Can't delete team from release '%s' because it is inside a folder", (Object)release.getTitle());
        Team team = release.getTeamWithId(teamId);
        release.deleteTeam(teamId);
        this.saveTeamsToPlatform(release, false);
        this.eventBus.publish((XLReleaseEvent)TeamDeletedEvent.apply((Release)release, (Team)team));
        this.eventBus.publish((XLReleaseEvent)TeamsUpdatedEvent.apply((String)release.getId()));
    }

    @Timed
    public void deleteTeam(String containerId, String teamId) {
        List<Team> teams = this.getEffectiveTeams(containerId);
        Team toDelete = teams.stream().filter(team -> team.getId().equals(teamId)).findFirst().orElseThrow(() -> new IllegalStateException("Container " + containerId + " doesn't contain team with id " + teamId));
        this.teamRepository.delete(teamId);
        this.eventBus.publish((XLReleaseEvent)TeamDeletedEvent.apply((String)containerId, (Team)toDelete));
        this.eventBus.publish((XLReleaseEvent)TeamsUpdatedEvent.apply((String)containerId));
    }

    public List<Team> saveTeamsToPlatform(Release release) {
        return this.saveTeamsToPlatform(release, true);
    }

    private List<Team> saveTeamsToPlatform(Release release, boolean publishEvent) {
        return this.saveTeamsToPlatform(release.getId(), release.getTeams(), publishEvent);
    }

    public List<Team> saveTeamsToPlatform(String containerId, List<Team> teams) {
        return this.saveTeamsToPlatform(containerId, teams, true);
    }

    private List<Team> saveTeamsToPlatform(String containerId, List<Team> teams, boolean publishEvents) {
        Tuple2<List<Team>, List<XLReleaseEvent>> result = this.saveTeamsToPlatformWithoutPublishing(containerId, teams, publishEvents);
        if (publishEvents) {
            ((List)result._2).forEach(this.eventBus::publish);
        }
        return (List)result._1;
    }

    public Tuple2<List<Team>, List<XLReleaseEvent>> saveTeamsToPlatformWithoutPublishing(String containerId, List<Team> teams, boolean buildEvents) {
        Optional<Team> invalidTeam = teams.stream().filter(team -> !Ids.isNullId((String)team.getId()) && !containerId.equals(Ids.getParentId((String)team.getId()))).findFirst();
        Preconditions.checkArgument((boolean)invalidTeam.isEmpty(), (String)"Cannot save team '%s' as it does not belong to '%s'", invalidTeam, (Object)containerId);
        teams.forEach(team -> {
            if (team.getTeamName() != null) {
                team.setTeamName(team.getTeamName().trim());
            }
            this.generateIdIfNecessary(containerId, (Team)team);
        });
        List<Team> originalTeams = buildEvents ? this.getStoredTeams(containerId) : null;
        List<Team> newTeams = this.teamRepository.saveTeamsToPlatform(containerId, teams);
        ArrayList<TeamsUpdatedEvent> events = new ArrayList<TeamsUpdatedEvent>();
        if (buildEvents) {
            Diff differences = Diff.applyWithKeyMapping(originalTeams, newTeams, BaseConfigurationItem::getId);
            CollectionConverters.asJava((Iterable)differences.deletedValues()).forEach(t -> events.add((TeamsUpdatedEvent)TeamDeletedEvent.apply((String)containerId, (Team)t)));
            CollectionConverters.asJava((Iterable)differences.newValues()).forEach(t -> events.add((TeamsUpdatedEvent)TeamCreatedEvent.apply((String)containerId, (Team)t)));
            StreamConverters.asJavaSeqStream((IterableOnce)differences.updatedPairs()).filter(this::areTeamsDifferent).forEach(teamTuple2 -> events.add((TeamsUpdatedEvent)TeamUpdatedEvent.apply((String)containerId, (Team)((Team)teamTuple2._1), (Team)((Team)teamTuple2._2))));
            events.add(TeamsUpdatedEvent.apply((String)containerId));
        }
        return new Tuple2(newTeams, events);
    }

    private boolean areTeamsDifferent(Tuple2<Team, Team> updatedPair) {
        Team before = (Team)updatedPair._1;
        Team after = (Team)updatedPair._2;
        return !before.equals((Object)after);
    }

    public void deleteTeamsFromPlatform(String containerId) {
        List<Team> teamsToDelete = this.getEffectiveTeams(containerId);
        this.teamRepository.deleteTeamsFromPlatform(containerId);
        teamsToDelete.forEach(team -> this.eventBus.publish((XLReleaseEvent)TeamDeletedEvent.apply((String)containerId, (Team)team)));
        this.eventBus.publish((XLReleaseEvent)TeamsUpdatedEvent.apply((String)containerId));
    }

    public Optional<Team> findTeamByName(String containerId, String teamName) {
        return this.findTeamsByNames(containerId, Collections.singletonList(teamName)).findFirst();
    }

    public Stream<Team> findTeamsByNames(String containerId, Collection<String> teamNames, DecoratorsCache cache) {
        return this.getEffectiveTeams(containerId, cache).stream().filter(team -> teamNames.contains(team.getTeamName()));
    }

    public Stream<Team> findTeamsByNames(String containerId, Collection<String> teamNames) {
        return this.getEffectiveTeams(containerId).stream().filter(team -> teamNames.contains(team.getTeamName()));
    }

    public void decorateWithEffectiveTeams(Release release) {
        this.decorateWithEffectiveTeams(release, DecoratorsCache.NO_CACHE());
        release.setTeams(this.getEffectiveTeams(release));
    }

    public void decorateWithEffectiveTeams(Release release, DecoratorsCache cache) {
        release.setTeams(this.getEffectiveTeams(release, cache));
    }

    public List<Team> getEffectiveTeams(Release release) {
        return this.getEffectiveTeams(release, DecoratorsCache.NO_CACHE());
    }

    public List<Team> getEffectiveTeams(Release release, DecoratorsCache cache) {
        if (release.isArchived()) {
            return release.getTeams();
        }
        String containerId = release.getId();
        return this.getEffectiveTeamsForContainerId(containerId, cache);
    }

    private List<Team> getEffectiveTeamsForContainerId(String containerId, DecoratorsCache cache) {
        SecuredCi securedCi = (SecuredCi)cache.getDecoratorCache(CACHE_KEY_SECURED_CI_FOR_CONTAINER_ID + (containerId == null ? "" : containerId)).computeIfAbsent(() -> this.securedCis.getEffectiveSecuredCi(containerId));
        return (List)cache.getDecoratorCache(CACHE_KEY_TEAMS_FOR_SECURED_CI + (String)(securedCi == null ? "" : securedCi.getId() + ":" + securedCi.getSecurityUid())).computeIfAbsent(() -> this.teamRepository.getTeams(securedCi));
    }

    public List<Team> getEffectiveTeams(Folder folder) {
        return this.teamRepository.getTeams(folder.get$internalId() != null && folder.get$internalId().equals(folder.get$securedCi()) ? new SecuredCi(folder.getId(), folder.get$internalId().longValue()) : this.securedCis.getEffectiveSecuredCi(folder.getId()));
    }

    public List<Team> getEffectiveTeams(String containerId) {
        return this.getEffectiveTeams(containerId, DecoratorsCache.NO_CACHE());
    }

    public List<Team> getEffectiveTeams(String containerId, DecoratorsCache cache) {
        if (this.isArchivedRelease(containerId)) {
            return this.archivingService.getRelease(containerId).getTeams();
        }
        return this.getEffectiveTeamsForContainerId(containerId, cache);
    }

    public List<TeamView> getEffectiveTeamViews(String containerId, TeamMemberViewConverter teamMemberViewConverter) {
        if (this.isArchivedRelease(containerId)) {
            List teams = this.archivingService.getRelease(containerId).getTeams();
            return teams.stream().map(team -> new TeamView((Team)team, teamMemberViewConverter)).sorted(Comparator.comparing(TeamView::getTeamName)).toList();
        }
        return this.getTeamViews(containerId);
    }

    public void decorateWithStoredTeams(Release release) {
        release.setTeams(this.getStoredTeams(release));
    }

    public List<Team> getStoredTeams(Release release) {
        String parentId;
        if (release.isArchived()) {
            return release.getTeams();
        }
        if (release.getId() != null && (parentId = Ids.getParentId((String)release.getId())) != null && !Ids.isRoot((String)parentId) && !parentId.equals(TutorialsFolderInitializer.SAMPLES_AND_TUTORIALS_FOLDER_ID())) {
            return Collections.emptyList();
        }
        return this.teamRepository.getTeams(this.securedCis.getSecuredCi(release.getId()));
    }

    public List<Team> getStoredTeams(String containerId) {
        if (this.isArchivedRelease(containerId)) {
            return this.archivingService.getRelease(containerId).getTeams();
        }
        return this.teamRepository.getTeams(this.securedCis.getSecuredCi(containerId));
    }

    private Map<String, Set<String>> getTeamsPermissions(Collection<Team> teams) {
        return teams.stream().collect(Collectors.toMap(Team::getTeamName, team -> new HashSet(team.getPermissions())));
    }

    public boolean isArchivedRelease(String containerId) {
        return Ids.isReleaseId((String)containerId) && !this.releaseRepository.exists(containerId) && this.archivingService.exists(containerId);
    }

    public void generateIdIfNecessary(String containerId, Team team) {
        if (Ids.isNullId((String)team.getId())) {
            team.setId(this.ciIdService.getUniqueId(Type.valueOf(Team.class), containerId));
        }
    }

    public void generateIdIfNecessary(Role role) {
        if (role != null && (Ids.isNullId((String)role.getId()) || "-1".equals(role.getId()))) {
            role.setId(Ids.getName((String)this.ciIdService.getUniqueId("Role", GLOBAL_ROLES_ROOT)));
        }
    }

    @Override
    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public SecurityRepository securityRepository() {
        return this.securityRepository;
    }

    @Override
    public SecuredCis securedCis() {
        return this.securedCis;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }
}

