/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.authentication;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plumbing.authentication.InternalUser;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.PersonalAuthenticationToken;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.features.PersonalAccessTokenFeature;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.security.UserGroupService;
import com.xebialabs.xlrelease.security.authentication.OwnerAuthenticationToken;
import com.xebialabs.xlrelease.security.authentication.TokenExpiredException;
import com.xebialabs.xlrelease.service.UserLastActiveActorService;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringAwareBean;
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringSupport;
import com.xebialabs.xlrelease.utils.DateVariableUtils;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component(value="xlAuthenticationProvider")
@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001B\n\u0015\u0001}AQ\u0001\u0012\u0001\u0005\u0002\u0015C\u0001\u0002\u0013\u0001\t\u0006\u0004%I!\u0013\u0005\t#\u0002A)\u0019!C\u0005%\"A\u0011\f\u0001EC\u0002\u0013%!\f\u0003\u0005_\u0001!\u0015\r\u0011\"\u0003`\u0011!!\u0007\u0001#b\u0001\n\u0013)\u0007\u0002\u00037\u0001\u0011\u000b\u0007I\u0011B7\t\u000fQ\u0004\u0001\u0019!C\u0005k\"I\u0011\u0011\u0001\u0001A\u0002\u0013%\u00111\u0001\u0005\b\u0003+\u0001\u0001\u0015)\u0003w\u0011\u001d\t9\u0002\u0001C!\u00033Aq!!!\u0001\t\u0013\t\u0019\tC\u0004\u0002\b\u0002!I!!#\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\"9\u00111\u0014\u0001\u0005\n\u0005u\u0005bBA`\u0001\u0011\u0005\u0013\u0011\u0019\u0005\u0007\u0003C\u0004A\u0011A;\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\ni\"+\u001a7fCN,\u0017)\u001e;iK:$\u0018nY1uS>t\u0007K]8wS\u0012,'O\u0003\u0002\u0016-\u0005q\u0011-\u001e;iK:$\u0018nY1uS>t'BA\f\u0019\u0003!\u0019XmY;sSRL(BA\r\u001b\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001c9\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002;\u0005\u00191m\\7\u0004\u0001M)\u0001\u0001\t\u00153yA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005Y\u0006twMC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#AB(cU\u0016\u001cG\u000f\u0005\u0002*a5\t!F\u0003\u0002\u0016W)\u0011q\u0003\f\u0006\u0003[9\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002_\u0005\u0019qN]4\n\u0005ER#AF!vi\",g\u000e^5dCRLwN\u001c)s_ZLG-\u001a:\u0011\u0005MRT\"\u0001\u001b\u000b\u0005U2\u0014AB:qe&twM\u0003\u00028q\u0005)\u0001/Z6l_*\u0011\u0011\bG\u0001\bgV\u0004\bo\u001c:u\u0013\tYDG\u0001\u000bTG\u0006d\u0017m\u00159sS:<\u0017i^1sK\n+\u0017M\u001c\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000bQa\u001d7gi)T\u0011!Q\u0001\tOJL'P\u001f7fI&\u00111I\u0010\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\ta\t\u0005\u0002H\u00015\tA#A\u0006vg\u0016\u00148+\u001a:wS\u000e,W#\u0001&\u0011\u0005-{U\"\u0001'\u000b\u0005]i%B\u0001(\u001b\u0003!!W\r\u001d7ps&$\u0018B\u0001)M\u0005-)6/\u001a:TKJ4\u0018nY3\u0002!U\u001cXM\u001d+pW\u0016t7+\u001a:wS\u000e,W#A*\u0011\u0005Q;V\"A+\u000b\u0005YC\u0012aB:feZL7-Z\u0005\u00031V\u0013\u0001#V:feR{7.\u001a8TKJ4\u0018nY3\u00025U\u001cXM\u001d'bgR\f5\r^5wK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0016\u0003m\u0003\"\u0001\u0016/\n\u0005u+&AG+tKJd\u0015m\u001d;BGRLg/Z!di>\u00148+\u001a:wS\u000e,\u0017\u0001E;tKJ<%o\\;q'\u0016\u0014h/[2f+\u0005\u0001\u0007CA1c\u001b\u00051\u0012BA2\u0017\u0005A)6/\u001a:He>,\boU3sm&\u001cW-A\u000bqe&t7-\u001b9bY\u0012\u000bG/\u0019)s_ZLG-\u001a:\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!!\u001b\r\u0002\u001bA\u0014\u0018N\\2ja\u0006dG-\u0019;b\u0013\tY\u0007NA\u000bQe&t7-\u001b9bY\u0012\u000bG/\u0019)s_ZLG-\u001a:\u00025A,'o]8oC2\f5mY3tgR{7.\u001a8GK\u0006$XO]3\u0016\u00039\u0004\"a\u001c:\u000e\u0003AT!!\u001d\r\u0002\u0011\u0019,\u0017\r^;sKNL!a\u001d9\u00035A+'o]8oC2\f5mY3tgR{7.\u001a8GK\u0006$XO]3\u0002#\u0005,H\u000f[8sSRLWm]'baB,'/F\u0001w!\t9h0D\u0001y\u0015\tI(0A\u0004nCB\u0004\u0018N\\4\u000b\u0005md\u0018!C1vi\"|'/\u001b;z\u0015\ti8&\u0001\u0003d_J,\u0017BA@y\u0005a9%/\u00198uK\u0012\fU\u000f\u001e5pe&$\u0018.Z:NCB\u0004XM]\u0001\u0016CV$\bn\u001c:ji&,7/T1qa\u0016\u0014x\fJ3r)\u0011\t)!!\u0005\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q!!a\u0003\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005=\u0011\u0011\u0002\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0014%\t\t\u00111\u0001w\u0003\rAH%M\u0001\u0013CV$\bn\u001c:ji&,7/T1qa\u0016\u0014\b%\u0001\u0007bkRDWM\u001c;jG\u0006$X\r\u0006\u0003\u0002\u001c\u0005\r\u0002\u0003BA\u000f\u0003?i\u0011\u0001`\u0005\u0004\u0003Ca(AD!vi\",g\u000e^5dCRLwN\u001c\u0005\b\u0003KY\u0001\u0019AA\u000e\u0003\u0015!xn[3oQ\u0015Y\u0011\u0011FA\u001b!\u0019\t9!a\u000b\u00020%!\u0011QFA\u0005\u0005\u0019!\bN]8xgB!\u0011QDA\u0019\u0013\r\t\u0019\u0004 \u0002\u0018\u0003V$\b.\u001a8uS\u000e\fG/[8o\u000bb\u001cW\r\u001d;j_:\ftAHA\u001c\u0003\u001b\ny\b\u0005\u0003\u0002:\u0005\u001dc\u0002BA\u001e\u0003\u0007\u0002B!!\u0010\u0002\n5\u0011\u0011q\b\u0006\u0004\u0003\u0003r\u0012A\u0002\u001fs_>$h(\u0003\u0003\u0002F\u0005%\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002J\u0005-#AB*ue&twM\u0003\u0003\u0002F\u0005%\u0011'C\u0012\u0002P\u0005]\u0013QOA-+\u0011\t\t&a\u0015\u0016\u0005\u0005]BaBA+=\t\u0007\u0011q\f\u0002\u0002)&!\u0011\u0011LA.\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)!\u0011QLA\u0005\u0003\u0019!\bN]8xgF!\u0011\u0011MA4!\u0011\t9!a\u0019\n\t\u0005\u0015\u0014\u0011\u0002\u0002\b\u001d>$\b.\u001b8h!\u0011\tI'a\u001c\u000f\t\u0005\u001d\u00111N\u0005\u0005\u0003[\nI!A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00141\u000f\u0002\n)\"\u0014xn^1cY\u0016TA!!\u001c\u0002\nEJ1%a\u001e\u0002z\u0005m\u0014Q\f\b\u0005\u0003\u000f\tI(\u0003\u0003\u0002^\u0005%\u0011g\u0002\u0012\u0002\b\u0005%\u0011Q\u0010\u0002\u0006g\u000e\fG.Y\u0019\u0004M\u0005=\u0012!G1vi\",g\u000e^5dCR,gI]8n+N,'\u000fV8lK:$B!a\u0007\u0002\u0006\"9\u0011Q\u0005\u0007A\u0002\u0005]\u0012aG1vi\",g\u000e^5dCR,gI]8n\u0007J,G-\u001a8uS\u0006d7\u000f\u0006\u0004\u0002\u001c\u0005-\u0015q\u0012\u0005\b\u0003\u001bk\u0001\u0019AA\u001c\u0003!)8/\u001a:oC6,\u0007bBAI\u001b\u0001\u0007\u0011qG\u0001\ta\u0006\u001c8o^8sI\u0006a\u0012-\u001e;iK:$\u0018nY1uK\u001a\u0013x.\u001c*fY\u0016\f7/Z(x]\u0016\u0014H\u0003BA\u000e\u0003/Cq!!'\u000f\u0001\u0004\t9$A\u0003po:,'/A\nfm\u0006dW/\u0019;f\u0003V$\bn\u001c:ji&,7\u000f\u0006\u0003\u0002 \u0006u\u0006\u0007BAQ\u0003c\u0003b!a)\u0002*\u00065VBAAS\u0015\r\t9\u000bJ\u0001\u0005kRLG.\u0003\u0003\u0002,\u0006\u0015&AC\"pY2,7\r^5p]B!\u0011qVAY\u0019\u0001!1\"a-\u0010\u0003\u0003\u0005\tQ!\u0001\u00026\n\u0019q\f\n\u001b\u0012\t\u0005\u0005\u0014q\u0017\t\u0005\u0003;\tI,C\u0002\u0002<r\u0014\u0001c\u0012:b]R,G-Q;uQ>\u0014\u0018\u000e^=\t\u000f\u00055u\u00021\u0001\u00028\u0005A1/\u001e9q_J$8\u000f\u0006\u0003\u0002D\u0006%\u0007\u0003BA\u0004\u0003\u000bLA!a2\u0002\n\t9!i\\8mK\u0006t\u0007BB\u000b\u0011\u0001\u0004\tY\r\r\u0003\u0002N\u0006U\u0007CBA\u001d\u0003\u001f\f\u0019.\u0003\u0003\u0002R\u0006-#!B\"mCN\u001c\b\u0003BAX\u0003+$A\"a6\u0002J\u0006\u0005\t\u0011!B\u0001\u00033\u00141a\u0018\u00136#\u0011\t\t'a7\u0011\t\u0005\u001d\u0011Q\\\u0005\u0005\u0003?\fIAA\u0002B]f\fAcZ3u\u0003V$\bn\u001c:ji&,7/T1qa\u0016\u0014\u0018\u0001F:fi\u0006+H\u000f[8sSRLWm]'baB,'\u000f\u0006\u0003\u0002\u0006\u0005\u001d\b\"\u0002;\u0013\u0001\u00041\bf\u0002\u0001\u0002l\u0006]\u0018\u0011 \t\u0005\u0003[\f\u00190\u0004\u0002\u0002p*\u0019\u0011\u0011\u001f\u0017\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002v\u0006=(!C\"p[B|g.\u001a8u\u0003\u00151\u0018\r\\;fC\t\tY0\u0001\ryY\u0006+H\u000f[3oi&\u001c\u0017\r^5p]B\u0013xN^5eKJ\u0004")
public class ReleaseAuthenticationProvider
implements AuthenticationProvider,
ScalaSpringAwareBean,
Logging {
    private UserService userService;
    private UserTokenService userTokenService;
    private UserLastActiveActorService userLastActiveActorService;
    private UserGroupService userGroupService;
    private PrincipalDataProvider principalDataProvider;
    private PersonalAccessTokenFeature personalAccessTokenFeature;
    private GrantedAuthoritiesMapper authoritiesMapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private transient ApplicationContext applicationContext;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public ApplicationContext getApplicationContext() {
        return ScalaSpringAwareBean.getApplicationContext$((ScalaSpringAwareBean)this);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ScalaSpringAwareBean.setApplicationContext$((ScalaSpringAwareBean)this, (ApplicationContext)applicationContext);
    }

    public <T> T springBean(ClassTag<T> evidence$1) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, evidence$1);
    }

    public <T> T springBean(String name, ClassTag<T> evidence$2) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, (String)name, evidence$2);
    }

    public <T> Map<String, T> springBeans(ClassTag<T> evidence$3) {
        return ScalaSpringSupport.springBeans$((ScalaSpringSupport)this, evidence$3);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ApplicationContext applicationContext() {
        return this.applicationContext;
    }

    public void applicationContext_$eq(ApplicationContext x$1) {
        this.applicationContext = x$1;
    }

    private UserService userService$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.userService = (UserService)this.springBean(ClassTag$.MODULE$.apply(UserService.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.userService;
    }

    private UserService userService() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.userService$lzycompute();
        }
        return this.userService;
    }

    private UserTokenService userTokenService$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.userTokenService = (UserTokenService)this.springBean(ClassTag$.MODULE$.apply(UserTokenService.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.userTokenService;
    }

    private UserTokenService userTokenService() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.userTokenService$lzycompute();
        }
        return this.userTokenService;
    }

    private UserLastActiveActorService userLastActiveActorService$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.userLastActiveActorService = (UserLastActiveActorService)this.springBean(ClassTag$.MODULE$.apply(UserLastActiveActorService.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.userLastActiveActorService;
    }

    private UserLastActiveActorService userLastActiveActorService() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.userLastActiveActorService$lzycompute();
        }
        return this.userLastActiveActorService;
    }

    private UserGroupService userGroupService$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.userGroupService = (UserGroupService)this.springBean(ClassTag$.MODULE$.apply(UserGroupService.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.userGroupService;
    }

    private UserGroupService userGroupService() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.userGroupService$lzycompute();
        }
        return this.userGroupService;
    }

    private PrincipalDataProvider principalDataProvider$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.principalDataProvider = (PrincipalDataProvider)this.springBean(ClassTag$.MODULE$.apply(PrincipalDataProvider.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.principalDataProvider;
    }

    private PrincipalDataProvider principalDataProvider() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.principalDataProvider$lzycompute();
        }
        return this.principalDataProvider;
    }

    private PersonalAccessTokenFeature personalAccessTokenFeature$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.personalAccessTokenFeature = (PersonalAccessTokenFeature)this.springBean(ClassTag$.MODULE$.apply(PersonalAccessTokenFeature.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.personalAccessTokenFeature;
    }

    private PersonalAccessTokenFeature personalAccessTokenFeature() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.personalAccessTokenFeature$lzycompute();
        }
        return this.personalAccessTokenFeature;
    }

    private GrantedAuthoritiesMapper authoritiesMapper() {
        return this.authoritiesMapper;
    }

    private void authoritiesMapper_$eq(GrantedAuthoritiesMapper x$1) {
        this.authoritiesMapper = x$1;
    }

    public Authentication authenticate(Authentication token) throws AuthenticationException {
        Authentication authentication;
        this.logger().debug((Function0 & Serializable)() -> "Authenticating for Digital.ai Release");
        try {
            Authentication authentication2 = token;
            authentication = authentication2 instanceof PersonalAuthenticationToken ? this.authenticateFromUserToken(token.getCredentials().toString()) : (authentication2 instanceof OwnerAuthenticationToken ? this.authenticateFromReleaseOwner(token.getPrincipal().toString()) : this.authenticateFromCredentials(token.getPrincipal().toString(), token.getCredentials().toString()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AuthenticationFailureException ? true : throwable2 instanceof NotFoundException) {
                throw new BadCredentialsException(throwable2.getMessage(), throwable2);
            }
            throw throwable;
        }
        return authentication;
    }

    private Authentication authenticateFromUserToken(String token) {
        this.logger().trace((Function0 & Serializable)() -> "Authenticating using personal access token");
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        UserToken userToken = (UserToken)this.userTokenService().findByUserToken(tokenHash).getOrElse((Function0 & Serializable)() -> {
            throw new AuthenticationFailureException("Cannot authenticate with supplied personal access token");
        });
        if (userToken.isExpired()) {
            throw new TokenExpiredException("The token expired on " + DateVariableUtils.printDate((Date)userToken.expiryDate()));
        }
        this.userLastActiveActorService().updateTokenLastUsed(Predef$.MODULE$.long2Long(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(userToken.ciUid()))));
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(userToken.username());
        return new PersonalAuthenticationToken((Object)new InternalUser(userToken.username()), token, userToken.expiryDate(), mappedAuthorities, (Set)Option$.MODULE$.apply((Object)userToken.userTokenPermission()).map((Function1 & Serializable)x$1 -> x$1.globalPermissions()).getOrElse((Function0 & Serializable)() -> Collections.emptySet()), Collections.emptySet(), Collections.emptySet());
    }

    private Authentication authenticateFromCredentials(String username, String password) {
        this.logger().trace((Function0 & Serializable)() -> "Authenticating [" + username + "]");
        if (Strings.isBlank((String)username)) {
            throw new BadCredentialsException("Cannot authenticate with empty username");
        }
        this.userService().authenticate(username, password);
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(username);
        return new UsernamePasswordAuthenticationToken((Object)new InternalUser(username), (Object)password, mappedAuthorities);
    }

    private Authentication authenticateFromReleaseOwner(String owner) {
        this.logger().trace((Function0 & Serializable)() -> "Authenticating release owner: [" + owner + "]");
        if (Strings.isBlank((String)owner)) {
            throw new BadCredentialsException("Cannot authenticate with empty release owner");
        }
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(owner);
        return new OwnerAuthenticationToken(new InternalUser(owner), mappedAuthorities);
    }

    private Collection<? extends GrantedAuthority> evaluateAuthorities(String username) {
        ArrayList<SimpleGrantedAuthority> arrayList;
        UserData userData = this.principalDataProvider().getUserData(username);
        if (userData.isFound()) {
            return this.authoritiesMapper().mapAuthorities(this.principalDataProvider().getAuthorities(username));
        }
        try {
            User user = this.userService().read(username);
            ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
            Object object = user.isAdmin() || "admin".equals(user.getUsername()) ? BoxesRunTime.boxToBoolean((boolean)grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"))) : BoxedUnit.UNIT;
            arrayList = grantedAuthorities;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NotFoundException && this.personalAccessTokenFeature().enabled()) {
                scala.collection.immutable.Set<String> userGroups = this.userGroupService().findGroupsForUser(username);
                ArrayList grantedAuthorities = new ArrayList();
                userGroups.foreach((Function1 & Serializable)group -> BoxesRunTime.boxToBoolean((boolean)grantedAuthorities.add(new SimpleGrantedAuthority(group))));
                arrayList = grantedAuthorities;
            }
            throw throwable;
        }
        ArrayList<SimpleGrantedAuthority> authorities = arrayList;
        return this.authoritiesMapper().mapAuthorities(authorities);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class) || authentication.isAssignableFrom(PersonalAuthenticationToken.class) || authentication.isAssignableFrom(OwnerAuthenticationToken.class);
    }

    public GrantedAuthoritiesMapper getAuthoritiesMapper() {
        return this.authoritiesMapper();
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper_$eq(authoritiesMapper);
    }

    public ReleaseAuthenticationProvider() {
        ScalaSpringSupport.$init$((ScalaSpringSupport)this);
        ScalaSpringAwareBean.$init$((ScalaSpringAwareBean)this);
        Logging.$init$((Logging)this);
        this.authoritiesMapper = new NullAuthoritiesMapper();
    }
}

