/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.forms.CreatePersonalAccessTokenForm;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.features.PersonalAccessTokenFeature$;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.service.Users;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Path(value="/tokens")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001B\u0007\u000f\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002b\u0001!\t!a\"\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u0011\u0011\u0018\u0001\u0005\n\u0005m\u0006BB%\u0001\t\u0013\t\tMA\tVg\u0016\u0014Hk\\6f]J+7o\\;sG\u0016T!a\u0004\t\u0002\u0011%tG/\u001a:oC2T!!\u0005\n\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0014)\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003+Y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003]\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fMB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0006g24GG\u001b\u0006\u0002K\u0005AqM]5{u2,G-\u0003\u0002(E\t9Aj\\4hS:<\u0017a\u00039fe6L7o]5p]N\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\n\u0002\u0011M,7-\u001e:jifL!AL\u0016\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\u0007u_.,gnU3sm&\u001cW\r\u0005\u00022i5\t!G\u0003\u00024%\u000591/\u001a:wS\u000e,\u0017BA\u001b3\u0005A)6/\u001a:U_.,gnU3sm&\u001cW-A\u0003vg\u0016\u00148\u000f\u0005\u00022q%\u0011\u0011H\r\u0002\u0006+N,'o]\u0001\u0016aJLgnY5qC2$\u0015\r^1Qe>4\u0018\u000eZ3s!\tat(D\u0001>\u0015\tq$#A\u0007qe&t7-\u001b9bY\u0012\fG/Y\u0005\u0003\u0001v\u0012Q\u0003\u0015:j]\u000eL\u0007/\u00197ECR\f\u0007K]8wS\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0006\u0007\u00163u\t\u0013\t\u0003\t\u0002i\u0011A\u0004\u0005\u0006Q\u0015\u0001\r!\u000b\u0005\u0006_\u0015\u0001\r\u0001\r\u0005\u0006m\u0015\u0001\ra\u000e\u0005\u0006u\u0015\u0001\raO\u0001\u000eO\u0016$Xk]3s)>\\WM\\:\u0015\u0007-cF\u000fE\u0002M+^k\u0011!\u0014\u0006\u0003\u001d>\u000ba\u0001Z8nC&t'B\u0001)R\u0003\u0011!\u0017\r^1\u000b\u0005I\u001b\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003Q\u000b1a\u001c:h\u0013\t1VJ\u0001\u0003QC\u001e,\u0007C\u0001-[\u001b\u0005I&B\u0001(\u0013\u0013\tY\u0016LA\u0005Vg\u0016\u0014Hk\\6f]\")QL\u0002a\u0001=\u0006!\u0001/Y4f!\tYr,\u0003\u0002a9\t\u0019\u0011J\u001c;)\tq\u0013G.\u001c\t\u0003G*l\u0011\u0001\u001a\u0006\u0003K\u001a\f!A]:\u000b\u0005\u001dD\u0017AA<t\u0015\u0005I\u0017a\u00026bW\u0006\u0014H/Y\u0005\u0003W\u0012\u0014A\u0002R3gCVdGOV1mk\u0016\fQA^1mk\u0016\f\u0013A\\\u0001\u0002a!\"A\f\u001d7t!\t\u0019\u0017/\u0003\u0002sI\nQ\u0011+^3ssB\u000b'/Y7\"\u0003uCQ!\u001e\u0004A\u0002y\u000baB]3tk2$8\u000fU3s!\u0006<W\r\u000b\u0003uE2<\u0018%\u0001=\u0002\u0007E\u0002\u0004\u0007\u000b\u0003ua2T\u0018%A;)\u0005\u0019a\bCA2~\u0013\tqHMA\u0002H\u000bRCcABA\u0001Y\u0006\u001d\u0001cA2\u0002\u0004%\u0019\u0011Q\u00013\u0003\tA\u000bG\u000f[\u0011\u0003\u0003\u0013\taaL;tKJ\u001c\bf\u0001\u0004\u0002\u000eA!\u0011qBA\u0011\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011AC1o]>$\u0018\r^5p]*!\u0011qCA\r\u0003\u0011\u0019wN]3\u000b\t\u0005m\u0011QD\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(BAA\u0010\u0003\tIw.\u0003\u0003\u0002$\u0005E!!\u0002+j[\u0016$\u0017\u0001F4fiR{7.\u001a8t\r>\u0014Xk]3s]\u0006lW\rF\u0004L\u0003S\ti%a\u0015\t\u000f\u0005-r\u00011\u0001\u0002.\u0005AQo]3s]\u0006lW\r\u0005\u0003\u00020\u0005ub\u0002BA\u0019\u0003s\u00012!a\r\u001d\u001b\t\t)DC\u0002\u00028a\ta\u0001\u0010:p_Rt\u0014bAA\u001e9\u00051\u0001K]3eK\u001aLA!a\u0010\u0002B\t11\u000b\u001e:j]\u001eT1!a\u000f\u001dQ\u001d\tI#!\u0012m\u0003\u0017\u00022aYA$\u0013\r\tI\u0005\u001a\u0002\n!\u0006$\b\u000eU1sC6\f#!a\u000b\t\u000bu;\u0001\u0019\u00010)\u000b\u00055#\r\\7)\u000b\u00055\u0003\u000f\\:\t\u000bU<\u0001\u0019\u00010)\u000b\u0005M#\r\\<)\u000b\u0005M\u0003\u000f\u001c>)\u0005\u001da\bFB\u0004\u0002\u00021\fi&\t\u0002\u0002`\u0005\tr&^:feN|30^:fe:\fW.Z?\u0002#\u001d,g.\u001a:bi\u0016,6/\u001a:U_.,g\u000eF\u0003X\u0003K\nI\u0007C\u0004\u0002,!\u0001\r!!\f)\u000f\u0005\u0015\u0014Q\t7\u0002L!9\u00111\u000e\u0005A\u0002\u00055\u0014!D;tKJ$vn[3o\r>\u0014X\u000e\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u000b\u0019|'/\\:\u000b\u0007\u0005]\u0004#\u0001\u0002wc%!\u00111PA9\u0005u\u0019%/Z1uKB+'o]8oC2\f5mY3tgR{7.\u001a8G_Jl\u0007f\u0001\u0005\u0002\u0000A\u00191-!!\n\u0007\u0005\rEM\u0001\u0003Q\u001fN#\u0006F\u0002\u0005\u0002\u00021\fi\u0006F\u0002X\u0003\u0013Cq!a\u001b\n\u0001\u0004\ti\u0007K\u0002\n\u0003\u007fBc!CA\u0001Y\u0006\u001d\u0001fA\u0005\u0002\u000e\u0005yA-\u001a7fi\u0016,6/\u001a:U_.,g\u000e\u0006\u0003\u0002\u0016\u0006m\u0005cA\u000e\u0002\u0018&\u0019\u0011\u0011\u0014\u000f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003;S\u0001\u0019AAP\u0003\u0015\u0019\u0017.V5e!\rY\u0012\u0011U\u0005\u0004\u0003Gc\"\u0001\u0002'p]\u001eDs!a'\u0002F1\f9+\t\u0002\u0002\u001e\"\u001a!\"a+\u0011\u0007\r\fi+C\u0002\u00020\u0012\u0014a\u0001R#M\u000bR+\u0005F\u0002\u0006\u0002\u00021\f\u0019,\t\u0002\u00026\u0006qq&^:feN|3pY5VS\u0012l\bf\u0001\u0006\u0002\u000e\u0005\tc/\u00197jI\u0006$X-\u00118e\u001d>\u0014X.\u00197ju\u0016,6/\u001a:U_.,gNR8s[R1\u0011QSA_\u0003\u007fCq!a\u000b\f\u0001\u0004\ti\u0003C\u0004\u0002l-\u0001\r!!\u001c\u0015\u000f-\u000b\u0019-!2\u0002H\"9\u00111\u0006\u0007A\u0002\u00055\u0002\"B/\r\u0001\u0004q\u0006\"B;\r\u0001\u0004q\u0006F\u0002\u0001\u0002\u00021\fY-\t\u0002\u0002N\u00069q\u0006^8lK:\u001c\bF\u0002\u0001\u0002R2\f9\u000eE\u0002d\u0003'L1!!6e\u0005!\u0019uN\\:v[\u0016\u001cHFAAmC\t\tY.\u0001\tbaBd\u0017nY1uS>twF[:p]\"2\u0001!a8m\u0003K\u00042aYAq\u0013\r\t\u0019\u000f\u001a\u0002\t!J|G-^2fg2\u0012\u0011\u0011\u001c\u0015\u0004\u0001\u0005%\b\u0003BAv\u0003cl!!!<\u000b\u0007\u0005=\u0018+\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a=\u0002n\nQ1i\u001c8ue>dG.\u001a:")
public class UserTokenResource
implements Logging {
    private final PermissionChecker permissions;
    private final UserTokenService tokenService;
    private final Users users;
    private final PrincipalDataProvider principalDataProvider;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        UserTokenResource userTokenResource = this;
        synchronized (userTokenResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/users")
    @Timed
    public Page<UserToken> getUserTokens(@DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        return this.getUserTokens(User.AUTHENTICATED_USER.getName(), page, resultsPerPage);
    }

    @GET
    @Path(value="/users/{username}")
    public Page<UserToken> getTokensForUsername(@PathParam(value="username") String username, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.getUserTokens(username, page, resultsPerPage);
    }

    @POST
    @Path(value="/users/{username}")
    public UserToken generateUserToken(@PathParam(value="username") String username, CreatePersonalAccessTokenForm userTokenForm) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Checks.checkArgument((boolean)this.users.userExistsInRepository(username), (String)"Personal access tokens generated by administrator are only supported for internal users", (Object[])new Object[0]);
        this.validateAndNormalizeUserTokenForm(username, userTokenForm);
        return this.tokenService.createUserToken(username, userTokenForm.getTokenNote(), userTokenForm.getExpiryDate(), (Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(userTokenForm.getGlobalPermissions()).asScala().toSet());
    }

    @POST
    @Path(value="/users")
    @Timed
    public UserToken generateUserToken(CreatePersonalAccessTokenForm userTokenForm) {
        String username = User.AUTHENTICATED_USER.getName();
        UserData userData = this.principalDataProvider.getUserData(username);
        boolean personalAccessTokenSupported = PersonalAccessTokenFeature$.MODULE$.enabled() || this.users.userExistsInRepository(username) || userData.isFound();
        Checks.checkArgument((boolean)personalAccessTokenSupported, (String)"Personal access tokens are only supported for internal users and external users authenticated via LDAP", (Object[])new Object[0]);
        this.validateAndNormalizeUserTokenForm(username, userTokenForm);
        return this.tokenService.createUserToken(username, userTokenForm.getTokenNote(), userTokenForm.getExpiryDate(), (Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(userTokenForm.getGlobalPermissions()).asScala().toSet());
    }

    @DELETE
    @Path(value="/users/{ciUid}")
    @Timed
    public void deleteUserToken(@PathParam(value="ciUid") long ciUid) {
        Option<UserToken> userToken = this.tokenService.findByCiUid(ciUid);
        Option<UserToken> option = userToken;
        if (option instanceof Some) {
            Some some = (Some)option;
            UserToken token = (UserToken)some.value();
            if (token.username().equalsIgnoreCase(User.AUTHENTICATED_USER.getName()) || this.permissions.isCurrentUserAdmin()) {
                this.tokenService.deleteUserToken(token);
                return;
            }
            throw new PermissionDeniedException("You don't have the permissions required to delete this personal access token.");
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Personal access token ciUid[" + ciUid + "] is not valid");
        }
        throw new MatchError(option);
    }

    private void validateAndNormalizeUserTokenForm(String username, CreatePersonalAccessTokenForm userTokenForm) {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)userTokenForm.getTokenNote()), (String)"Note can't be blank", (Object[])new Object[0]);
        Checks.checkArgument((userTokenForm.getExpiryDate() == null || userTokenForm.getExpiryDate().getTime() > System.currentTimeMillis() ? 1 : 0) != 0, (String)"Expiry date is not valid", (Object[])new Object[0]);
        String tokenNote = userTokenForm.getTokenNote().trim();
        userTokenForm.setTokenNote(tokenNote);
        Checks.checkArgument((tokenNote.length() < 256 ? 1 : 0) != 0, (String)"Note must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!this.tokenService.userTokenExists(username, tokenNote) ? 1 : 0) != 0, (String)"Note has already been taken", (Object[])new Object[0]);
    }

    private Page<UserToken> getUserTokens(String username, int page, int resultsPerPage) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage);
        return this.tokenService.find(username, (Pageable)pageable);
    }

    public UserTokenResource(PermissionChecker permissions, UserTokenService tokenService, Users users, PrincipalDataProvider principalDataProvider) {
        this.permissions = permissions;
        this.tokenService = tokenService;
        this.users = users;
        this.principalDataProvider = principalDataProvider;
        Logging.$init$((Logging)this);
    }
}

