package com.xebialabs.xlrelease.service

import com.xebialabs.xlrelease.actors.UserLastActiveActor.{UpdateLastActive, UpdateTokenLastUsed}
import com.xebialabs.xlrelease.actors.initializer.UserLastActiveInitializer.UserLastActiveManagedActor
import com.xebialabs.xlrelease.domain.id.CiUid
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

@Component
class UserLastActiveActorService(userLastActiveManagedActor: UserLastActiveManagedActor) extends NoopXlrServiceLifecycle with Logging {

  override def getOrder: Int = XlrServiceLifecycleOrder.USER_LAST_ACTIVE_SERVICE

  def updateLastActive(userId: String): Unit = {
    if (isRunning) {
      userLastActiveManagedActor ! UpdateLastActive(userId)
    } else {
      logger.debug(s"${serviceName()} is not running, skipping updateLastActive for user $userId")
    }
  }

  def updateTokenLastUsed(tokenId: CiUid): Unit = {
    if (isRunning) {
      userLastActiveManagedActor ! UpdateTokenLastUsed(tokenId)
    } else {
      logger.debug(s"${serviceName()} is not running, skipping updateTokenLastUsed for token $tokenId")
    }
  }
}
