package com.xebialabs.xlrelease.service

import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData
import com.xebialabs.xlplatform.coc.service.{SCMTraceabilityService => PlatformSCMTraceabilityService}
import com.xebialabs.xlrelease.domain.id.CiUid
import com.xebialabs.xlrelease.repository.SCMTraceabilityRepository
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
@Autowired
class SCMTraceabilityService(
                              repository: SCMTraceabilityRepository
                            ) extends PlatformSCMTraceabilityService with Logging {
  override def getById(id: CiUid): Option[SCMTraceabilityData] = {
    repository.findById(id)
  }

  override def insert(scmTraceabilityData: SCMTraceabilityData): Option[CiUid] = {
    Option(repository.createSCMEntity(scmTraceabilityData))
  }

  override def update(traceabilityId: CiUid, scmData: SCMTraceabilityData): Option[CiUid] = {
    repository.updateSCMEntity(traceabilityId, scmData)
    Option(traceabilityId)
  }

  override def delete(id: CiUid): Option[CiUid] = {
    repository.deleteData(id)
    None
  }
}

