package com.xebialabs.xlrelease.repository.pekko

import com.xebialabs.xlplatform.spring.SpringContextHolder
import com.xebialabs.xlrelease.repository.PekkoJournalRepository
import org.apache.pekko.persistence.jdbc.config.JournalConfig
import org.apache.pekko.persistence.jdbc.journal.dao.legacy.{ByteArrayJournalDao, JournalRow}
import org.apache.pekko.serialization.Serialization
import org.apache.pekko.stream.Materializer
import slick.jdbc.JdbcBackend.Database
import slick.jdbc.JdbcProfile

import scala.concurrent.{ExecutionContext, Future}

class XlrByteArrayJournalDao(override val db: Database,
                             override val profile: JdbcProfile,
                             override val journalConfig: JournalConfig,
                             serialization: Serialization)(implicit override val ec: ExecutionContext, override val mat: Materializer)
  extends ByteArrayJournalDao(db, profile, journalConfig, serialization) {

  private lazy val pekkoJournalRowRepository = SpringContextHolder.getApplicationContext.getBean(classOf[PekkoJournalRepository])

  override def writeJournalRows(xs: Seq[JournalRow]): Future[Unit] = {
    Future {
      pekkoJournalRowRepository.batchInsert(xs, journalConfig.journalTableConfiguration.tableName)
    }
  }
}
