package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.id.CiUid
import com.xebialabs.xlrelease.domain.variables.Variable

import java.util.{List => JList}

trait FolderVariableRepository {

  def exists(variableId: String): Boolean

  def findById(variableId: String): Variable

  def findByKey(variableKey: String, variableHolderId: String): Variable

  def create(variable: Variable): Variable

  def create(variable: Variable, folderCiUid: CiUid): Variable

  def update(variable: Variable): Variable

  def update(variable: Variable, folderCiUid: CiUid): Variable

  def delete(variableId: String): Unit

  def getAllFromParent(variableParentId: String): JList[Variable]

  def getAllFromAncestry(variableParentId: String): JList[Variable]
}
