package com.xebialabs.xlrelease.repository

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext
import com.xebialabs.xlrelease.configuration.ThemeSettings
import com.xebialabs.xlrelease.configuration.ThemeSettings.THEME_SETTINGS_ID
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.domain.id.CiUid
import com.xebialabs.xlrelease.domain.status.ReleaseStatus
import com.xebialabs.xlrelease.repository.query.ReleaseBasicData
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository

import java.util.{Optional, List => JList}

trait ConfigurationRepository extends InterceptedRepository[BaseConfiguration] {
  def read[T <: BaseConfiguration](configurationId: String): T

  def find[T <: BaseConfiguration](configurationId: String): Option[T]

  def create[T <: BaseConfiguration](configuration: T): T

  def create[T <: BaseConfiguration](configuration: T, folderCiUid: CiUid): T

  def update[T <: BaseConfiguration](updated: T): T

  def update[T <: BaseConfiguration](updated: T, folderCiUid: CiUid): T

  def getThemeSettings(): ThemeSettings = {
    if (exists(THEME_SETTINGS_ID)) {
      read(THEME_SETTINGS_ID)
    } else {
      new ThemeSettings
    }
  }


  def delete(configurationId: String): Unit

  def findAllByType[T <: BaseConfiguration](ciType: Type): JList[T]

  def findByIds[T <: BaseConfiguration](configurationIds: JList[String]): JList[T]

  def findConfigurationTitleById(configId: String): String

  def existsByTypeAndTitle[T <: BaseConfiguration](ciType: Type, title: String): Boolean

  def findAllByTypeAndTitle[T <: BaseConfiguration](ciType: Type, title: String): JList[T]

  def findAllByTypeAndTitle[T <: BaseConfiguration](ciType: Type, title: String, folderId: String, folderOnly: Boolean): JList[T]

  def findFirstByType[T <: BaseConfiguration](ciType: Type): Optional[T]

  def findFirstByType[T <: BaseConfiguration](ciType: Type, folderId: ResolutionContext): Optional[T]

  def getReleaseConfigurations[T <: BaseConfiguration](releaseUid: CiUid): Seq[T]

  def exists(configurationId: String): Boolean

  def getReferenceReleases(configurationId: String): JList[ReleaseBasicData]

  def getAllTypes: Seq[String]

  def deleteByTypes(ciTypes: Seq[String]): Unit

  def findAllNonInheritedReleaseReferences(folderId: String, releaseStatus: Seq[ReleaseStatus]): Seq[String]

  def findAllNonInheritedTriggerReferences(folderId: String): Seq[String]
}
