package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.api.v1.filter.CategoryFilters
import com.xebialabs.xlrelease.api.v1.views.CategoryView
import com.xebialabs.xlrelease.domain.Category
import com.xebialabs.xlrelease.domain.id.CiUid
import org.springframework.data.domain.{Page, Pageable}


trait CategoryRepository {
  def create(category: Category): Category

  def update(category: Category): Category

  def delete(id: CiUid): Unit

  def findByCiUid(id: CiUid): Option[Category]

  def findByTitle(title: String): Option[Category]

  def findByTitles(titles: Seq[String]): Seq[Category]

  def findBy(categoryFilters: CategoryFilters, pageable: Pageable): Page[CategoryView]

  def findTitlesByReleaseCiUid(releaseUid: CiUid): Set[String]
}
