package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.id.CiUid
import com.xebialabs.xlrelease.domain.{Attachment, Release, Task}

import java.io.InputStream


trait AttachmentRepository {

  def findById(attachmentId: String): Attachment

  def create(release: Release, attachment: Attachment): Attachment

  def create(release: Release, taskId: String, attachment: Attachment): Attachment

  def insertAttachment(releaseId: String, attachment: Attachment): Boolean

  def delete(release: Release, attachment: Attachment): Unit

  def delete(task: Task, attachment: Attachment): Unit

  def batchInsert(release: Release, attachments: Seq[Attachment]): Boolean

  def insert(releaseUid: CiUid, artifactId: String, artifactName: String, content: InputStream): Boolean
}
