package com.xebialabs.xlrelease.api.v1.impl

import com.xebialabs.deployit.checks.Checks.checkArgument
import com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN
import com.xebialabs.xlrelease.api.ApiService.DEFAULT_RESULTS_PER_PAGE
import com.xebialabs.xlrelease.api.v1.CategoryApi
import com.xebialabs.xlrelease.api.v1.filter.CategoryFilters
import com.xebialabs.xlrelease.api.v1.forms.CategoryForm
import com.xebialabs.xlrelease.api.v1.views.CategoryView
import com.xebialabs.xlrelease.domain.Category
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.service.CategoryService
import io.micrometer.core.annotation.Timed
import org.springframework.data.domain.{Page, PageRequest}
import org.springframework.stereotype.Controller

@Controller
class CategoryApiImpl(categoryService: CategoryService, permissions: PermissionChecker) extends CategoryApi {

  @Timed
  override def searchCategoriesPage(categoryFilters: CategoryFilters, page: Int, resultsPerPage: Int): Page[CategoryView] = {
    checkArgument(resultsPerPage <= DEFAULT_RESULTS_PER_PAGE, "Number of results per page cannot be more than %d", DEFAULT_RESULTS_PER_PAGE)
    val pageable = PageRequest.of(page, resultsPerPage)
    categoryService.findBy(categoryFilters, pageable)
  }

  @Timed
  override def addCategory(categoryForm: CategoryForm): Category = {
    val category = new Category(categoryForm.getTitle, categoryForm.isActive)
    addCategory(category)
  }

  @Timed
  override def addCategory(category: Category): Category = {
    permissions.check(ADMIN)
    categoryService.create(category)
  }

  @Timed
  override def updateCategory(ciUid: java.lang.Long, category: Category): Category = {
    permissions.check(ADMIN)
    category.setCiUid(ciUid)
    categoryService.update(category)
  }

  @Timed
  override def deleteCategory(ciUid: java.lang.Long): Unit = {
    permissions.check(ADMIN)
    categoryService.delete(ciUid)
  }
}
