package com.xebialabs.xlrelease.support.report

import com.xebialabs.xlplatform.support.report.ReportDataProvider
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.actors.cluster.ClusterStatisticsProvider
import com.xebialabs.xlrelease.config.XlrConfig
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

import java.util
import scala.beans.BeanProperty

@Component
class ClusterDataProvider(val xlrConfig: XlrConfig,
                          val actorSystemHolder: ActorSystemHolder,
                          val clusterInformation: ClusterStatisticsProvider)
  extends Logging with ReportDataProvider {

  val name: String = "cluster"

  override def collectStatistics: Map[String, Any] = {
    val statistics = clusterInformation.getClusterStatistics

    Map[String, Any]("cluster" -> statistics)
  }
}

class ClusterUsageStatistics {
  @BeanProperty
  var clusterMode: String = _

  @BeanProperty
  var clustered: Boolean = false

  @BeanProperty
  var clusterNumberOfNodes: Int = 0

  @BeanProperty
  var clusterActorSystem: String = _

  @BeanProperty
  var clusterLeader: String = _

  @BeanProperty
  var clusterDbNodes: util.List[String] = new util.ArrayList[String]()

  @BeanProperty
  var clusterPekkoNodes: util.List[String] = new util.ArrayList[String]()
}
