package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.actors.cluster.ClusterMember

import java.time.Instant

trait ClusterMembersRepository {
  def create(member: ClusterMember, ttl: Instant): Unit

  def updateTtl(member: ClusterMember, ttl: Instant): Unit

  def delete(member: ClusterMember): Unit

  def listActiveMembers(ttl: Instant): Seq[ClusterMember]

  def exits(member: ClusterMember): Boolean

  def deleteExpiredMembers(expiresAt: Instant): Unit
}
