package com.xebialabs.xlrelease.utils

import com.typesafe.config.ConfigFactory.parseResources
import com.typesafe.config.{Config, ConfigFactory, ConfigParseOptions, ConfigRenderOptions, ConfigResolveOptions, ConfigValueFactory}

import java.io.File
import java.nio.file.Files
import scala.util.Try
import scala.jdk.CollectionConverters._

object ConfigUtils {

  def writeToFile(file: File, config: Config) = {
    val renderOptions = ConfigRenderOptions.defaults.setFormatted(true).setJson(false).setOriginComments(false).setComments(true)
    Try(Files.write(file.toPath, Seq(config.resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true)).root().render(renderOptions)).asJava))
  }

  def updateConfig(configName: String, entries: Seq[ConfigEntry]) = {
    val baseConfig = parseResources(configName, ConfigParseOptions.defaults().setAllowMissing(true))
    val updatedConfig = entries.foldLeft(ConfigFactory.empty()) { (config, entry) =>
      config.withValue(entry.path, ConfigValueFactory.fromAnyRef(entry.value))
    }

    updatedConfig.root().withFallback(baseConfig).toConfig
  }

}

case class ConfigEntry(path: String, value: String)
