/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Datacenter;
import com.xebialabs.xlrelease.domain.DatacenterTargetState;
import com.xebialabs.xlrelease.domain.events.DatacenterCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DatacenterDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DatacenterUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.RateLimitReachedException;
import com.xebialabs.xlrelease.repository.DatacenterRepository;
import com.xebialabs.xlrelease.service.XlrServiceManager;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001\u0002\f\u0018\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\"B1\u0001\t\u0003\u0011\u0007\"\u00036\u0001\u0001\u0004\u0005\r\u0011\"\u0003l\u0011-\t9\u0001\u0001a\u0001\u0002\u0004%I!!\u0003\t\u0013m\u0004\u0001\u0019!A!B\u0013a\u0007\"CA\u000f\u0001\t\u0007I\u0011BA\u0010\u0011!\tI\u0004\u0001Q\u0001\n\u0005\u0005\u0002bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\t\t\u0007\u0001C\u0001\u0003GBq!! \u0001\t\u0003\ty\bC\u0004\u0002\u0004\u0002!\t!!\u0010\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002>!9\u0011q\u0011\u0001\u0005\u0002\u0005u\u0002bBAE\u0001\u0011%\u00111\u0012\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\t\t\u000b\u0001C\u0005\u0003G\u0013\u0011\u0003R1uC\u000e,g\u000e^3s'\u0016\u0014h/[2f\u0015\tA\u0012$A\u0004tKJ4\u0018nY3\u000b\u0005iY\u0012!\u0003=me\u0016dW-Y:f\u0015\taR$A\u0005yK\nL\u0017\r\\1cg*\ta$A\u0002d_6\u001c\u0001aE\u0002\u0001C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005a\u0013\u0001C4sSjTH.\u001a3\n\u00059J#a\u0002'pO\u001eLgnZ\u0001\u0015I\u0006$\u0018mY3oi\u0016\u0014(+\u001a9pg&$xN]=\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005MJ\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011QG\r\u0002\u0015\t\u0006$\u0018mY3oi\u0016\u0014(+\u001a9pg&$xN]=\u0002\u0013ad'oQ8oM&<\u0007C\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u001a\u0003\u0019\u0019wN\u001c4jO&\u0011A(\u000f\u0002\n12\u00148i\u001c8gS\u001e\fQ\u0002^1tWN\u001b\u0007.\u001a3vY\u0016\u0014\bCA G\u001b\u0005\u0001%BA!C\u0003)\u00198\r[3ek2Lgn\u001a\u0006\u0003\u0007\u0012\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u000b\u0006\u0019qN]4\n\u0005\u001d\u0003%!\u0004+bg.\u001c6\r[3ek2,'\u000f\u000b\u0003\u0004\u0013N#\u0006C\u0001&R\u001b\u0005Y%B\u0001'N\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u001d>\u000bqAZ1di>\u0014\u0018P\u0003\u0002Q\u0005\u0006)!-Z1og&\u0011!k\u0013\u0002\n#V\fG.\u001b4jKJ\fQA^1mk\u0016\f\u0013!P\u0001\u0012q2\u00148+\u001a:wS\u000e,W*\u00198bO\u0016\u0014\bCA,Y\u001b\u00059\u0012BA-\u0018\u0005EAFN]*feZL7-Z'b]\u0006<WM]\u0001\tKZ,g\u000e\u001e\"vgB\u0011AlX\u0007\u0002;*\u0011a,G\u0001\u0007KZ,g\u000e^:\n\u0005\u0001l&!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u00061A(\u001b8jiz\"ba\u00193fM\"L\u0007CA,\u0001\u0011\u0015yc\u00011\u00011\u0011\u00151d\u00011\u00018\u0011\u0015id\u00011\u0001?Q\u00111\u0017j\u0015+\t\u000bU3\u0001\u0019\u0001,\t\u000bi3\u0001\u0019A.\u0002!M$\u0018\r^3DQ\u0016\u001c7NR;ukJ,W#\u000171\u00055L\bc\u00018vo6\tqN\u0003\u0002qc\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005I\u001c\u0018\u0001B;uS2T\u0011\u0001^\u0001\u0005U\u00064\u0018-\u0003\u0002w_\ny1k\u00195fIVdW\r\u001a$viV\u0014X\r\u0005\u0002ys2\u0001A!\u0003>\n\u0003\u0003\u0005\tQ!\u0001}\u0005\ryF%M\u0001\u0012gR\fG/Z\"iK\u000e\\g)\u001e;ve\u0016\u0004\u0013cA?\u0002\u0002A\u0011!E`\u0005\u0003\u007f\u000e\u0012qAT8uQ&tw\rE\u0002#\u0003\u0007I1!!\u0002$\u0005\r\te._\u0001\u0015gR\fG/Z\"iK\u000e\\g)\u001e;ve\u0016|F%Z9\u0015\t\u0005-\u0011\u0011\u0003\t\u0004E\u00055\u0011bAA\bG\t!QK\\5u\u0011%\t\u0019\u0002CA\u0001\u0002\u0004\t)\"A\u0002yIE\u0002D!a\u0006\u0002\u001cA!a.^A\r!\rA\u00181\u0004\u0003\u000bu\u0006E\u0011\u0011!A\u0001\u0006\u0003a\u0018AE2veJ,g\u000e\u001e+be\u001e,Go\u0015;bi\u0016,\"!!\t\u0011\r\u0005\r\u0012\u0011FA\u0017\u001b\t\t)CC\u0002\u0002(=\fa!\u0019;p[&\u001c\u0017\u0002BA\u0016\u0003K\u0011q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111G\r\u0002\r\u0011|W.Y5o\u0013\u0011\t9$!\r\u0003+\u0011\u000bG/Y2f]R,'\u000fV1sO\u0016$8\u000b^1uK\u0006\u00192-\u001e:sK:$H+\u0019:hKR\u001cF/\u0019;fA\u0005ib/\u00197jI\u0006$X\rR1uC\u000e,g\u000e^3s'R\fG/Z\"iC:<W\r\u0006\u0002\u0002\f\u0005qq-\u001a;ECR\f7-\u001a8uKJ\u001cHCAA\"!\u0019\t)%!\u0016\u0002\\9!\u0011qIA)\u001d\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'?\u00051AH]8pizJ\u0011\u0001J\u0005\u0004\u0003'\u001a\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003/\nIFA\u0002TKFT1!a\u0015$!\u0011\ty#!\u0018\n\t\u0005}\u0013\u0011\u0007\u0002\u000b\t\u0006$\u0018mY3oi\u0016\u0014\u0018AE:fi\u0012\u000bG/Y2f]R,'o\u0015;bi\u0016$b!a\u0003\u0002f\u0005e\u0004bBA4\u001d\u0001\u0007\u0011\u0011N\u0001\u000bI\u0006$\u0018mY3oi\u0016\u0014\b\u0003BA6\u0003grA!!\u001c\u0002pA\u0019\u0011\u0011J\u0012\n\u0007\u0005E4%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\n9H\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003c\u001a\u0003bBA>\u001d\u0001\u0007\u0011QF\u0001\u0006gR\fG/Z\u0001\u0011I\u0016dW\r^3ECR\f7-\u001a8uKJ$B!a\u0003\u0002\u0002\"9\u0011qM\bA\u0002\u0005%\u0014A\u0005:fO&\u001cH/\u001a:ECR\f7-\u001a8uKJ\fA$\\8oSR|'\u000fR1uC\u000e,g\u000e^3s)\u0006\u0014x-\u001a;Ti\u0006$X-\u0001\tdC:\u001cW\r\\*uCR,7\t[3dW\u0006\u00112o\u00195fIVdWm\u0015;bi\u0016\u001c\u0005.Z2l)\u0019\tY!!$\u0002\u0010\"9\u0011qM\nA\u0002\u0005%\u0004bBAI'\u0001\u0007\u0011QF\u0001\u000f_2$G+\u0019:hKR\u001cF/\u0019;f\u0003EA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-\u001a\u000b\t\u0003[\t9*!'\u0002\u001e\"9\u0011q\r\u000bA\u0002\u0005%\u0004bBAN)\u0001\u0007\u0011QF\u0001\t]\u0016<8\u000b^1uK\"9\u0011q\u0014\u000bA\u0002\u0005\r\u0013!E1di&4X\rR1uC\u000e,g\u000e^3sg\u0006\tr-\u001a;TK24G)\u0019;bG\u0016tG/\u001a:\u0016\u0005\u0005%\u0004f\u0001\u0001\u0002(B!\u0011\u0011VAX\u001b\t\tYKC\u0002\u0002.\n\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t\t,a+\u0003\u000fM+'O^5dK\u0002")
public class DatacenterService
implements Logging {
    private final DatacenterRepository datacenterRepository;
    private final XlrConfig xlrConfig;
    @Qualifier(value="taskScheduler")
    private final TaskScheduler taskScheduler;
    private final XlrServiceManager xlrServiceManager;
    private final XLReleaseEventBus eventBus;
    private ScheduledFuture<?> stateCheckFuture;
    private final AtomicReference<DatacenterTargetState> currentTargetState;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DatacenterService datacenterService = this;
        synchronized (datacenterService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private ScheduledFuture<?> stateCheckFuture() {
        return this.stateCheckFuture;
    }

    private void stateCheckFuture_$eq(ScheduledFuture<?> x$1) {
        this.stateCheckFuture = x$1;
    }

    private AtomicReference<DatacenterTargetState> currentTargetState() {
        return this.currentTargetState;
    }

    public void validateDatacenterStateChange() {
        if (this.xlrConfig.features().datacenter().stateChangeCoolDown().enabled()) {
            Seq<Datacenter> allDatacenters = this.datacenterRepository.findAll();
            Seq nonSystemUpdatedDatacenters = (Seq)((SeqOps)((SeqOps)allDatacenters.filter((Function1 & Serializable)dc -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$validateDatacenterStateChange$1(dc)))).sortBy((Function1 & Serializable)x$2 -> x$2.getUpdatedDate(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).reverse();
            nonSystemUpdatedDatacenters.headOption().foreach((Function1 & Serializable)dc -> {
                DatacenterService.$anonfun$validateDatacenterStateChange$3(this, dc);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.logger().trace((Function0 & Serializable)() -> "Datacenter state change cooldown is disabled");
    }

    public Seq<Datacenter> getDatacenters() {
        return this.datacenterRepository.findAll();
    }

    public void setDatacenterState(String datacenter, DatacenterTargetState state) {
        Predef$.MODULE$.require(StringUtils.hasText((String)datacenter), (Function0 & Serializable)() -> "Datacenter name cannot be empty");
        Seq<Datacenter> allDatacenters = this.datacenterRepository.findAll();
        Seq activeDatacenters = (Seq)allDatacenters.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$setDatacenterState$2(x$3)));
        Option existingDatacenter = allDatacenters.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$setDatacenterState$3(datacenter, x$4)));
        boolean bl = false;
        Some some = null;
        Option option = existingDatacenter;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Datacenter dc = (Datacenter)some.value();
            DatacenterTargetState datacenterTargetState = dc.getTargetState();
            DatacenterTargetState datacenterTargetState2 = state;
            if (!(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState2) : datacenterTargetState2 != null)) {
                this.logger().info((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' is already in the requested state '" + state + "'.");
                return;
            }
        }
        if (activeDatacenters.nonEmpty()) {
            DatacenterTargetState datacenterTargetState = state;
            DatacenterTargetState datacenterTargetState3 = DatacenterTargetState.ACTIVE;
            if (!(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState3) : datacenterTargetState3 != null)) {
                throw new IllegalStateException("An active datacenter already exists. Cannot set another to ACTIVE.");
            }
        }
        if (bl) {
            Datacenter dc = (Datacenter)some.value();
            this.datacenterRepository.update(datacenter, state, User.AUTHENTICATED_USER.getName().toLowerCase());
            this.eventBus.publish((XLReleaseEvent)new DatacenterUpdatedEvent(datacenter, dc.getTargetState(), state));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Datacenter '" + datacenter + "' does not exist");
        }
        throw new MatchError((Object)option);
    }

    public void deleteDatacenter(String datacenter) {
        Predef$.MODULE$.require(StringUtils.hasText((String)datacenter), (Function0 & Serializable)() -> "Datacenter name cannot be empty");
        this.datacenterRepository.delete(datacenter);
        this.eventBus.publish((XLReleaseEvent)new DatacenterDeletedEvent(datacenter));
    }

    public void registerDatacenter() {
        String datacenter = this.getSelfDatacenter();
        Option<Datacenter> option = this.datacenterRepository.find(datacenter);
        if (option instanceof Some) {
            this.logger().trace((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' already registered");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            this.logger().info((Function0 & Serializable)() -> "Registering datacenter '" + datacenter + "'");
            DatacenterTargetState state = this.datacenterRepository.count() > 0L ? DatacenterTargetState.WARM_STANDBY : DatacenterTargetState.ACTIVE;
            try {
                this.datacenterRepository.create(datacenter, state, User.SYSTEM.getName());
                this.eventBus.publish((XLReleaseEvent)new DatacenterCreatedEvent(datacenter, state));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> "Failed to register datacenter '" + datacenter + "'", (Function0 & Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void monitorDatacenterTargetState() {
        String datacenter = this.getSelfDatacenter();
        Seq<Datacenter> allDatacenters = this.datacenterRepository.findAll();
        Seq activeDatacenters = (Seq)allDatacenters.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$monitorDatacenterTargetState$1(x$5)));
        DatacenterTargetState requestedTargetState = (DatacenterTargetState)allDatacenters.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$monitorDatacenterTargetState$2(datacenter, x$6))).map((Function1 & Serializable)x$7 -> x$7.getTargetState()).getOrElse((Function0 & Serializable)() -> DatacenterTargetState.WARM_STANDBY);
        DatacenterTargetState actualTargetState = this.handleStateChange(datacenter, requestedTargetState, (Seq<Datacenter>)activeDatacenters);
        if (this.xlrConfig.features().datacenter().stateCheck().enabled()) {
            this.scheduleStateCheck(datacenter, actualTargetState);
            return;
        }
    }

    public void cancelStateCheck() {
        if (this.stateCheckFuture() != null && !this.stateCheckFuture().isCancelled()) {
            this.stateCheckFuture().cancel(true);
            this.logger().trace((Function0 & Serializable)() -> "Cancelled the scheduled datacenter target state check");
            return;
        }
    }

    private void scheduleStateCheck(String datacenter, DatacenterTargetState oldTargetState) {
        this.logger().info((Function0 & Serializable)() -> "Scheduling datacenter target state check for '" + datacenter + "'");
        long checkInterval = this.xlrConfig.features().datacenter().stateCheck().interval().toMillis();
        this.currentTargetState().set(oldTargetState);
        this.stateCheckFuture_$eq(this.taskScheduler.scheduleAtFixedRate(() -> {
            Seq<Datacenter> allDatacenters = $this.datacenterRepository.findAll();
            Seq activeDatacenters = (Seq)allDatacenters.filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$scheduleStateCheck$3(x$8)));
            Option thisDatacenter = allDatacenters.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$scheduleStateCheck$4(datacenter, x$9)));
            Option option = thisDatacenter;
            if (None$.MODULE$.equals(option)) {
                this.logger().warn((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' is not registered. Registering now.");
                this.registerDatacenter();
                return;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Datacenter dc = (Datacenter)some.value();
                DatacenterTargetState datacenterTargetState = dc.getTargetState();
                DatacenterTargetState datacenterTargetState2 = this.currentTargetState().get();
                if (datacenterTargetState == null ? datacenterTargetState2 != null : !datacenterTargetState.equals(datacenterTargetState2)) {
                    this.currentTargetState().set(this.handleStateChange(datacenter, dc.getTargetState(), (Seq<Datacenter>)activeDatacenters));
                    return;
                }
                this.logger().trace((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' target state is still '" + this.currentTargetState() + "'");
                return;
            }
            throw new MatchError((Object)option);
        }, Duration.ofMillis(checkInterval)));
    }

    private DatacenterTargetState handleStateChange(String datacenter, DatacenterTargetState newState, Seq<Datacenter> activeDatacenters) {
        this.logger().info((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' target state changed to '" + newState + "'");
        boolean bl = false;
        DatacenterTargetState datacenterTargetState = null;
        DatacenterTargetState datacenterTargetState2 = newState;
        if (DatacenterTargetState.ACTIVE.equals(datacenterTargetState2)) {
            bl = true;
            datacenterTargetState = datacenterTargetState2;
            if (activeDatacenters.size() > 1) {
                this.logger().error((Function0 & Serializable)() -> "Multiple datacenters are in ACTIVE state. Services will not start.");
                return DatacenterTargetState.WARM_STANDBY;
            }
        }
        if (bl) {
            this.logger().info((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' is now ACTIVE. Starting services.");
            this.xlrServiceManager.startAsync();
            return DatacenterTargetState.ACTIVE;
        }
        if (DatacenterTargetState.WARM_STANDBY.equals(datacenterTargetState2)) {
            this.logger().warn((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' is no longer ACTIVE. Stopping services.");
            this.xlrServiceManager.stopAsync();
            return DatacenterTargetState.WARM_STANDBY;
        }
        throw new MatchError((Object)datacenterTargetState2);
    }

    private String getSelfDatacenter() {
        return (String)Option$.MODULE$.apply((Object)this.xlrConfig.clusterNode().datacenter()).filter((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$getSelfDatacenter$1(str))).map((Function1 & Serializable)x$10 -> x$10.toLowerCase().trim()).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Datacenter is not set in the configuration. Set value for 'xl.cluster.node.datacenter' configuration property.");
        });
    }

    public static final /* synthetic */ boolean $anonfun$validateDatacenterStateChange$1(Datacenter dc) {
        return StringUtils.hasText((String)dc.getUpdatedBy());
    }

    public static final /* synthetic */ void $anonfun$validateDatacenterStateChange$3(DatacenterService $this, Datacenter dc) {
        Duration coolDownPeriod;
        Duration elapsed = Duration.between(dc.getUpdatedDate(), Instant.now());
        if (elapsed.compareTo(coolDownPeriod = Duration.ofSeconds($this.xlrConfig.features().datacenter().stateChangeCoolDown().interval().toSeconds())) < 0) {
            Duration remaining = coolDownPeriod.minus(elapsed);
            throw new RateLimitReachedException("Wait for " + remaining.toSeconds() + " seconds before attempting another state change");
        }
    }

    public static final /* synthetic */ boolean $anonfun$setDatacenterState$2(Datacenter x$3) {
        DatacenterTargetState datacenterTargetState = x$3.getTargetState();
        DatacenterTargetState datacenterTargetState2 = DatacenterTargetState.ACTIVE;
        return !(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState2) : datacenterTargetState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$setDatacenterState$3(String datacenter$1, Datacenter x$4) {
        String string = x$4.getTitle();
        String string2 = datacenter$1.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$monitorDatacenterTargetState$1(Datacenter x$5) {
        DatacenterTargetState datacenterTargetState = x$5.getTargetState();
        DatacenterTargetState datacenterTargetState2 = DatacenterTargetState.ACTIVE;
        return !(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState2) : datacenterTargetState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$monitorDatacenterTargetState$2(String datacenter$3, Datacenter x$6) {
        String string = x$6.getTitle();
        String string2 = datacenter$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$scheduleStateCheck$3(Datacenter x$8) {
        DatacenterTargetState datacenterTargetState = x$8.getTargetState();
        DatacenterTargetState datacenterTargetState2 = DatacenterTargetState.ACTIVE;
        return !(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState2) : datacenterTargetState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$scheduleStateCheck$4(String datacenter$4, Datacenter x$9) {
        String string = x$9.getTitle();
        String string2 = datacenter$4;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSelfDatacenter$1(String str) {
        return StringUtils.hasText((String)str);
    }

    public DatacenterService(DatacenterRepository datacenterRepository, XlrConfig xlrConfig, @Qualifier(value="taskScheduler") TaskScheduler taskScheduler, XlrServiceManager xlrServiceManager, XLReleaseEventBus eventBus) {
        this.datacenterRepository = datacenterRepository;
        this.xlrConfig = xlrConfig;
        this.taskScheduler = taskScheduler;
        this.xlrServiceManager = xlrServiceManager;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        this.currentTargetState = new AtomicReference();
    }
}

