/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.events.handlers;

import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.CreatedFromCreateReleaseTask;
import com.xebialabs.xlrelease.domain.events.ReleaseAbortedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCompletedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutionEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseFailedEvent;
import com.xebialabs.xlrelease.domain.events.ReleasePausedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseResumedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseRetriedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseStartedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseStartedFailingEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.IdType;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001B\u0006\r\u0001]A\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\t]\u0001\u0011\t\u0011)A\u0005Q!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0003=\u0001\u0011\u0005Q\bC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003W\u0001\u0011%q\u000bC\u0003]\u0001\u0011%Q\fC\u0004r\u0001E\u0005I\u0011\u0002:\t\u000bu\u0004A\u0011\u0002@\u00031\r\u0013X-\u0019;f%\u0016dW-Y:f)\u0006\u001c8\u000eS1oI2,'O\u0003\u0002\u000e\u001d\u0005A\u0001.\u00198eY\u0016\u00148O\u0003\u0002\u0010!\u00051QM^3oiNT!!\u0005\n\u0002\u0013ad'/\u001a7fCN,'BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013!B:mMRR'\"A\u0012\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\n\u0011\u0003\u000f1{wmZ5oO\u0006\u0019\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dKV\t\u0001\u0006\u0005\u0002*Y5\t!F\u0003\u0002,!\u00051\u0011m\u0019;peNL!!\f\u0016\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002)I,G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3!\u00039!\u0018m]6SKB|7/\u001b;pef\u0004\"!\r\u001b\u000e\u0003IR!a\r\t\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00026e\tqA+Y:l%\u0016\u0004xn]5u_JL\u0018A\u0002\u001fj]&$h\bF\u00029um\u0002\"!\u000f\u0001\u000e\u00031AQA\n\u0003A\u0002!BQa\f\u0003A\u0002A\n\u0001c\u001c8SK2,\u0017m]3De\u0016\fG/\u001a3\u0015\u0005y\n\u0005CA\r@\u0013\t\u0001%D\u0001\u0003V]&$\b\"\u0002\"\u0006\u0001\u0004\u0019\u0015!B3wK:$\bC\u0001#I\u001b\u0005)%BA\bG\u0015\t9\u0005#\u0001\u0004e_6\f\u0017N\\\u0005\u0003\u0013\u0016\u00131CU3mK\u0006\u001cXm\u0011:fCR,G-\u0012<f]RD#!B&\u0011\u00051kU\"\u0001\b\n\u00059s!!C*vEN\u001c'/\u001b2f\u0003]ygNU3mK\u0006\u001cX-\u0012=fGV$\u0018n\u001c8Fm\u0016tG\u000f\u0006\u0002?#\")!I\u0002a\u0001%B\u0011AiU\u0005\u0003)\u0016\u0013QCU3mK\u0006\u001cX-\u0012=fGV$\u0018n\u001c8Fm\u0016tG\u000f\u000b\u0002\u0007\u0017\u0006)\u0002.\u00198eY\u0016\u0014V\r\\3bg\u0016,\u00050Z2vi\u0016$GC\u0001 Y\u0011\u0015\u0011u\u00011\u0001Z!\t!%,\u0003\u0002\\\u000b\n!\"+\u001a7fCN,W\t_3dkR,G-\u0012<f]R\f1B]3mK\u0006\u001cX\rT5oWR\u0019a,[8\u0011\u0005}3gB\u00011e!\t\t'$D\u0001c\u0015\t\u0019g#\u0001\u0004=e>|GOP\u0005\u0003Kj\ta\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011QM\u0007\u0005\u0006U\"\u0001\ra[\u0001\be\u0016dW-Y:f!\taW.D\u0001G\u0013\tqgIA\u0004SK2,\u0017m]3\t\u000fAD\u0001\u0013!a\u0001=\u0006i!/\u001a7fCN,7\u000b^1ukN\fQC]3mK\u0006\u001cX\rT5oW\u0012\"WMZ1vYR$#'F\u0001tU\tqFoK\u0001v!\t180D\u0001x\u0015\tA\u00180A\u0005v]\u000eDWmY6fI*\u0011!PG\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001?x\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001bkB$\u0017\r^3QCJ,g\u000e\u001e+bg.\u001cF/\u0019;vg2Kg.\u001a\u000b\u0005}}\f\t\u0001C\u0003k\u0015\u0001\u00071\u000e\u0003\u0004\u0002\u0004)\u0001\rAX\u0001\u0007gR\fG/^:)\u0007\u0001\t9\u0001\u0005\u0003\u0002\n\u0005]QBAA\u0006\u0015\u0011\ti!a\u0004\u0002\u0015M$XM]3pif\u0004XM\u0003\u0003\u0002\u0012\u0005M\u0011aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005U\u0011aA8sO&!\u0011\u0011DA\u0006\u0005\u001d\u0019VM\u001d<jG\u0016D3\u0001AA\u000f!\ra\u0015qD\u0005\u0004\u0003Cq!!D#wK:$H*[:uK:,'\u000f")
public class CreateReleaseTaskHandler
implements Logging {
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CreateReleaseTaskHandler createReleaseTaskHandler = this;
        synchronized (createReleaseTaskHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    @Subscribe
    public void onReleaseCreated(ReleaseCreatedEvent event) {
        ReleaseCreationSource releaseCreationSource = event.source();
        if (releaseCreationSource instanceof CreatedFromCreateReleaseTask) {
            this.updateParentTaskStatusLine(event.release(), "");
            return;
        }
    }

    @Subscribe
    public void onReleaseExecutionEvent(ReleaseExecutionEvent event) {
        String parentTaskId = event.release().getStartedFromTaskId();
        if (parentTaskId != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(parentTaskId))) {
            ReleaseExecutionEvent releaseExecutionEvent = event;
            if (releaseExecutionEvent instanceof ReleaseStartedEvent) {
                ReleaseStartedEvent releaseStartedEvent = (ReleaseStartedEvent)releaseExecutionEvent;
                Release release = releaseStartedEvent.release();
                this.updateParentTaskStatusLine(release, "");
                return;
            }
            if (releaseExecutionEvent instanceof ReleasePausedEvent) {
                ReleasePausedEvent releasePausedEvent = (ReleasePausedEvent)releaseExecutionEvent;
                Release release = releasePausedEvent.release();
                this.updateParentTaskStatusLine(release, "Paused");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseResumedEvent) {
                ReleaseResumedEvent releaseResumedEvent = (ReleaseResumedEvent)releaseExecutionEvent;
                Release release = releaseResumedEvent.release();
                this.updateParentTaskStatusLine(release, "");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseFailedEvent) {
                ReleaseFailedEvent releaseFailedEvent = (ReleaseFailedEvent)releaseExecutionEvent;
                Release release = releaseFailedEvent.release();
                this.updateParentTaskStatusLine(release, "Failed");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseStartedFailingEvent) {
                ReleaseStartedFailingEvent releaseStartedFailingEvent = (ReleaseStartedFailingEvent)releaseExecutionEvent;
                Release release = releaseStartedFailingEvent.release();
                this.updateParentTaskStatusLine(release, "Failing");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseRetriedEvent) {
                ReleaseRetriedEvent releaseRetriedEvent = (ReleaseRetriedEvent)releaseExecutionEvent;
                Release release = releaseRetriedEvent.release();
                this.updateParentTaskStatusLine(release, "");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseExecutedEvent) {
                ReleaseExecutedEvent releaseExecutedEvent = (ReleaseExecutedEvent)releaseExecutionEvent;
                this.handleReleaseExecuted(releaseExecutedEvent);
                return;
            }
            throw new MatchError((Object)releaseExecutionEvent);
        }
    }

    private void handleReleaseExecuted(ReleaseExecutedEvent event) {
        ReleaseExecutedEvent releaseExecutedEvent = event;
        if (releaseExecutedEvent instanceof ReleaseAbortedEvent) {
            ReleaseAbortedEvent releaseAbortedEvent = (ReleaseAbortedEvent)releaseExecutedEvent;
            Release release = releaseAbortedEvent.release();
            String parentTaskId = release.getStartedFromTaskId();
            Try$.MODULE$.apply((Function0 & Serializable)() -> (CreateReleaseTask)$this.taskRepository.findById(parentTaskId, ResolveOptions$.MODULE$.WITHOUT_DECORATORS())).withFilter((Function1 & Serializable)parentTask -> BoxesRunTime.boxToBoolean((boolean)parentTask.getWaitForRelease())).foreach((Function1 & Serializable)parentTask -> {
                CreateReleaseTaskHandler.$anonfun$handleReleaseExecuted$3(this, release, parentTaskId, parentTask);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (releaseExecutedEvent instanceof ReleaseCompletedEvent) {
            ReleaseCompletedEvent releaseCompletedEvent = (ReleaseCompletedEvent)releaseExecutedEvent;
            Release release = releaseCompletedEvent.release();
            String parentTaskId = release.getStartedFromTaskId();
            Try$.MODULE$.apply((Function0 & Serializable)() -> (CreateReleaseTask)$this.taskRepository.findById(parentTaskId, ResolveOptions$.MODULE$.WITHOUT_DECORATORS())).withFilter((Function1 & Serializable)parentTask -> BoxesRunTime.boxToBoolean((boolean)parentTask.getWaitForRelease())).foreach((Function1 & Serializable)parentTask -> {
                CreateReleaseTaskHandler.$anonfun$handleReleaseExecuted$6(this, release, parentTaskId, parentTask);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)releaseExecutedEvent);
    }

    private String releaseLink(Release release, String releaseStatus) {
        Object status = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(releaseStatus)) ? releaseStatus + ":" : "";
        return "[" + (String)status + " " + release.getTitle() + "](#/releases/" + IdType.DOMAIN.convertToViewId(release.getId()) + ")";
    }

    private String releaseLink$default$2() {
        return "";
    }

    private void updateParentTaskStatusLine(Release release, String status) {
        String parentTaskId = release.getStartedFromTaskId();
        if (parentTaskId != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(parentTaskId))) {
            String msg = String.valueOf(this.releaseLink(release, status));
            this.releaseActorService().updateTaskStatusLine(parentTaskId, msg);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleReleaseExecuted$3(CreateReleaseTaskHandler $this, Release release$1, String parentTaskId$1, CreateReleaseTask parentTask) {
        String msg = "Release " + $this.releaseLink(release$1, $this.releaseLink$default$2()) + " was aborted.";
        $this.releaseActorService().failTaskAsync(parentTaskId$1, msg, User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$handleReleaseExecuted$6(CreateReleaseTaskHandler $this, Release release$2, String parentTaskId$2, CreateReleaseTask parentTask) {
        String msg = "Release " + $this.releaseLink(release$2, $this.releaseLink$default$2()) + " was completed.";
        $this.releaseActorService().markTaskAsDoneAsync(TaskStatus.COMPLETED, parentTaskId$2, msg, User.SYSTEM);
    }

    public CreateReleaseTaskHandler(ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
        Logging.$init$((Logging)this);
    }
}

