/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class ModifiedResourceFilter
implements Filter {
    private static final String IF_MODIFIED_SINCE_HEADER = "If-Modified-Since";
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private ZonedDateTime startDateTime;

    public void init(FilterConfig filterConfig) {
        long startTimestamp = Long.parseLong(filterConfig.getInitParameter("startTimestamp"));
        this.startDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTimestamp), ZoneId.systemDefault());
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String ifModifiedSinceHeader = ((HttpServletRequest)req).getHeader(IF_MODIFIED_SINCE_HEADER);
        HttpServletResponse response = (HttpServletResponse)res;
        if (ifModifiedSinceHeader != null) {
            ZonedDateTime ifModifiedSinceDateTime = ZonedDateTime.parse(ifModifiedSinceHeader, DateTimeFormatter.RFC_1123_DATE_TIME);
            if (ifModifiedSinceDateTime.isAfter(this.startDateTime)) {
                response.sendError(304);
            } else {
                this.addHeaderAndDoFilter(req, res, chain);
            }
        } else {
            this.addHeaderAndDoFilter(req, res, chain);
        }
    }

    private void addHeaderAndDoFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        ((HttpServletResponse)res).setHeader(LAST_MODIFIED_HEADER, ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME));
        chain.doFilter(req, res);
    }

    public void destroy() {
    }
}

