/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.api.v1.TaskReportingApi;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;
import com.xebialabs.xlrelease.domain.udm.reporting.BuildRecord;
import com.xebialabs.xlrelease.domain.udm.reporting.CodeComplianceRecord;
import com.xebialabs.xlrelease.domain.udm.reporting.DeploymentRecord;
import com.xebialabs.xlrelease.domain.udm.reporting.ItsmRecord;
import com.xebialabs.xlrelease.domain.udm.reporting.PlanRecord;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.FacetPermissionChecker;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.FacetService;
import io.micrometer.core.annotation.Timed;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskReportingApiImpl
implements TaskReportingApi {
    private final FacetService facetService;
    private final PermissionChecker permissions;
    private final FacetPermissionChecker facetPermissions;

    @Autowired
    public TaskReportingApiImpl(FacetService facetService, PermissionChecker permissions, FacetPermissionChecker facetPermissions) {
        Checks.checkNotNull((Object)facetService, (String)"FacetService must be provided. If you're testing think twice as this object will have impact on other tests!");
        Checks.checkNotNull((Object)permissions, (String)"PermissionChecker must be provided");
        Checks.checkNotNull((Object)facetPermissions, (String)"FacetPermissionChecker must be provided");
        this.facetService = facetService;
        this.permissions = permissions;
        this.facetPermissions = facetPermissions;
    }

    @Timed
    public List<TaskReportingRecord> addRecord(TaskReportingRecord record, boolean applyTaskAttributes) {
        record.setCreatedViaApi(true);
        this.performChecksAndSetRetryCounter(record);
        return this.facetService.addTaskReportingRecord(record, applyTaskAttributes);
    }

    public TaskReportingRecord addRecord(TaskReportingRecord record) {
        return this.addRecord(record, false).get(0);
    }

    public ItsmRecord newItsmRecord() {
        return (ItsmRecord)this.newReportingRecord("udm.ItsmRecord");
    }

    public PlanRecord newPlanRecord() {
        return (PlanRecord)this.newReportingRecord("udm.PlanRecord");
    }

    public BuildRecord newBuildRecord() {
        return (BuildRecord)this.newReportingRecord("udm.BuildRecord");
    }

    public DeploymentRecord newDeploymentRecord() {
        return (DeploymentRecord)this.newReportingRecord("udm.DeploymentRecord");
    }

    public CodeComplianceRecord newCodeComplianceRecord() {
        return (CodeComplianceRecord)this.newReportingRecord("udm.CodeComplianceRecord");
    }

    private <F extends Facet> F newReportingRecord(String type) {
        return (F)((Facet)Type.valueOf((String)type).getDescriptor().newInstance(""));
    }

    private void performChecksAndSetRetryCounter(TaskReportingRecord record) {
        if (record.getTargetId() == null || record.getTargetId().trim().isEmpty()) {
            if (this.facetPermissions.hasScriptTask()) {
                record.setTargetId(this.facetPermissions.getScriptTask().getId());
            } else {
                throw new IllegalStateException("reporting record should have targetId populated unless it is called from within script task context");
            }
        }
        String releaseId = Ids.releaseIdFrom((String)record.getTargetId());
        this.facetPermissions.checkThatScriptTaskBelongsToReleaseOrOtherwise(releaseId, () -> {
            this.permissions.checkView(releaseId);
            this.permissions.checkEdit(releaseId);
            this.permissions.checkEditTask(releaseId);
        });
        if (this.facetPermissions.hasScriptTask()) {
            record.setRetryAttemptNumber(this.facetPermissions.getScriptTask().getFailuresCount());
        }
    }
}

