package com.xebialabs.xlrelease.actors.cluster

import com.xebialabs.xlrelease.actors.ActorSystemHolder
import org.apache.pekko.cluster.Cluster
import org.apache.pekko.management.scaladsl.PekkoManagement

trait XlrClusterInformation {
  def myself: ClusterMember
}

case class XlrClusterInformationImpl(actorSystemHolder: ActorSystemHolder) extends XlrClusterInformation {
  lazy val cluster: Cluster = Cluster(actorSystemHolder.actorSystem)
  private lazy val management: PekkoManagement = PekkoManagement(actorSystemHolder.actorSystem)

  lazy val myself: ClusterMember = ClusterMember(
    cluster.selfDataCenter,
    cluster.selfAddress.protocol,
    actorSystemHolder.actorSystem.name,
    management.settings.getHttpEffectiveBindHostname,
    management.settings.getHttpEffectiveBindPort,
    cluster.selfAddress.port.getOrElse(0)
  )
}
