package com.xebialabs.xlrelease.events;

import org.springframework.beans.factory.serviceloader.ServiceListFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Using ServiceLoader facility will find all implementations of XLReleaseEventListener defined under META-INF/services
 * Used by external plugins
 */
@Configuration
public class EventFactoryBeanConfig {

    public static final String EVENT_FACTORY_BEAN = "eventFactoryBean";

    @Bean(name = EVENT_FACTORY_BEAN)
    public ServiceListFactoryBean serviceListFactoryBean() {
        ServiceListFactoryBean serviceListFactoryBean = new ServiceListFactoryBean();
        serviceListFactoryBean.setServiceType(XLReleaseEventListener.class);
        return serviceListFactoryBean;
    }
}
