/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.ManagementApi;
import com.xebialabs.xlrelease.api.v1.forms.DatacenterTargetStateRequest;
import com.xebialabs.xlrelease.api.v1.views.ApplicationStatusView;
import com.xebialabs.xlrelease.api.v1.views.ServiceStatusView;
import com.xebialabs.xlrelease.domain.Datacenter;
import com.xebialabs.xlrelease.domain.DatacenterTargetState;
import com.xebialabs.xlrelease.domain.management.ServiceState$;
import com.xebialabs.xlrelease.domain.management.ServiceStatus;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.DatacenterService;
import com.xebialabs.xlrelease.service.XlrServiceManager;
import java.io.Serializable;
import org.springframework.stereotype.Controller;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\u0006\r\u0001eA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007C\u00039\u0001\u0011\u0005\u0011\bC\u0003@\u0001\u0011\u0005\u0003\tC\u0003H\u0001\u0011\u0005\u0003\tC\u0003I\u0001\u0011\u0005\u0013\nC\u0003Q\u0001\u0011\u0005\u0013\u000bC\u0003_\u0001\u0011\u0005s\fC\u0003v\u0001\u0011\u0005cOA\tNC:\fw-Z7f]R\f\u0005/[%na2T!!\u0004\b\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u001fA\t!A^\u0019\u000b\u0005E\u0011\u0012aA1qS*\u00111\u0003F\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0006\f\u0002\u0013a,'-[1mC\n\u001c(\"A\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Q\"\u0005\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005!A.\u00198h\u0015\u0005y\u0012\u0001\u00026bm\u0006L!!\t\u000f\u0003\r=\u0013'.Z2u!\t\u0019C%D\u0001\u000f\u0013\t)cBA\u0007NC:\fw-Z7f]R\f\u0005/[\u0001\u0012q2\u00148+\u001a:wS\u000e,W*\u00198bO\u0016\u0014\bC\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0013\u0003\u001d\u0019XM\u001d<jG\u0016L!\u0001L\u0015\u0003#ac'oU3sm&\u001cW-T1oC\u001e,'/A\teCR\f7-\u001a8uKJ\u001cVM\u001d<jG\u0016\u0004\"\u0001K\u0018\n\u0005AJ#!\u0005#bi\u0006\u001cWM\u001c;feN+'O^5dK\u0006Y\u0001/\u001a:nSN\u001c\u0018n\u001c8t!\t\u0019d'D\u00015\u0015\t)$#\u0001\u0005tK\u000e,(/\u001b;z\u0013\t9DGA\tQKJl\u0017n]:j_:\u001c\u0005.Z2lKJ\fa\u0001P5oSRtD\u0003\u0002\u001e={y\u0002\"a\u000f\u0001\u000e\u00031AQA\n\u0003A\u0002\u001dBQ!\f\u0003A\u00029BQ!\r\u0003A\u0002I\nQa\u001d;beR$\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0005+:LG/\u0001\u0003ti>\u0004\u0018!E1qa2L7-\u0019;j_:\u001cF/\u0019;vgR\t!\n\u0005\u0002L\u001d6\tAJ\u0003\u0002N\u001d\u0005)a/[3xg&\u0011q\n\u0014\u0002\u0016\u0003B\u0004H.[2bi&|gn\u0015;biV\u001ch+[3x\u000399W\r\u001e#bi\u0006\u001cWM\u001c;feN$\u0012A\u0015\t\u0004'ZCV\"\u0001+\u000b\u0005Us\u0012\u0001B;uS2L!a\u0016+\u0003\t1K7\u000f\u001e\t\u00033rk\u0011A\u0017\u0006\u00037J\ta\u0001Z8nC&t\u0017BA/[\u0005)!\u0015\r^1dK:$XM]\u0001\u0013g\u0016$H)\u0019;bG\u0016tG/\u001a:Ti\u0006$X\rF\u0002BA6DQ!Y\u0005A\u0002\t\f!\u0002Z1uC\u000e,g\u000e^3s!\t\u0019'N\u0004\u0002eQB\u0011QmQ\u0007\u0002M*\u0011q\rG\u0001\u0007yI|w\u000e\u001e \n\u0005%\u001c\u0015A\u0002)sK\u0012,g-\u0003\u0002lY\n11\u000b\u001e:j]\u001eT!![\"\t\u000b9L\u0001\u0019A8\u00029\u0011\fG/Y2f]R,'\u000fV1sO\u0016$8\u000b^1uKJ+\u0017/^3tiB\u0011\u0001o]\u0007\u0002c*\u0011!OD\u0001\u0006M>\u0014Xn]\u0005\u0003iF\u0014A\u0004R1uC\u000e,g\u000e^3s)\u0006\u0014x-\u001a;Ti\u0006$XMU3rk\u0016\u001cH/\u0001\teK2,G/\u001a#bi\u0006\u001cWM\u001c;feR\u0011\u0011i\u001e\u0005\u0006C*\u0001\rA\u0019\u0015\u0003\u0001e\u00042A_A\u0002\u001b\u0005Y(B\u0001?~\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0003}~\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003\u0003\t1a\u001c:h\u0013\r\t)a\u001f\u0002\u000b\u0007>tGO]8mY\u0016\u0014\b")
public class ManagementApiImpl
implements ManagementApi {
    private final XlrServiceManager xlrServiceManager;
    private final DatacenterService datacenterService;
    private final PermissionChecker permissions;

    public void start() {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.xlrServiceManager.startAsync();
    }

    public void stop() {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.xlrServiceManager.stopAsync();
    }

    public ApplicationStatusView applicationStatus() {
        this.permissions.check(PlatformPermissions.ADMIN);
        List<ServiceStatus> serviceStatuses = this.xlrServiceManager.getServicesStatus();
        boolean isRunning = serviceStatuses.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ManagementApiImpl.$anonfun$applicationStatus$1(x$1)));
        List serviceStatusViews = serviceStatuses.map((Function1 & Serializable)serviceStatus -> ServiceStatusView.from((ServiceStatus)serviceStatus));
        return new ApplicationStatusView(Predef$.MODULE$.boolean2Boolean(isRunning), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)serviceStatusViews).asJava());
    }

    public java.util.List<Datacenter> getDatacenters() {
        this.permissions.check(PlatformPermissions.ADMIN);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.datacenterService.getDatacenters()).asJava();
    }

    public void setDatacenterState(String datacenter, DatacenterTargetStateRequest datacenterTargetStateRequest) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.datacenterService.validateDatacenterStateChange();
        this.datacenterService.setDatacenterState(datacenter, DatacenterTargetState.fromString((String)datacenterTargetStateRequest.getTargetState()));
    }

    public void deleteDatacenter(String datacenter) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.datacenterService.deleteDatacenter(datacenter);
    }

    public static final /* synthetic */ boolean $anonfun$applicationStatus$1(ServiceStatus x$1) {
        Enumeration.Value value = x$1.state();
        Enumeration.Value value2 = ServiceState$.MODULE$.Running();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public ManagementApiImpl(XlrServiceManager xlrServiceManager, DatacenterService datacenterService, PermissionChecker permissions) {
        this.xlrServiceManager = xlrServiceManager;
        this.datacenterService = datacenterService;
        this.permissions = permissions;
    }
}

