/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.PermissionChecker$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.BreakInheritanceOperation;
import com.xebialabs.xlrelease.service.CreateTeamOperation;
import com.xebialabs.xlrelease.service.DeleteTeamOperation;
import com.xebialabs.xlrelease.service.TeamMembership;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.TeamUpdateOperation;
import com.xebialabs.xlrelease.service.UpdateTeamOperation;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc!C\b\u0011!\u0003\r\t!GA\"\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0011\u0015)\u0003A\"\u0001'\u0011\u0015i\u0003A\"\u0001/\u0011\u00151\u0004\u0001\"\u00018\u0011\u0015)\u0006\u0001\"\u0003W\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013Aq!a\u0004\u0001\t\u0003\t\t\u0002C\u0005\u0002 \u0001\t\n\u0011\"\u0001\u0002\"!I\u0011q\u0007\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0005\u0005\b\u0003s\u0001A\u0011BA\u001e\u0005q\u0001VM]7jgNLwN\\\"iK\u000e\\WM]*iCJ,G\rT8hS\u000eT!!\u0005\n\u0002\u0011M,7-\u001e:jifT!a\u0005\u000b\u0002\u0013ad'/\u001a7fCN,'BA\u000b\u0017\u0003%AXMY5bY\u0006\u00147OC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VMZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\t\u0002\"aG\u0012\n\u0005\u0011b\"\u0001B+oSR\f1\u0002^3b[N+'O^5dKV\tq\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+%\u000591/\u001a:wS\u000e,\u0017B\u0001\u0017*\u0005-!V-Y7TKJ4\u0018nY3\u0002\u0017I|G.Z*feZL7-Z\u000b\u0002_A\u0011\u0001\u0007N\u0007\u0002c)\u0011\u0011C\r\u0006\u0003gQ\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003kE\u00121BU8mKN+'O^5dK\u0006i2\r[3dW\u0016#\u0017\u000e\u001e+fC6\u001c\u0018iZ1j]N$X\t_5ti&tw\rF\u0002#q\u0015CQ!\u000f\u0003A\u0002i\nq\u0002^3b[\u000e{g\u000e^1j]\u0016\u0014\u0018\n\u001a\t\u0003w\ts!\u0001\u0010!\u0011\u0005ubR\"\u0001 \u000b\u0005}B\u0012A\u0002\u001fs_>$h(\u0003\u0002B9\u00051\u0001K]3eK\u001aL!a\u0011#\u0003\rM#(/\u001b8h\u0015\t\tE\u0004C\u0003G\t\u0001\u0007q)A\u0003uK\u0006l7\u000fE\u0002I\u001b>k\u0011!\u0013\u0006\u0003\u0015.\u000bA!\u001e;jY*\tA*\u0001\u0003kCZ\f\u0017B\u0001(J\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0003!Nk\u0011!\u0015\u0006\u0003%J\ta\u0001Z8nC&t\u0017B\u0001+R\u0005\u0011!V-Y7\u0002G\rDWmY6FI&$hi\u001c7eKJ$V-Y7t\u0003\u001e\f\u0017N\\:u\u000bbL7\u000f^5oOR\u0019!e\u0016-\t\u000be*\u0001\u0019\u0001\u001e\t\u000b\u0019+\u0001\u0019A-\u0011\u0007i{vJ\u0004\u0002\\;:\u0011Q\bX\u0005\u0002;%\u0011a\fH\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0017MA\u0002TKFT!A\u0018\u000f\u0002'\rDWmY6EK2,G/Z(x]R+\u0017-\\:\u0015\u0005\t\"\u0007\"B\u001d\u0007\u0001\u0004Q\u0014AE4fiV\u001bXM\u001d$pY\u0012,'\u000fV3b[N$\"a\u001a6\u0011\u0007!Cw*\u0003\u0002j\u0013\n!A*[:u\u0011\u0015Yw\u00011\u0001;\u0003!1w\u000e\u001c3fe&#\u0017AD2iK\u000e\\W\tZ5u)\u0016\fWn\u001d\u000b\u0004E9|\u0007\"B\u001d\t\u0001\u0004Q\u0004\"\u00029\t\u0001\u0004\t\u0018AC8qKJ\fG/[8ogB\u0012!/\u001e\t\u00045~\u001b\bC\u0001;v\u0019\u0001!\u0011B^8\u0002\u0002\u0003\u0005)\u0011A<\u0003\u0007}#\u0013'\u0005\u0002ywB\u00111$_\u0005\u0003ur\u0011qAT8uQ&tw\r\u0005\u0002)y&\u0011Q0\u000b\u0002\u0014)\u0016\fW.\u00169eCR,w\n]3sCRLwN\\\u0001\u0015G\",7m[#eSR$V-Y7NK6\u0014WM]:\u0015\u000b\t\n\t!a\u0001\t\u000beJ\u0001\u0019\u0001\u001e\t\r\u0005\u0015\u0011\u00021\u0001P\u0003\u0011!X-Y7\u0002\u001f\rDWmY6EK2,G/\u001a+fC6$RAIA\u0006\u0003\u001bAQ!\u000f\u0006A\u0002iBa!!\u0002\u000b\u0001\u0004y\u0015\u0001G2iK\u000e\\W\tZ5u)\u0016\fW\u000eU3s[&\u001c8/[8ogR9!%a\u0005\u0002\u0016\u0005m\u0001\"B\u001d\f\u0001\u0004Q\u0004\"CA\f\u0017A\u0005\t\u0019AA\r\u0003A\tG\rZ3e!\u0016\u0014X.[:tS>t7\u000fE\u0002[?jB\u0011\"!\b\f!\u0003\u0005\r!!\u0007\u0002%I,Wn\u001c<fIB+'/\\5tg&|gn]\u0001#G\",7m[#eSR$V-Y7QKJl\u0017n]:j_:\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\r\"\u0006BA\r\u0003KY#!a\n\u0011\t\u0005%\u00121G\u0007\u0003\u0003WQA!!\f\u00020\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003ca\u0012AC1o]>$\u0018\r^5p]&!\u0011QGA\u0016\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001#G\",7m[#eSR$V-Y7QKJl\u0017n]:j_:\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0002)\rDWmY6FI&$hi\u001c7eKJ$V-Y7t)\u0015\u0011\u0013QHA \u0011\u0015Id\u00021\u0001;\u0011\u0019\u0001h\u00021\u0001\u0002BA\u0019!lX>\u0013\r\u0005\u0015\u0013\u0011JA'\r\u0019\t9\u0005\u0001\u0001\u0002D\taAH]3gS:,W.\u001a8u}A\u0019\u00111\n\u0001\u000e\u0003A\u0001B!a\u0013\u0002P%\u0019\u0011\u0011\u000b\t\u0003#A+'/\\5tg&|gn\u00115fG.,'\u000f")
public interface PermissionCheckerSharedLogic {
    public TeamService teamService();

    public RoleService roleService();

    public static /* synthetic */ void checkEditTeamsAgainstExisting$(PermissionCheckerSharedLogic $this, String teamContainerId, Collection teams) {
        $this.checkEditTeamsAgainstExisting(teamContainerId, teams);
    }

    default public void checkEditTeamsAgainstExisting(String teamContainerId, Collection<Team> teams) {
        if (Ids.isReleaseId((String)teamContainerId)) {
            ((PermissionChecker)((Object)this)).checkEdit(teamContainerId);
            return;
        }
        if (Ids.isFolderId((String)teamContainerId)) {
            this.checkEditFolderTeamsAgainstExisting(teamContainerId, (Seq<Team>)CollectionConverters$.MODULE$.CollectionHasAsScala(teams).asScala().toSeq());
            return;
        }
        throw new Checks.IncorrectArgumentException("[%s] is not a release or a folder", new Object[]{teamContainerId});
    }

    private void checkEditFolderTeamsAgainstExisting(String teamContainerId, Seq<Team> teams) {
        boolean superUser = ((PermissionChecker)((Object)this)).isCurrentUserAdmin();
        boolean folderSecurityAdministrator = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_SECURITY, teamContainerId);
        boolean folderTeamAdmin = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_TEAMS, teamContainerId);
        if (folderTeamAdmin && !folderSecurityAdministrator && !superUser) {
            Buffer folderTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService().getEffectiveTeams(teamContainerId)).asScala();
            Seq newAndUpdatedTeams = (Seq)teams.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PermissionCheckerSharedLogic.$anonfun$checkEditFolderTeamsAgainstExisting$1(folderTeams, x$1)));
            newAndUpdatedTeams.foreach((Function1 & Serializable)team -> {
                PermissionCheckerSharedLogic.$anonfun$checkEditFolderTeamsAgainstExisting$2(folderTeams, team);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (!superUser && !folderSecurityAdministrator) {
            throw PermissionChecker$.MODULE$.userCannotManageTeamException();
        }
    }

    public static /* synthetic */ void checkDeleteOwnTeams$(PermissionCheckerSharedLogic $this, String teamContainerId) {
        $this.checkDeleteOwnTeams(teamContainerId);
    }

    default public void checkDeleteOwnTeams(String teamContainerId) {
        if (Ids.isReleaseId((String)teamContainerId)) {
            ((PermissionChecker)((Object)this)).checkEdit(teamContainerId);
            return;
        }
        if (Ids.isFolderId((String)teamContainerId)) {
            boolean superUser = ((PermissionChecker)((Object)this)).isCurrentUserAdmin();
            boolean owner = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_SECURITY, teamContainerId);
            boolean admin = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_TEAMS, teamContainerId);
            if (admin && !owner && !superUser) {
                Buffer userFolderTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.getUserFolderTeams(teamContainerId)).asScala();
                userFolderTeams.foreach((Function1 & Serializable)team -> {
                    PermissionCheckerSharedLogic.$anonfun$checkDeleteOwnTeams$1(team);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (!superUser && !owner) {
                throw PermissionChecker$.MODULE$.userCannotManageTeamException();
            }
            return;
        }
        throw new Checks.IncorrectArgumentException("[%s] is not a release or a folder", new Object[]{teamContainerId});
    }

    public static /* synthetic */ List getUserFolderTeams$(PermissionCheckerSharedLogic $this, String folderId) {
        return $this.getUserFolderTeams(folderId);
    }

    default public List<Team> getUserFolderTeams(String folderId) {
        String username = User.AUTHENTICATED_USER.getName();
        List<Team> folderTeams = this.teamService().getEffectiveTeams(folderId);
        List userRoles = this.roleService().getRolesFor(Permissions.getAuthentication());
        return folderTeams.stream().filter(team -> team.hasMember(username) || team.hasAnyRole(userRoles)).collect(Collectors.toList());
    }

    public static /* synthetic */ void checkEditTeams$(PermissionCheckerSharedLogic $this, String teamContainerId, Seq operations) {
        $this.checkEditTeams(teamContainerId, (Seq<TeamUpdateOperation>)operations);
    }

    default public void checkEditTeams(String teamContainerId, Seq<TeamUpdateOperation> operations) {
        if (Ids.isReleaseId((String)teamContainerId)) {
            ((PermissionChecker)((Object)this)).checkEdit(teamContainerId);
            return;
        }
        if (Ids.isFolderId((String)teamContainerId)) {
            this.checkEditFolderTeams(teamContainerId, operations);
            return;
        }
        throw new Checks.IncorrectArgumentException("[%s] is not a release or a folder", new Object[]{teamContainerId});
    }

    public static /* synthetic */ void checkEditTeamMembers$(PermissionCheckerSharedLogic $this, String teamContainerId, Team team) {
        $this.checkEditTeamMembers(teamContainerId, team);
    }

    default public void checkEditTeamMembers(String teamContainerId, Team team) {
        boolean superUser = ((PermissionChecker)((Object)this)).isCurrentUserAdmin();
        boolean folderOwner = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_SECURITY, teamContainerId);
        boolean folderAdmin = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_TEAMS, teamContainerId);
        if (folderAdmin && !folderOwner && !superUser) {
            if (team.isFolderOwnerTeam() || team.isFolderAdminTeam() || team.hasPermission(XLReleasePermissions.EDIT_FOLDER.getPermissionName())) {
                throw PermissionChecker$.MODULE$.folderAdminCannotDeleteTeamException();
            }
            return;
        }
        if (!superUser && !folderOwner) {
            throw PermissionChecker$.MODULE$.userCannotManageTeamException();
        }
    }

    public static /* synthetic */ void checkDeleteTeam$(PermissionCheckerSharedLogic $this, String teamContainerId, Team team) {
        $this.checkDeleteTeam(teamContainerId, team);
    }

    default public void checkDeleteTeam(String teamContainerId, Team team) {
        boolean superUser = ((PermissionChecker)((Object)this)).isCurrentUserAdmin();
        boolean folderOwner = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_SECURITY, teamContainerId);
        boolean folderAdmin = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_TEAMS, teamContainerId);
        if (folderAdmin && !folderOwner && !superUser) {
            if (team.isFolderOwnerTeam() || team.isFolderAdminTeam()) {
                throw PermissionChecker$.MODULE$.folderAdminCannotDeleteTeamException();
            }
            return;
        }
        if (!superUser && !folderOwner) {
            throw PermissionChecker$.MODULE$.userCannotManageTeamException();
        }
    }

    public static /* synthetic */ void checkEditTeamPermissions$(PermissionCheckerSharedLogic $this, String teamContainerId, Seq addedPermissions, Seq removedPermissions) {
        $this.checkEditTeamPermissions(teamContainerId, (Seq<String>)addedPermissions, (Seq<String>)removedPermissions);
    }

    default public void checkEditTeamPermissions(String teamContainerId, Seq<String> addedPermissions, Seq<String> removedPermissions) {
        boolean superUser = ((PermissionChecker)((Object)this)).isCurrentUserAdmin();
        boolean folderOwner = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_SECURITY, teamContainerId);
        boolean folderAdmin = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_TEAMS, teamContainerId);
        if (folderAdmin && !folderOwner && !superUser) {
            boolean folderOwnerAdded = addedPermissions.contains((Object)XLReleasePermissions.EDIT_FOLDER_SECURITY.getPermissionName());
            boolean folderAdminAdded = addedPermissions.contains((Object)XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName());
            if (folderOwnerAdded || folderAdminAdded) {
                throw PermissionChecker$.MODULE$.folderAdminCannotAssignPermissionException();
            }
            if (addedPermissions.contains((Object)XLReleasePermissions.EDIT_FOLDER.getPermissionName())) {
                throw PermissionChecker$.MODULE$.folderAdminCannotAssignPermissionException();
            }
            scala.collection.immutable.Set permissionsToCheck = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{XLReleasePermissions.EDIT_FOLDER_SECURITY.getPermissionName(), XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName()}));
            if (removedPermissions.toSet().intersect((Set)permissionsToCheck).nonEmpty()) {
                throw PermissionChecker$.MODULE$.folderAdminCannotEditTeamException();
            }
            return;
        }
        if (!superUser && !folderOwner) {
            throw PermissionChecker$.MODULE$.userCannotManageTeamException();
        }
    }

    public static /* synthetic */ Seq checkEditTeamPermissions$default$2$(PermissionCheckerSharedLogic $this) {
        return $this.checkEditTeamPermissions$default$2();
    }

    default public Seq<String> checkEditTeamPermissions$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static /* synthetic */ Seq checkEditTeamPermissions$default$3$(PermissionCheckerSharedLogic $this) {
        return $this.checkEditTeamPermissions$default$3();
    }

    default public Seq<String> checkEditTeamPermissions$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private void checkEditFolderTeams(String teamContainerId, Seq<TeamUpdateOperation> operations) {
        boolean superUser = ((PermissionChecker)((Object)this)).isCurrentUserAdmin();
        boolean folderOwner = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_SECURITY, teamContainerId);
        boolean folderAdmin = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_TEAMS, teamContainerId);
        if (folderAdmin && !folderOwner && !superUser) {
            operations.foreach((Function1 & Serializable)x0$1 -> {
                PermissionCheckerSharedLogic.$anonfun$checkEditFolderTeams$2(this, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (!superUser && !folderOwner) {
            throw PermissionChecker$.MODULE$.userCannotManageTeamException();
        }
    }

    public static /* synthetic */ boolean $anonfun$checkEditFolderTeamsAgainstExisting$1(Buffer folderTeams$1, Team x$1) {
        return !folderTeams$1.contains((Object)x$1);
    }

    public static /* synthetic */ boolean $anonfun$checkEditFolderTeamsAgainstExisting$3(Team team$1, Team x$2) {
        String string = x$2.getTeamName();
        String string2 = team$1.getTeamName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static /* synthetic */ void $anonfun$checkEditFolderTeamsAgainstExisting$4(Team old) {
        if (old.isFolderOwnerTeam() || old.isFolderAdminTeam()) {
            throw PermissionChecker$.MODULE$.folderAdminCannotEditTeamException();
        }
    }

    public static /* synthetic */ void $anonfun$checkEditFolderTeamsAgainstExisting$2(Buffer folderTeams$1, Team team) {
        if (team.isFolderOwnerTeam() || team.isFolderAdminTeam()) {
            throw PermissionChecker$.MODULE$.folderAdminCannotAssignPermissionException();
        }
        if (team.hasPermission(XLReleasePermissions.EDIT_FOLDER.getPermissionName())) {
            throw PermissionChecker$.MODULE$.folderAdminCannotAssignPermissionException();
        }
        Option oldTeam = folderTeams$1.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PermissionCheckerSharedLogic.$anonfun$checkEditFolderTeamsAgainstExisting$3(team, x$2)));
        oldTeam.foreach((Function1 & Serializable)old -> {
            PermissionCheckerSharedLogic.$anonfun$checkEditFolderTeamsAgainstExisting$4(old);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void $anonfun$checkDeleteOwnTeams$1(Team team) {
        if (team.isFolderOwnerTeam() || team.isFolderAdminTeam()) {
            throw PermissionChecker$.MODULE$.folderAdminCannotDeleteTeamException();
        }
    }

    private static void checkEditOperation$1(TeamUpdateOperation teamOperation) {
        if (teamOperation.isFolderOwnerTeam() || teamOperation.isFolderAdminTeam()) {
            throw PermissionChecker$.MODULE$.folderAdminCannotAssignPermissionException();
        }
        if (teamOperation.hasPermission(XLReleasePermissions.EDIT_FOLDER.getPermissionName())) {
            throw PermissionChecker$.MODULE$.folderAdminCannotAssignPermissionException();
        }
    }

    private static void checkCreate$1(CreateTeamOperation teamOperation) {
        PermissionCheckerSharedLogic.checkEditOperation$1(teamOperation);
    }

    private static void checkUpdate$1(UpdateTeamOperation teamOperation) {
        PermissionCheckerSharedLogic.checkEditOperation$1(teamOperation);
        TeamMembership removedMembership = teamOperation.removedMembership();
        scala.collection.immutable.Set permissionsToCheck = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{XLReleasePermissions.EDIT_FOLDER_SECURITY.getPermissionName(), XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName()}));
        if (removedMembership.permissions().intersect((Set)permissionsToCheck).nonEmpty()) {
            throw PermissionChecker$.MODULE$.folderAdminCannotEditTeamException();
        }
    }

    public static /* synthetic */ void $anonfun$checkEditFolderTeams$1(Team team) {
        if (team.isFolderOwnerTeam() || team.isFolderAdminTeam()) {
            throw PermissionChecker$.MODULE$.folderAdminCannotDeleteTeamException();
        }
    }

    private void checkDelete$1(DeleteTeamOperation teamOperation) {
        Option<Team> maybeTeam = this.teamService().securityRepository().findTeamByName(teamOperation.containerId(), teamOperation.team());
        maybeTeam.foreach((Function1 & Serializable)team -> {
            PermissionCheckerSharedLogic.$anonfun$checkEditFolderTeams$1(team);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void $anonfun$checkEditFolderTeams$2(PermissionCheckerSharedLogic $this, TeamUpdateOperation x0$1) {
        TeamUpdateOperation teamUpdateOperation = x0$1;
        if (teamUpdateOperation instanceof BreakInheritanceOperation) {
            return;
        }
        if (teamUpdateOperation instanceof CreateTeamOperation) {
            CreateTeamOperation createTeamOperation = (CreateTeamOperation)teamUpdateOperation;
            PermissionCheckerSharedLogic.checkCreate$1(createTeamOperation);
            return;
        }
        if (teamUpdateOperation instanceof UpdateTeamOperation) {
            UpdateTeamOperation updateTeamOperation = (UpdateTeamOperation)teamUpdateOperation;
            PermissionCheckerSharedLogic.checkUpdate$1(updateTeamOperation);
            return;
        }
        if (teamUpdateOperation instanceof DeleteTeamOperation) {
            DeleteTeamOperation deleteTeamOperation = (DeleteTeamOperation)teamUpdateOperation;
            $this.checkDelete$1(deleteTeamOperation);
            return;
        }
        throw new MatchError((Object)teamUpdateOperation);
    }

    public static void $init$(PermissionCheckerSharedLogic $this) {
    }
}

