/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.internal.UploadResource;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.api.v1.TeamFacade;
import com.xebialabs.xlrelease.api.v1.TemplateApi;
import com.xebialabs.xlrelease.api.v1.VariableComponent;
import com.xebialabs.xlrelease.api.v1.forms.CopyTemplate;
import com.xebialabs.xlrelease.api.v1.forms.CreateRelease;
import com.xebialabs.xlrelease.api.v1.forms.StartRelease;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.export.ImportType;
import com.xebialabs.xlrelease.export.TemplateExporter;
import com.xebialabs.xlrelease.export.TemplateImporter;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.TemplateMetadataService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.views.ImportResult;
import com.xebialabs.xlrelease.views.TemplateFilters;
import io.micrometer.core.annotation.Timed;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class TemplateApiImpl
implements TemplateApi {
    private static final String XLR_EXTENSION = ".xlr";
    private static final String APPLICATION_ZIP_MEDIA_TYPE = "application/zip";
    private final ReleaseActorService releaseActorService;
    private final PermissionChecker permissions;
    private final ReleaseService releaseService;
    private final ReleaseSearchService releaseSearchService;
    private final TemplateImporter templateImporter;
    private final UploadResource uploadResource;
    private final VariableComponent variableComponent;
    private final TeamFacade teamFacade;
    private final TeamService teamService;
    private final TemplateExporter templateExporter;
    private final TemplateMetadataService templateMetadataService;

    @Autowired
    public TemplateApiImpl(ReleaseActorService releaseActorService, PermissionChecker permissions, ReleaseService releaseService, ReleaseSearchService releaseSearchService, TemplateImporter templateImporter, UploadResource uploadResource, VariableComponent variableComponent, TeamFacade teamFacade, TeamService teamService, TemplateExporter templateExporter, TemplateMetadataService templateMetadataService) {
        this.releaseActorService = releaseActorService;
        this.permissions = permissions;
        this.releaseService = releaseService;
        this.releaseSearchService = releaseSearchService;
        this.templateImporter = templateImporter;
        this.uploadResource = uploadResource;
        this.variableComponent = variableComponent;
        this.teamFacade = teamFacade;
        this.teamService = teamService;
        this.templateExporter = templateExporter;
        this.templateMetadataService = templateMetadataService;
    }

    @Timed
    public List<Release> getTemplates(String title, List<String> tags, String kind, Long page, Long resultsPerPage, Integer depth) {
        return this.getTemplates(title, tags, kind, page, resultsPerPage);
    }

    @Timed
    public List<Release> getTemplates(String title, List<String> tags, String kind, Long page, Long resultsPerPage) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        TemplateFilters templateFilters = new TemplateFilters();
        templateFilters.setTitle(title);
        templateFilters.setTags(tags);
        templateFilters.setKind(ReleaseKind.fromString((String)kind));
        ReleaseSearchResult searchResult = this.releaseSearchService.searchTemplates(templateFilters, page, resultsPerPage, true);
        return searchResult.getReleases();
    }

    @Timed
    public List<Release> getTemplates(String filter) {
        return this.getTemplates(filter, null, ReleaseKind.RELEASE.value(), 0L, 100L);
    }

    @Timed
    public Release updateTemplate(String templateId, Release template) {
        this.permissions.checkEdit(templateId);
        return this.releaseActorService.updateTemplate(templateId, template);
    }

    @Timed
    public Release createTemplate(Release template, String folderId) {
        this.checkTemplatePermissions(folderId);
        CiHelper.stripChildrenCis((ConfigurationItem)template);
        Checks.checkArgument((boolean)template.hasTitle(), (String)"Template title is mandatory", (Object[])new Object[0]);
        Checks.checkArgument((boolean)template.hasValidStartDates(), (String)"Dates are not valid", (Object[])new Object[0]);
        Checks.checkArgument((boolean)template.isTemplate(), (String)"Only templates can be created", (Object[])new Object[0]);
        return this.releaseService.createTemplate(template, folderId);
    }

    @Timed
    public List<ImportResult> importTemplate(String json, String folderId, String version) {
        ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes());
        this.checkTemplatePermissions(folderId);
        return this.templateImporter.importReleaseStream(stream, ImportType.Json(), folderId, version);
    }

    @Timed
    public List<ImportResult> importTemplate(String json, String folderId) {
        return this.importTemplate(json, folderId, null);
    }

    @Timed
    public List<ImportResult> importTemplateAsXlr(HttpServletRequest request, String folderId) throws IOException {
        return this.uploadResource.importTemplates(request, folderId);
    }

    @Timed
    public Release getTemplate(String templateId) {
        Release template = this.releaseService.findById(templateId);
        this.permissions.checkView(template);
        return template;
    }

    @Timed
    public void deleteTemplate(String templateId) {
        this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        this.releaseActorService.deleteTemplate(templateId);
    }

    @Timed
    public Release create(String templateId, CreateRelease createRelease) {
        String createReleaseFolder = createRelease.getFolderId();
        String fullTemplateId = this.releaseService.getFullId(templateId);
        String targetFolderId = createReleaseFolder != null ? createReleaseFolder : Ids.findFolderId((String)fullTemplateId);
        this.permissions.checkIsAllowedToCreateReleaseFromTemplate(fullTemplateId, targetFolderId);
        Checks.checkArgument((createRelease.getReleaseTitle() != null ? 1 : 0) != 0, (String)"Release title is mandatory", (Object[])new Object[0]);
        return this.releaseService.createFromTemplate(fullTemplateId, createRelease);
    }

    @Timed
    public Release start(String templateId, StartRelease startRelease) {
        Release release = this.create(templateId, (CreateRelease)startRelease);
        return this.releaseActorService.startRelease(release.getId(), User.AUTHENTICATED_USER, true);
    }

    @Timed
    public List<com.xebialabs.xlrelease.domain.variables.Variable> getVariables(String templateId) {
        return this.variableComponent.getVariables(templateId);
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable getVariable(String variableId) {
        return this.variableComponent.getVariable(variableId);
    }

    @Timed
    public Collection<Object> getVariablePossibleValues(String variableId) {
        return this.variableComponent.getVariablePossibleValues(variableId);
    }

    @Timed
    public Boolean isVariableUsed(String variableId) {
        return this.variableComponent.isVariableUsed(variableId);
    }

    @Timed
    public void replaceVariable(String variableId, VariableOrValue variableOrValue) {
        this.variableComponent.replaceVariable(variableId, variableOrValue);
    }

    @Timed
    public void deleteVariable(String variableId) {
        this.variableComponent.deleteVariable(variableId);
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable createVariable(String templateId, Variable variable) {
        return this.variableComponent.createVariable(templateId, variable);
    }

    @Timed
    public List<com.xebialabs.xlrelease.domain.variables.Variable> updateVariables(String releaseId, List<com.xebialabs.xlrelease.domain.variables.Variable> variables) {
        return this.variableComponent.updateVariables(releaseId, variables);
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(String variableId, com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.variableComponent.updateVariable(variableId, variable);
    }

    @Timed
    public List<String> getPermissions() {
        return XLReleasePermissions.getTemplatePermissions();
    }

    @Timed
    public List<TeamView> getTeams(String templateId) {
        return this.teamFacade.getTeams(templateId);
    }

    @Timed
    public List<TeamView> setTeams(String templateId, List<TeamView> teamDtos) {
        return this.teamFacade.setTeams(templateId, teamDtos);
    }

    @Timed
    public Response exportTemplateToZip(String templateId) {
        this.permissions.checkView(templateId);
        Release release = this.releaseService.findById(templateId);
        Preconditions.checkArgument((boolean)release.isTemplate(), (Object)"Only templates can be exported.");
        this.teamService.decorateWithEffectiveTeams(release);
        this.releaseService.decorateRemovingUnnecessaryFields(release);
        StreamingOutput output = outputStream -> {
            WorkDirContext.initWorkdir((String)"export");
            try {
                this.templateExporter.exportTemplate(release, outputStream);
            }
            finally {
                WorkDirContext.get().delete();
                WorkDirContext.clear();
            }
        };
        String fileName = release.getTitle() + XLR_EXTENSION;
        return ResponseHelper.streamFile(fileName, output, APPLICATION_ZIP_MEDIA_TYPE);
    }

    @Timed
    public Release copyTemplate(String templateId, CopyTemplate copyTemplate) {
        Preconditions.checkArgument((boolean)copyTemplate.hasTitle(), (Object)"Template title is mandatory");
        Release template = this.releaseService.findById(templateId, ResolveOptions.WITH_DECORATORS());
        this.checkTemplatePermissions(Ids.isInRootFolder((String)template.getId()) ? null : Ids.findFolderId((String)template.getId()));
        return this.releaseService.copyTemplate(template.getId(), copyTemplate.getTitle(), copyTemplate.getDescription());
    }

    @Timed
    public Response downloadTemplateLogo(String logoId) throws IOException {
        File logoFile = this.templateMetadataService.getLogo(logoId);
        StreamingOutput output = stream -> {
            try (FileInputStream is = new FileInputStream(logoFile);){
                ByteStreams.copy((InputStream)is, (OutputStream)stream);
            }
            finally {
                stream.flush();
            }
        };
        String contentType = Files.probeContentType(logoFile.toPath());
        int maxAge = Long.valueOf(Duration.ofDays(1L).toSeconds()).intValue();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setMaxAge(maxAge);
        cacheControl.setPrivate(true);
        Instant lastModifiedInstant = Instant.ofEpochMilli(logoFile.lastModified());
        Date lastModifiedDate = Date.from(lastModifiedInstant);
        Response response = Response.ok((Object)output, (String)contentType).cacheControl(cacheControl).lastModified(lastModifiedDate).build();
        return response;
    }

    private void checkTemplatePermissions(String folderId) {
        if (Ids.isNullId((String)folderId)) {
            this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        } else {
            this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, folderId);
        }
    }
}

