package com.xebialabs.xlrelease.utils

import scala.util.{Failure, Success, Try}

object CloseableUtils {
  def using[A <: AutoCloseable, B](resource: A)(fn: A => B): B = {
    Try(fn(resource)) match {
      case Success(result) =>
        resource.close()
        result
      case Failure(e) =>
        resource.close()
        throw e
    }
  }
}
