/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.events.handlers;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.CreatedFromCreateReleaseTask;
import com.xebialabs.xlrelease.domain.events.ReleaseAbortedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCompletedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutionEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseFailedEvent;
import com.xebialabs.xlrelease.domain.events.ReleasePausedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseResumedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseRetriedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseStartedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseStartedFailingEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.IdType;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001B\u0006\r\u0001]A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)A\u0007\u0001C\u0001k!)!\b\u0001C\u0001w!)Q\n\u0001C\u0001\u001d\")A\u000b\u0001C\u0005+\")!\f\u0001C\u00057\"9q\u000eAI\u0001\n\u0013\u0001\b\"B>\u0001\t\u0013a\bbBA\u0001\u0001\u0011%\u00111\u0001\u0002\u0019\u0007J,\u0017\r^3SK2,\u0017m]3UCN\\\u0007*\u00198eY\u0016\u0014(BA\u0007\u000f\u0003!A\u0017M\u001c3mKJ\u001c(BA\b\u0011\u0003\u0019)g/\u001a8ug*\u0011\u0011CE\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0005\u000b\u0002\u0013a,'-[1mC\n\u001c(\"A\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Ab\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nQa\u001d7gi)T\u0011aI\u0001\tOJL'P\u001f7fI&\u0011Q\u0005\t\u0002\b\u0019><w-\u001b8h\u0003M\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f!\tA3&D\u0001*\u0015\tQ\u0003#\u0001\u0004bGR|'o]\u0005\u0003Y%\u00121CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\fa\u0002^1tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00020e5\t\u0001G\u0003\u00022!\u0005Q!/\u001a9pg&$xN]=\n\u0005M\u0002$A\u0004+bg.\u0014V\r]8tSR|'/_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007YB\u0014\b\u0005\u00028\u00015\tA\u0002C\u0003'\u0007\u0001\u0007q\u0005C\u0003.\u0007\u0001\u0007a&\u0001\tp]J+G.Z1tK\u000e\u0013X-\u0019;fIR\u0011Ah\u0010\t\u00033uJ!A\u0010\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0001\u0012\u0001\r!Q\u0001\u0006KZ,g\u000e\u001e\t\u0003\u0005\u001ak\u0011a\u0011\u0006\u0003\u001f\u0011S!!\u0012\t\u0002\r\u0011|W.Y5o\u0013\t95IA\nSK2,\u0017m]3De\u0016\fG/\u001a3Fm\u0016tG\u000f\u000b\u0002\u0005\u0013B\u0011!jS\u0007\u0002\u001d%\u0011AJ\u0004\u0002\n'V\u00147o\u0019:jE\u0016\fqc\u001c8SK2,\u0017m]3Fq\u0016\u001cW\u000f^5p]\u00163XM\u001c;\u0015\u0005qz\u0005\"\u0002!\u0006\u0001\u0004\u0001\u0006C\u0001\"R\u0013\t\u00116IA\u000bSK2,\u0017m]3Fq\u0016\u001cW\u000f^5p]\u00163XM\u001c;)\u0005\u0015I\u0015!\u00065b]\u0012dWMU3mK\u0006\u001cX-\u0012=fGV$X\r\u001a\u000b\u0003yYCQ\u0001\u0011\u0004A\u0002]\u0003\"A\u0011-\n\u0005e\u001b%\u0001\u0006*fY\u0016\f7/Z#yK\u000e,H/\u001a3Fm\u0016tG/A\u0006sK2,\u0017m]3MS:\\Gc\u0001/h[B\u0011Q\f\u001a\b\u0003=\n\u0004\"a\u0018\u000e\u000e\u0003\u0001T!!\u0019\f\u0002\rq\u0012xn\u001c;?\u0013\t\u0019'$\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u001a\u0014aa\u0015;sS:<'BA2\u001b\u0011\u0015Aw\u00011\u0001j\u0003\u001d\u0011X\r\\3bg\u0016\u0004\"A[6\u000e\u0003\u0011K!\u0001\u001c#\u0003\u000fI+G.Z1tK\"9an\u0002I\u0001\u0002\u0004a\u0016!\u0004:fY\u0016\f7/Z*uCR,8/A\u000bsK2,\u0017m]3MS:\\G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003ET#\u0001\u0018:,\u0003M\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\u0013Ut7\r[3dW\u0016$'B\u0001=\u001b\u0003)\tgN\\8uCRLwN\\\u0005\u0003uV\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003i)\b\u000fZ1uKB\u000b'/\u001a8u)\u0006\u001c8n\u0015;biV\u001cH*\u001b8f)\raTP \u0005\u0006Q&\u0001\r!\u001b\u0005\u0006\u007f&\u0001\r\u0001X\u0001\u0007gR\fG/^:\u0002'%\u001c8I]3bi\u0016\u0014V\r\\3bg\u0016$\u0016m]6\u0015\t\u0005\u0015\u00111\u0002\t\u00043\u0005\u001d\u0011bAA\u00055\t9!i\\8mK\u0006t\u0007BBA\u0007\u0015\u0001\u0007A,\u0001\u0004uCN\\\u0017\n\u001a\u0015\u0004\u0001\u0005E\u0001\u0003BA\n\u0003Ci!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\u000bgR,'/Z8usB,'\u0002BA\u000e\u0003;\tqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003?\t1a\u001c:h\u0013\u0011\t\u0019#!\u0006\u0003\u000fM+'O^5dK\"\u001a\u0001!a\n\u0011\u0007)\u000bI#C\u0002\u0002,9\u0011Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\b")
public class CreateReleaseTaskHandler
implements Logging {
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CreateReleaseTaskHandler createReleaseTaskHandler = this;
        synchronized (createReleaseTaskHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void onReleaseCreated(ReleaseCreatedEvent event) {
        ReleaseCreationSource releaseCreationSource = event.source();
        if (releaseCreationSource instanceof CreatedFromCreateReleaseTask) {
            this.updateParentTaskStatusLine(event.release(), "");
            return;
        }
    }

    @Subscribe
    public void onReleaseExecutionEvent(ReleaseExecutionEvent event) {
        Option parentTaskId = Option$.MODULE$.apply((Object)event.release().getStartedFromTaskId());
        if (parentTaskId.exists((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)CreateReleaseTaskHandler.$anonfun$onReleaseExecutionEvent$1(this, id)))) {
            ReleaseExecutionEvent releaseExecutionEvent = event;
            if (releaseExecutionEvent instanceof ReleaseStartedEvent) {
                ReleaseStartedEvent releaseStartedEvent = (ReleaseStartedEvent)releaseExecutionEvent;
                Release release = releaseStartedEvent.release();
                this.updateParentTaskStatusLine(release, "");
                return;
            }
            if (releaseExecutionEvent instanceof ReleasePausedEvent) {
                ReleasePausedEvent releasePausedEvent = (ReleasePausedEvent)releaseExecutionEvent;
                Release release = releasePausedEvent.release();
                this.updateParentTaskStatusLine(release, "Paused");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseResumedEvent) {
                ReleaseResumedEvent releaseResumedEvent = (ReleaseResumedEvent)releaseExecutionEvent;
                Release release = releaseResumedEvent.release();
                this.updateParentTaskStatusLine(release, "");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseFailedEvent) {
                ReleaseFailedEvent releaseFailedEvent = (ReleaseFailedEvent)releaseExecutionEvent;
                Release release = releaseFailedEvent.release();
                this.updateParentTaskStatusLine(release, "Failed");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseStartedFailingEvent) {
                ReleaseStartedFailingEvent releaseStartedFailingEvent = (ReleaseStartedFailingEvent)releaseExecutionEvent;
                Release release = releaseStartedFailingEvent.release();
                this.updateParentTaskStatusLine(release, "Failing");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseRetriedEvent) {
                ReleaseRetriedEvent releaseRetriedEvent = (ReleaseRetriedEvent)releaseExecutionEvent;
                Release release = releaseRetriedEvent.release();
                this.updateParentTaskStatusLine(release, "");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseExecutedEvent) {
                ReleaseExecutedEvent releaseExecutedEvent = (ReleaseExecutedEvent)releaseExecutionEvent;
                this.handleReleaseExecuted(releaseExecutedEvent);
                return;
            }
            throw new MatchError((Object)releaseExecutionEvent);
        }
    }

    private void handleReleaseExecuted(ReleaseExecutedEvent event) {
        ReleaseExecutedEvent releaseExecutedEvent = event;
        if (releaseExecutedEvent instanceof ReleaseAbortedEvent) {
            ReleaseAbortedEvent releaseAbortedEvent = (ReleaseAbortedEvent)releaseExecutedEvent;
            Release release = releaseAbortedEvent.release();
            String parentTaskId = release.getStartedFromTaskId();
            Try$.MODULE$.apply((Function0 & Serializable)() -> (CreateReleaseTask)$this.taskRepository.findById(parentTaskId, ResolveOptions$.MODULE$.WITHOUT_DECORATORS())).withFilter((Function1 & Serializable)parentTask -> BoxesRunTime.boxToBoolean((boolean)parentTask.getWaitForRelease())).foreach((Function1 & Serializable)parentTask -> {
                CreateReleaseTaskHandler.$anonfun$handleReleaseExecuted$3(this, release, parentTaskId, parentTask);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (releaseExecutedEvent instanceof ReleaseCompletedEvent) {
            ReleaseCompletedEvent releaseCompletedEvent = (ReleaseCompletedEvent)releaseExecutedEvent;
            Release release = releaseCompletedEvent.release();
            String parentTaskId = release.getStartedFromTaskId();
            Try$.MODULE$.apply((Function0 & Serializable)() -> (CreateReleaseTask)$this.taskRepository.findById(parentTaskId, ResolveOptions$.MODULE$.WITHOUT_DECORATORS())).withFilter((Function1 & Serializable)parentTask -> BoxesRunTime.boxToBoolean((boolean)parentTask.getWaitForRelease())).foreach((Function1 & Serializable)parentTask -> {
                CreateReleaseTaskHandler.$anonfun$handleReleaseExecuted$6(this, release, parentTaskId, parentTask);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)releaseExecutedEvent);
    }

    private String releaseLink(Release release, String releaseStatus) {
        Object status = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(releaseStatus)) ? releaseStatus + ":" : "";
        return "[" + (String)status + " " + release.getTitle() + "](#/releases/" + IdType.DOMAIN.convertToViewId(release.getId()) + ")";
    }

    private String releaseLink$default$2() {
        return "";
    }

    private void updateParentTaskStatusLine(Release release, String status) {
        String parentTaskId = release.getStartedFromTaskId();
        if (parentTaskId != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(parentTaskId))) {
            String msg = String.valueOf(this.releaseLink(release, status));
            this.releaseActorService.updateTaskStatusLine(parentTaskId, msg);
            return;
        }
    }

    private boolean isCreateReleaseTask(String taskId) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.taskRepository.getType(taskId));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String taskType = (String)success.value();
            return Type.valueOf(CreateReleaseTask.class).equals((Object)Type.valueOf((String)taskType));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$onReleaseExecutionEvent$1(CreateReleaseTaskHandler $this, String id) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(id)) && $this.isCreateReleaseTask(id);
    }

    public static final /* synthetic */ void $anonfun$handleReleaseExecuted$3(CreateReleaseTaskHandler $this, Release release$1, String parentTaskId$1, CreateReleaseTask parentTask) {
        String msg = "Release " + $this.releaseLink(release$1, $this.releaseLink$default$2()) + " was aborted.";
        $this.releaseActorService.failTaskAsync(parentTaskId$1, msg, User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$handleReleaseExecuted$6(CreateReleaseTaskHandler $this, Release release$2, String parentTaskId$2, CreateReleaseTask parentTask) {
        String msg = "Release " + $this.releaseLink(release$2, $this.releaseLink$default$2()) + " was completed.";
        $this.releaseActorService.markTaskAsDoneAsync(TaskStatus.COMPLETED, parentTaskId$2, msg, User.SYSTEM);
    }

    public CreateReleaseTaskHandler(ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
        Logging.$init$((Logging)this);
    }
}

