package com.xebialabs.xlrelease.db

import com.xebialabs.xlplatform.utils.ManagedResource

import scala.language.implicitConversions


package object sql {

  case class Sql(sql: String, parameters: Iterable[AnyRef])

  type SqlWithParameters = (String, Seq[AnyRef])

  class ManagedAutoCloseable[T <: AutoCloseable](out: T) extends ManagedResource[T] {
    def onEnter(): T = out

    def onExit(exceptionHappened: Boolean): Unit = {
      attempt(out.close())
    }
  }

  implicit def autoclosable2managed[T <: AutoCloseable](out: T): ManagedResource[T] = new ManagedAutoCloseable(out)
}
