/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.events.handlers;

import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseAbortedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCompletedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutionEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.IdType;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005y4A!\u0003\u0006\u0001+!AA\u0005\u0001BC\u0002\u0013\u0005Q\u0005\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003'\u0011!i\u0003A!A!\u0002\u0013q\u0003\"\u0002\u001b\u0001\t\u0003)\u0004\"\u0002\u001e\u0001\t\u0003Y\u0004\"B'\u0001\t\u0013q\u0005\"B*\u0001\t\u0013!\u0006\"\u00024\u0001\t\u00139'\u0001G\"sK\u0006$XMU3mK\u0006\u001cX\rV1tW\"\u000bg\u000e\u001a7fe*\u00111\u0002D\u0001\tQ\u0006tG\r\\3sg*\u0011QBD\u0001\u0007KZ,g\u000e^:\u000b\u0005=\u0001\u0012!\u0003=me\u0016dW-Y:f\u0015\t\t\"#A\u0005yK\nL\u0017\r\\1cg*\t1#A\u0002d_6\u001c\u0001aE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\t\u0013\u0001C4sSjTH.\u001a3\n\u0005\rr\"a\u0002'pO\u001eLgnZ\u0001\u0014e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u000b\u0002MA\u0011qEK\u0007\u0002Q)\u0011\u0011FD\u0001\u0007C\u000e$xN]:\n\u0005-B#a\u0005*fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0017\u0001\u0006:fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0007%\u0001\buCN\\'+\u001a9pg&$xN]=\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005Er\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u00111\u0007\r\u0002\u000f)\u0006\u001c8NU3q_NLGo\u001c:z\u0003\u0019a\u0014N\\5u}Q\u0019a\u0007O\u001d\u0011\u0005]\u0002Q\"\u0001\u0006\t\u000b\u0011\"\u0001\u0019\u0001\u0014\t\u000b5\"\u0001\u0019\u0001\u0018\u0002/=t'+\u001a7fCN,W\t_3dkRLwN\\#wK:$HC\u0001\u001f@!\t9R(\u0003\u0002?1\t!QK\\5u\u0011\u0015\u0001U\u00011\u0001B\u0003\u0015)g/\u001a8u!\t\u0011e)D\u0001D\u0015\tiAI\u0003\u0002F\u001d\u00051Am\\7bS:L!aR\"\u0003+I+G.Z1tK\u0016CXmY;uS>tWI^3oi\"\u0012Q!\u0013\t\u0003\u0015.k\u0011\u0001D\u0005\u0003\u00192\u0011\u0011bU;cg\u000e\u0014\u0018NY3\u0002+!\fg\u000e\u001a7f%\u0016dW-Y:f\u000bb,7-\u001e;fIR\u0011Ah\u0014\u0005\u0006\u0001\u001a\u0001\r\u0001\u0015\t\u0003\u0005FK!AU\"\u0003)I+G.Z1tK\u0016CXmY;uK\u0012,e/\u001a8u\u0003-\u0011X\r\\3bg\u0016d\u0015N\\6\u0015\u0005U\u0003\u0007C\u0001,^\u001d\t96\f\u0005\u0002Y15\t\u0011L\u0003\u0002[)\u00051AH]8pizJ!\u0001\u0018\r\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039bAQ!Y\u0004A\u0002\t\fqA]3mK\u0006\u001cX\r\u0005\u0002dI6\tA)\u0003\u0002f\t\n9!+\u001a7fCN,\u0017\u0001E<ji\"\u0004\u0016M]3oiR\u000b7o[%e)\tAg\u000e\u0006\u0002=S\")!\u000e\u0003a\u0001W\u0006)!\r\\8dWB!q\u0003\\+=\u0013\ti\u0007DA\u0005Gk:\u001cG/[8oc!)\u0011\r\u0003a\u0001E\"\u0012\u0001\u0001\u001d\t\u0003cbl\u0011A\u001d\u0006\u0003gR\f!b\u001d;fe\u0016|G/\u001f9f\u0015\t)h/A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u00059\u0018aA8sO&\u0011\u0011P\u001d\u0002\b'\u0016\u0014h/[2fQ\t\u00011\u0010\u0005\u0002Ky&\u0011Q\u0010\u0004\u0002\u000e\u000bZ,g\u000e\u001e'jgR,g.\u001a:")
public class CreateReleaseTaskHandler
implements Logging {
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CreateReleaseTaskHandler createReleaseTaskHandler = this;
        synchronized (createReleaseTaskHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    @Subscribe
    public void onReleaseExecutionEvent(ReleaseExecutionEvent event) {
        String parentTaskId = event.release().getStartedFromTaskId();
        if (parentTaskId != null) {
            try {
                ReleaseExecutionEvent releaseExecutionEvent = event;
                if (releaseExecutionEvent instanceof ReleaseExecutedEvent) {
                    ReleaseExecutedEvent releaseExecutedEvent = (ReleaseExecutedEvent)releaseExecutionEvent;
                    this.handleReleaseExecuted(releaseExecutedEvent);
                }
            }
            catch (Throwable e) {
                this.logger().error((Function0 & Serializable)() -> "Unable to handle release execution event " + event, (Function0 & Serializable)() -> e);
            }
            return;
        }
    }

    private void handleReleaseExecuted(ReleaseExecutedEvent event) {
        ReleaseExecutedEvent releaseExecutedEvent = event;
        if (releaseExecutedEvent instanceof ReleaseAbortedEvent) {
            ReleaseAbortedEvent releaseAbortedEvent = (ReleaseAbortedEvent)releaseExecutedEvent;
            Release release = releaseAbortedEvent.release();
            this.withParentTaskId(release, (Function1<String, BoxedUnit>)(Function1 & Serializable)parentTaskId -> {
                CreateReleaseTaskHandler.$anonfun$handleReleaseExecuted$1(this, release, parentTaskId);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (releaseExecutedEvent instanceof ReleaseCompletedEvent) {
            ReleaseCompletedEvent releaseCompletedEvent = (ReleaseCompletedEvent)releaseExecutedEvent;
            Release release = releaseCompletedEvent.release();
            this.withParentTaskId(release, (Function1<String, BoxedUnit>)(Function1 & Serializable)parentTaskId -> {
                CreateReleaseTaskHandler.$anonfun$handleReleaseExecuted$2(this, release, parentTaskId);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)releaseExecutedEvent);
    }

    private String releaseLink(Release release) {
        return "[" + release.getTitle() + "](#/releases/" + IdType.DOMAIN.convertToViewId(release.getId()) + ")";
    }

    private void withParentTaskId(Release release, Function1<String, BoxedUnit> block) {
        String parentTaskId = release.getStartedFromTaskId();
        if (parentTaskId == null) {
            this.logger().error((Function0 & Serializable)() -> "Release " + release.getId() + " was marked as started from another task, but Id of that task was null");
            return;
        }
        block.apply((Object)parentTaskId);
    }

    public static final /* synthetic */ void $anonfun$handleReleaseExecuted$1(CreateReleaseTaskHandler $this, Release release$1, String parentTaskId) {
        CreateReleaseTask parentTask = (CreateReleaseTask)$this.taskRepository.findById(parentTaskId, ResolveOptions$.MODULE$.WITHOUT_DECORATORS());
        if (parentTask.getWaitForRelease()) {
            String msg = "Release " + $this.releaseLink(release$1) + " was aborted";
            $this.releaseActorService().failTaskAsync(parentTaskId, msg, User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)None$.MODULE$);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleReleaseExecuted$2(CreateReleaseTaskHandler $this, Release release$2, String parentTaskId) {
        CreateReleaseTask parentTask = (CreateReleaseTask)$this.taskRepository.findById(parentTaskId, ResolveOptions$.MODULE$.WITHOUT_DECORATORS());
        if (parentTask.getWaitForRelease()) {
            String msg = "Release " + $this.releaseLink(release$2) + " was completed";
            $this.releaseActorService().markTaskAsDoneAsync(TaskStatus.COMPLETED, parentTaskId, msg, User.SYSTEM);
            return;
        }
    }

    public CreateReleaseTaskHandler(ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
        Logging.$init$((Logging)this);
    }
}

