package com.xebialabs.xlrelease.variable

import com.xebialabs.deployit.plugin.api.reflect.{DescriptorRegistry, Type}
import com.xebialabs.xlrelease.domain.configuration.HttpConnection
import com.xebialabs.xlrelease.domain.variables._
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class HttpConnectionValueProvider(val configurationRepository: ConfigurationRepository) extends ConfigurationValueProvider[HttpConnection] {

  override def getSupportedTypes(): Seq[ReferencedType] = {
    DescriptorRegistry.getSubtypes(Type.valueOf(classOf[HttpConnection])).asScala
      .filterNot(_.getDescriptor.isVirtual)
      .map(t => new ReferencedType(t.toString, t.getDescriptor.getLabel))
      .toSeq
  }

}
