package com.xebialabs.xlrelease.security.authentication.policy

import org.springframework.security.core.Authentication

trait UserGroupMembershipCreationPolicy {

  /** Order of iteration. */
  def order(): Int

  /**
   * Should this policy be used to create the user group membership.
   *
   * @param authentication succeeded authentication
   * @return evaluation result
   */
  def policyApplies(authentication: Authentication): Boolean

  /**
   * Create or update user group membership if needed.
   *
   * @param authentication succeeded authentication
   */
  def updateUserGroupMembership(authentication: Authentication): Unit
}
