package com.xebialabs.xlrelease.actors

import com.xebialabs.xlrelease.actors.initializer.ActorInitializerOrder.MANAGED_ACTOR_REGISTRY
import com.xebialabs.xlrelease.actors.initializer.ManagedActorInitializer

import java.util.concurrent.ConcurrentHashMap

trait ManagedActorRegistry extends ManagedActorInitializer

object ManagedActorRegistry extends ManagedActorRegistry {

  private val holders: ConcurrentHashMap[String, ManagedActor[_]] = new ConcurrentHashMap

  override def doStart(): Unit = {
    holders.values.forEach(_.initialize())
  }

  override def doStop(): Unit = {
    reset()
  }

  override def getOrder: Int = MANAGED_ACTOR_REGISTRY

  def put(name: String, holder: ManagedActor[_]): Unit = {
    // if managed actor with that name already exist we should throw exception
    // if there is justified need to check for existing holder by name then add missing methods
    if (holders.containsKey(name)) {
      throw new IllegalStateException(s"Singleton actor '$name' was already created")
    }
    holders.put(name, holder)
    if (isRunning) {
      holder.initialize()
    }
  }

  private def reset(): Unit = {
    this.holders.values().forEach(_.reset())
  }

  // this method must be used only in tests to cleanup
  private[actors] def destroy(): Unit = {
    stop()
    holders.clear()
  }

  // this method must be used only in tests to cleanup
  private[actors] def remove(name: String): Unit = {
    holders.remove(name)
  }

}
