package com.xebialabs.xlrelease.domain.tasks.group;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.converters.BaseTaskViewConverter;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;

import static java.util.stream.Collectors.toList;

abstract class TaskGroupViewConverter<T extends TaskGroup> extends BaseTaskViewConverter<T> {

    @Autowired
    @Lazy
    private TasksViewConverter tasksViewConverter;

    @Override
    public TaskFullView toFullView(final T task, final List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskFullView v = super.toFullView(task, allowedTaskTypesForAuthenticatedUser);
        v.setTasks(task.getTasks().stream()
                .map(subtask -> tasksViewConverter.toFullView(subtask, allowedTaskTypesForAuthenticatedUser))
                .collect(toList()));
        return v;
    }
}
