/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseAbortedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCompletedEvent;
import com.xebialabs.xlrelease.domain.management.ServiceStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.scheduler.RestartableScheduledExecutorService;
import com.xebialabs.xlrelease.scheduler.XlrExecutors$;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.XlrServiceLifecycle;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.Serializable;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\t\u001da\u0001\u0002\u0010 \u0001!B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\"\u00020\u0001\t\u0003y\u0006\u0002\u00034\u0001\u0011\u000b\u0007I\u0011B4\t\u000f-\u0004!\u0019!C\u0005Y\"11\u000f\u0001Q\u0001\n5Dq\u0001\u001e\u0001A\u0002\u0013%Q\u000fC\u0004z\u0001\u0001\u0007I\u0011\u0002>\t\u000f\u0005\u0005\u0001\u0001)Q\u0005m\"A\u00111\u0001\u0001A\u0002\u0013%Q\u000fC\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0003\u0002\b!9\u00111\u0002\u0001!B\u00131\bBBA\u0007\u0001\u0011\u0005Q\u000fC\u0004\u0002\u0010\u0001!\t%!\u0005\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016!9\u0011q\u0003\u0001\u0005B\u0005U\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\tY\u0005\u0001C\t\u0003\u001bB\u0011\"!\u001d\u0001#\u0003%\t\"a\u001d\t\u0013\u0005\u001d\u0005!%A\u0005\u0012\u0005M\u0004bBAE\u0001\u0011%\u0011Q\u0003\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011%\ti\nAI\u0001\n\u0013\ty\nC\u0004\u0002$\u0002!I!!*\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\n\t\u0002K]3Be\u000eD\u0017N^3TKJ4\u0018nY3\u000b\u0005\u0001\n\u0013aB:feZL7-\u001a\u0006\u0003E\r\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u0011*\u0013!\u0003=fE&\fG.\u00192t\u0015\u00051\u0013aA2p[\u000e\u00011\u0003\u0002\u0001*_]\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012a!\u00118z%\u00164\u0007C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005!\u0014\u0001C4sSjTH.\u001a3\n\u0005Y\n$a\u0002'pO\u001eLgn\u001a\t\u0003qej\u0011aH\u0005\u0003u}\u00111\u0003\u00177s'\u0016\u0014h/[2f\u0019&4WmY=dY\u0016\f\u0011\u0002\u001f7s\u0007>tg-[4\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\n\u0013AB2p]\u001aLw-\u0003\u0002B}\tI\u0001\f\u001c:D_:4\u0017nZ\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u0004\"\u0001\u000f#\n\u0005\u0015{\"\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\u0006\n!B]3q_NLGo\u001c:z\u0013\ta\u0015JA\tSK2,\u0017m]3SKB|7/\u001b;pef\fq\"\u0019:dQ&4\u0018N\\4D_:4\u0017n\u001a\t\u0003{=K!\u0001\u0015 \u00031\u0005\u00138\r[5wS:<7+\u001a;uS:<7/T1oC\u001e,'/A\u0007nKR,'OU3hSN$(/\u001f\t\u0003'rk\u0011\u0001\u0016\u0006\u0003+Z\u000b!\"\u001b8tiJ,X.\u001a8u\u0015\t9\u0006,\u0001\u0003d_J,'BA-[\u0003)i\u0017n\u0019:p[\u0016$XM\u001d\u0006\u00027\u0006\u0011\u0011n\\\u0005\u0003;R\u0013Q\"T3uKJ\u0014VmZ5tiJL\u0018A\u0002\u001fj]&$h\b\u0006\u0004aC\n\u001cG-\u001a\t\u0003q\u0001AQa\u000f\u0004A\u0002qBQA\u0011\u0004A\u0002\rCQA\u0012\u0004A\u0002\u001dCQ!\u0014\u0004A\u00029CQ!\u0015\u0004A\u0002I\u000ba\"\\1y)\"\u0014X-\u00193D_VtG/F\u0001i!\tQ\u0013.\u0003\u0002kW\t\u0019\u0011J\u001c;\u0002\tA|w\u000e\\\u000b\u0002[B\u0011a.]\u0007\u0002_*\u0011\u0001/I\u0001\ng\u000eDW\rZ;mKJL!A]8\u0003GI+7\u000f^1si\u0006\u0014G.Z*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u0006)\u0001o\\8mA\u00059QM\\1cY\u0016$W#\u0001<\u0011\u0005):\u0018B\u0001=,\u0005\u001d\u0011un\u001c7fC:\f1\"\u001a8bE2,Gm\u0018\u0013fcR\u00111P \t\u0003UqL!!`\u0016\u0003\tUs\u0017\u000e\u001e\u0005\b\u007f.\t\t\u00111\u0001w\u0003\rAH%M\u0001\tK:\f'\r\\3eA\u0005Q1-\u0019;dQ&tw-\u00169\u0002\u001d\r\fGo\u00195j]\u001e,\u0006o\u0018\u0013fcR\u001910!\u0003\t\u000f}t\u0011\u0011!a\u0001m\u0006Y1-\u0019;dQ&tw-\u00169!\u0003%I7/\u00128bE2,G-\u0001\u0005hKR|%\u000fZ3s)\u0005A\u0017a\u00023p'R\f'\u000f\u001e\u000b\u0002w\u00061Am\\*u_B\f!\u0004\u001d:f\u0003J\u001c\u0007.\u001b<f\u0007>l\u0007\u000f\\3uK\u0012\u0014V\r\\3bg\u0016$2a_A\u000f\u0011\u001d\ty\u0002\u0006a\u0001\u0003C\tQ!\u001a<f]R\u0004B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0004fm\u0016tGo\u001d\u0006\u0004\u0003W\t\u0013A\u00023p[\u0006Lg.\u0003\u0003\u00020\u0005\u0015\"!\u0006*fY\u0016\f7/Z\"p[BdW\r^3e\u000bZ,g\u000e\u001e\u0015\u0004)\u0005M\u0002\u0003BA\u001b\u0003si!!a\u000e\u000b\u0007\u0005\u001d\u0012%\u0003\u0003\u0002<\u0005]\"!C*vEN\u001c'/\u001b2f\u0003a\u0001(/Z!sG\"Lg/Z!c_J$X\r\u001a*fY\u0016\f7/\u001a\u000b\u0004w\u0006\u0005\u0003bBA\u0010+\u0001\u0007\u00111\t\t\u0005\u0003G\t)%\u0003\u0003\u0002H\u0005\u0015\"a\u0005*fY\u0016\f7/Z!c_J$X\rZ#wK:$\bfA\u000b\u00024\u0005Q\u0001O]3Be\u000eD\u0017N^3\u0015\u000fm\fy%a\u0017\u0002`!9\u0011\u0011\u000b\fA\u0002\u0005M\u0013a\u0002:fY\u0016\f7/\u001a\t\u0005\u0003+\n9&\u0004\u0002\u0002*%!\u0011\u0011LA\u0015\u0005\u001d\u0011V\r\\3bg\u0016D\u0001\"!\u0018\u0017!\u0003\u0005\rA^\u0001\rG\",7m[#oC\ndW\r\u001a\u0005\t\u0003C2\u0002\u0013!a\u0001m\u0006y!/Z2pm\u0016\u0014\u0018JZ#ySN$8\u000fK\u0002\u0017\u0003K\u0002B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003W2\u0016AC1o]>$\u0018\r^5p]&!\u0011qNA5\u0005\u0015!\u0016.\\3e\u0003Q\u0001(/Z!sG\"Lg/\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u000f\u0016\u0004m\u0006]4FAA=!\u0011\tY(a!\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-4&\u0003\u0003\u0002\u0006\u0006u$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!\u0002O]3Be\u000eD\u0017N^3%I\u00164\u0017-\u001e7uIM\na\u0005\u001d:f\u0003J\u001c\u0007.\u001b<f\u0013:\f7\r^5wKJ+G.Z1tKNLeNQ1dW\u001e\u0014x.\u001e8e\u0003i\u0001(/Z!sG\"Lg/Z%oC\u000e$\u0018N^3SK2,\u0017m]3t)\rY\u0018q\u0012\u0005\t\u0003#S\u0002\u0013!a\u0001Q\u0006!\u0001/Y4fQ\rQ\u0012Q\u0013\t\u0005\u0003/\u000bI*\u0004\u0002\u0002\u0002&!\u00111TAA\u0005\u001d!\u0018-\u001b7sK\u000e\fA\u0005\u001d:f\u0003J\u001c\u0007.\u001b<f\u0013:\f7\r^5wKJ+G.Z1tKN$C-\u001a4bk2$H%M\u000b\u0003\u0003CS3\u0001[A<\u0003\u0019\u0019XOY7jiV!\u0011qUA\\)\rY\u0018\u0011\u0016\u0005\b\u0003Wc\u0002\u0019AAW\u0003\rQwN\u0019\t\u0006U\u0005=\u00161W\u0005\u0004\u0003c[#!\u0003$v]\u000e$\u0018n\u001c81!\u0011\t),a.\r\u0001\u00119\u0011\u0011\u0018\u000fC\u0002\u0005m&!A+\u0012\t\u0005u\u00161\u0019\t\u0004U\u0005}\u0016bAAaW\t9aj\u001c;iS:<\u0007c\u0001\u0016\u0002F&\u0019\u0011qY\u0016\u0003\u0007\u0005s\u00170\u0001\u0005sk:t\u0017M\u00197f+\u0011\ti-a:\u0015\t\u0005=\u0017q\u001c\t\u0005\u0003#\fY.\u0004\u0002\u0002T*!\u0011Q[Al\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0017\u0001\u00026bm\u0006LA!!8\u0002T\nA!+\u001e8oC\ndW\rC\u0004\u0002bv\u0001\r!a9\u0002\t\t|G-\u001f\t\u0006U\u0005=\u0016Q\u001d\t\u0005\u0003k\u000b9\u000fB\u0004\u0002:v\u0011\r!a/)\u0007\u0001\tY\u000f\u0005\u0003\u0002n\u0006mXBAAx\u0015\u0011\t\t0a=\u0002\u0015M$XM]3pif\u0004XM\u0003\u0003\u0002v\u0006]\u0018aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005e\u0018aA8sO&!\u0011Q`Ax\u0005\u001d\u0019VM\u001d<jG\u0016D3\u0001\u0001B\u0001!\u0011\t)Da\u0001\n\t\t\u0015\u0011q\u0007\u0002\u000e\u000bZ,g\u000e\u001e'jgR,g.\u001a:")
public class PreArchiveService
implements XlrServiceLifecycle {
    private int maxThreadCount;
    private XlrConfig xlrConfig;
    private final ArchivingService archivingService;
    private final ReleaseRepository releaseRepository;
    private final ArchivingSettingsManager archivingConfig;
    private final RestartableScheduledExecutorService pool;
    private boolean enabled;
    private boolean catchingUp;
    private Enumeration.Value state;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String serviceName() {
        return XlrServiceLifecycle.serviceName$(this);
    }

    @Override
    public void start() {
        XlrServiceLifecycle.start$(this);
    }

    @Override
    public void awaitStart() {
        XlrServiceLifecycle.awaitStart$(this);
    }

    @Override
    public void stop() {
        XlrServiceLifecycle.stop$(this);
    }

    @Override
    public void awaitStop() {
        XlrServiceLifecycle.awaitStop$(this);
    }

    @Override
    public boolean isRunning() {
        return XlrServiceLifecycle.isRunning$(this);
    }

    @Override
    public ServiceStatus serviceStatus() {
        return XlrServiceLifecycle.serviceStatus$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Enumeration.Value state() {
        return this.state;
    }

    @Override
    public void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PreArchiveService preArchiveService = this;
        synchronized (preArchiveService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private int maxThreadCount$lzycompute() {
        PreArchiveService preArchiveService = this;
        synchronized (preArchiveService) {
            if (!this.bitmap$0) {
                this.maxThreadCount = this.xlrConfig.executors().preArchivingExecutor().maxThreadsCount();
                this.bitmap$0 = true;
            }
        }
        this.xlrConfig = null;
        return this.maxThreadCount;
    }

    private int maxThreadCount() {
        if (!this.bitmap$0) {
            return this.maxThreadCount$lzycompute();
        }
        return this.maxThreadCount;
    }

    private RestartableScheduledExecutorService pool() {
        return this.pool;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private boolean catchingUp() {
        return this.catchingUp;
    }

    private void catchingUp_$eq(boolean x$1) {
        this.catchingUp = x$1;
    }

    public boolean isEnabled() {
        return this.enabled();
    }

    public int getOrder() {
        return 46;
    }

    @Override
    public void doStart() {
        this.pool().start();
        this.logger().trace((Function0 & Serializable)() -> "Setting preArchivingEnabled callback...");
        this.archivingConfig.subscribeToPreArchivingEnabledChanges(becomesEnabled -> {
            PreArchiveService preArchiveService = this;
            synchronized (preArchiveService) {
                if (Predef$.MODULE$.Boolean2boolean(becomesEnabled)) {
                    this.logger().trace((Function0 & Serializable)() -> "disabled -> enabled");
                    this.enabled_$eq(true);
                    this.preArchiveInactiveReleasesInBackground();
                } else {
                    this.logger().trace((Function0 & Serializable)() -> "enabled -> disabled");
                    this.enabled_$eq(false);
                }
            }
        });
        this.enabled_$eq(this.archivingConfig.getPreArchivingEnabled());
        if (this.enabled()) {
            this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
        }
        this.logger().debug((Function0 & Serializable)() -> "PreArchiveService started.");
    }

    @Override
    public void doStop() {
        this.pool().stop();
    }

    @Subscribe
    public void preArchiveCompletedRelease(ReleaseCompletedEvent event) {
        this.preArchive(event.release(), this.preArchive$default$2(), this.preArchive$default$3());
    }

    @Subscribe
    public void preArchiveAbortedRelease(ReleaseAbortedEvent event) {
        this.preArchive(event.release(), this.preArchive$default$2(), this.preArchive$default$3());
    }

    @Timed
    public void preArchive(Release release, boolean checkEnabled, boolean recoverIfExists) {
        if (!checkEnabled || this.enabled() && !this.catchingUp()) {
            this.submit((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                try {
                    this.logger().info((Function0 & Serializable)() -> "Pre-archiving " + release);
                    $this.archivingService.preArchiveRelease(release);
                    this.logger().debug((Function0 & Serializable)() -> "Pre-archived " + release);
                }
                catch (Exception e) {
                    this.logger().warn((Function0 & Serializable)() -> "Something went wrong while pre-archiving", (Function0 & Serializable)() -> e);
                    if (!recoverIfExists) {
                        throw e;
                    }
                    if ($this.archivingService.exists(release.getId())) {
                        this.logger().debug((Function0 & Serializable)() -> "Removing " + release + " from Archive Database");
                        if ($this.archivingService.deletePreArchiveRelease(release.getId())) {
                            this.logger().debug((Function0 & Serializable)() -> "Pre-archiving again " + release);
                            this.preArchive(release, checkEnabled, false);
                        } else {
                            this.logger().debug((Function0 & Serializable)() -> "Removing failed " + release + " from Archive Database");
                        }
                    }
                    this.logger().debug((Function0 & Serializable)() -> "Release " + release + " does not exist in Archive Database", (Function0 & Serializable)() -> e);
                    throw e;
                }
            });
            return;
        }
        this.logger().debug((Function0 & Serializable)() -> "Pre-archiving is disabled");
    }

    public boolean preArchive$default$2() {
        return true;
    }

    public boolean preArchive$default$3() {
        return true;
    }

    private synchronized void preArchiveInactiveReleasesInBackground() {
        if (!this.catchingUp()) {
            this.catchingUp_$eq(true);
            this.submit((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
                this.catchingUp_$eq(false);
            });
            return;
        }
    }

    private void preArchiveInactiveReleases(int page) {
        while (true) {
            Integer pageSize = this.archivingConfig.getSearchPageSize();
            this.logger().debug((Function0 & Serializable)() -> "Fetching page " + page + " (" + pageSize + " releases) for pre-archiving...");
            Seq<Release> found = this.releaseRepository.findPreArchivableReleases(page, Predef$.MODULE$.Integer2int(pageSize));
            ((IterableOnceOps)found.filter((Function1 & Serializable)release -> BoxesRunTime.boxToBoolean((boolean)this.archivingService.shouldArchive(release)))).foreach((Function1 & Serializable)x$1 -> {
                this.preArchive(x$1, false, this.preArchive$default$3());
                return BoxedUnit.UNIT;
            });
            if (!this.enabled() || !BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)found.size()), (Object)pageSize)) break;
            ++page;
        }
    }

    private int preArchiveInactiveReleases$default$1() {
        return 0;
    }

    private <U> void submit(Function0<U> job) {
        if (this.pool().isActive()) {
            try {
                this.pool().submit(this.runnable(job));
            }
            catch (RejectedExecutionException e) {
                this.logger().warn((Function0 & Serializable)() -> "Unable to submit a job to " + this.pool().name(), (Function0 & Serializable)() -> e);
            }
            return;
        }
        this.logger().warn((Function0 & Serializable)() -> "Pool " + this.pool().name() + " is " + this.pool().state() + ". Cannot process job.");
    }

    private <U> Runnable runnable(Function0<U> body) {
        return () -> body.apply();
    }

    public PreArchiveService(XlrConfig xlrConfig, ArchivingService archivingService, ReleaseRepository releaseRepository, ArchivingSettingsManager archivingConfig, MeterRegistry meterRegistry) {
        this.xlrConfig = xlrConfig;
        this.archivingService = archivingService;
        this.releaseRepository = releaseRepository;
        this.archivingConfig = archivingConfig;
        Logging.$init$((Logging)this);
        XlrServiceLifecycle.$init$(this);
        this.pool = XlrExecutors$.MODULE$.newScheduledThreadPool("pre-archiving", this.maxThreadCount(), meterRegistry, XlrExecutors$.MODULE$.newScheduledThreadPool$default$4());
        this.enabled = false;
        this.catchingUp = false;
    }
}

