package com.xebialabs.xlrelease.spring.configuration

import com.xebialabs.xlrelease.config.XlrConfig
import ExecutorNames._
import com.xebialabs.xlrelease.scheduler.RestartableExecutorService.DEFAULT_SHUTDOWN_TIMEOUT
import com.xebialabs.xlrelease.scheduler.{ExecutorsRegistry, RestartableExecutorService, RestartableScheduledExecutorService, XlrExecutors}
import io.micrometer.core.instrument.MeterRegistry
import org.springframework.context.annotation.{Bean, Configuration};

@Configuration
class ExecutorsConfiguration(xlrConfig: XlrConfig, meterRegistry: MeterRegistry) {

  @Bean
  def executorsRegistry: ExecutorsRegistry.type = ExecutorsRegistry

  @Bean(Array(TASK_EXECUTION_EXECUTOR_NAME))
  def taskExecution: RestartableExecutorService = {
    val maxThreadsCount: Int = xlrConfig.executors.scheduler.maxThreadsCount
    XlrExecutors.newFixedThreadPool(TASK_EXECUTION_EXECUTOR_NAME, maxThreadsCount, meterRegistry, xlrConfig.taskSchedulerGraceShutdownPeriod)
  }

  @Bean(Array(RELEASE_TRIGGER_EXECUTOR_NAME))
  def triggerExecutor: RestartableScheduledExecutorService = {
    val maxThreadsCount: Int = xlrConfig.executors.releaseTrigger.maxThreadsCount
    XlrExecutors.newScheduledThreadPool(RELEASE_TRIGGER_EXECUTOR_NAME, maxThreadsCount, meterRegistry, DEFAULT_SHUTDOWN_TIMEOUT)
  }

  @Bean(Array(QUARTZ_JOB_EXECUTOR_NAME))
  def quartzJobExecutor: RestartableScheduledExecutorService = {
    val maxThreadsCount: Int = xlrConfig.executors.quartzJobExecutor.maxThreadsCount
    XlrExecutors.newScheduledThreadPool(QUARTZ_JOB_EXECUTOR_NAME, maxThreadsCount, meterRegistry, DEFAULT_SHUTDOWN_TIMEOUT)
  }

  @Bean(Array(TIMEOUT_EXECUTOR_NAME))
  def timeoutExecutor: RestartableScheduledExecutorService = {
    lazy val maxThreadsCount: Int = xlrConfig.executors.timeoutExecutor.maxThreadsCount
    XlrExecutors.newScheduledThreadPool(TIMEOUT_EXECUTOR_NAME, maxThreadsCount, meterRegistry, DEFAULT_SHUTDOWN_TIMEOUT)
  }

  @Bean(Array(POLLING_EXECUTOR_NAME))
  def pollingExecutor: RestartableScheduledExecutorService = {
    lazy val maxThreadsCount: Int = xlrConfig.executors.pollingExecutor.maxThreadsCount
    XlrExecutors.newScheduledThreadPool(POLLING_EXECUTOR_NAME, maxThreadsCount, meterRegistry, DEFAULT_SHUTDOWN_TIMEOUT)
  }

  @Bean(Array(LOG_FLUSH_EXECUTOR_NAME))
  def logFlushExecutor: RestartableScheduledExecutorService = {
    lazy val maxThreadsCount: Int = xlrConfig.executors.logFlushExecutor.maxThreadsCount
    XlrExecutors.newScheduledThreadPool(LOG_FLUSH_EXECUTOR_NAME, maxThreadsCount, meterRegistry, DEFAULT_SHUTDOWN_TIMEOUT)
  }

  @Bean(Array(AUXILIARY_EXECUTOR_NAME))
  def auxiliaryExecutor: RestartableScheduledExecutorService = {
    lazy val maxThreadsCount: Int = xlrConfig.executors.auxiliaryExecutor.maxThreadsCount
    XlrExecutors.newScheduledThreadPool(AUXILIARY_EXECUTOR_NAME, maxThreadsCount, meterRegistry, DEFAULT_SHUTDOWN_TIMEOUT)
  }

  // TODO missing executor services:
  //  - "pre-archiving"
  //  - "report-executor"
  //  - "risk-calculation"
  //  - "risk-calculation-batch"

}