package com.xebialabs.xlrelease.service

import com.xebialabs.xlplatform.cluster.ClusterMode._
import com.xebialabs.xlrelease.actors.BroadcastEventActor.PublishEvent
import com.xebialabs.xlrelease.actors.{ActorSystemHolder, BroadcastEventActor}
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent
import com.xebialabs.xlrelease.events.EventBus
import org.springframework.context.annotation.Profile
import org.springframework.stereotype.Component

trait BroadcastService {
  def broadcast(event: DistributedXLReleaseEvent, publishEventOnSelf: Boolean): Unit
}

@Component
@Profile(Array(FULL))
class ClusterBroadcastService(actorSystemHolder: ActorSystemHolder) extends BroadcastService {

  private lazy val broadcastEventActor = actorSystemHolder.actorOf(classOf[BroadcastEventActor], "broadcastEventActor")

  override def broadcast(event: DistributedXLReleaseEvent, publishEventOnSelf: Boolean): Unit = {
    if (actorSystemHolder.isActorSystemInitialized && broadcastEventActor.isInitialized) {
      broadcastEventActor ! PublishEvent(event, publishEventOnSelf)
    }
    // TODO There is a problem with startup sequence:
    //  system runs template importers (or services or something) that rely on this broadcast service to be present,
    //  but actor system is started way later so broadcast service is not really available
    //  if actor is not initialized we still want to publish event on the local event bus or stash it or do something with it!
  }
}

@Component
@Profile(Array(STANDALONE, HOT_STANDBY))
class NonClusteredBroadcastService(eventBus: EventBus) extends BroadcastService {

  override def broadcast(event: DistributedXLReleaseEvent, publishEventOnSelf: Boolean): Unit = {
    if (publishEventOnSelf) eventBus.publish(event)
  }

}
