package com.xebialabs.xlrelease.scheduler

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.metrics.MetricsConfiguration.TAG_EXECUTOR
import com.xebialabs.xlrelease.scheduler.RestartableExecutorService.DEFAULT_SHUTDOWN_TIMEOUT
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory
import io.micrometer.core.instrument.MeterRegistry
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics

import java.util.concurrent.{Executors, ScheduledThreadPoolExecutor}

object XlrExecutors {

  def newFixedThreadPool(name: String,
                         threadCount: Int,
                         meterRegistry: MeterRegistry,
                         shutdownTimeout: Long = DEFAULT_SHUTDOWN_TIMEOUT): RestartableExecutorService = {
    val restartableExec = new RestartableExecutor(
      name,
      () => {
        val executor = Executors.newFixedThreadPool(threadCount, new PrefixedThreadFactory(name, true))
        if (XlrConfig.getInstance.metrics.enabled) {
          ExecutorServiceMetrics.monitor(meterRegistry, executor, name, TAG_EXECUTOR)
        } else {
          executor
        }
      },
      shutdownTimeout
    )
    ExecutorsRegistry.put(name, restartableExec)
    restartableExec
  }

  def newScheduledThreadPool(name: String,
                             threadCount: Int,
                             meterRegistry: MeterRegistry,
                             shutdownTimeout: Long = DEFAULT_SHUTDOWN_TIMEOUT
                            ): RestartableScheduledExecutorService = {
    val restartableExec = RestartableScheduledExecutor(
      name,
      () => {
        val executor = new ScheduledThreadPoolExecutor(threadCount, PrefixedThreadFactory(name))
        executor.setRemoveOnCancelPolicy(true)
        if (XlrConfig.getInstance.metrics.enabled) {
          ExecutorServiceMetrics.monitor(meterRegistry, executor, name, TAG_EXECUTOR)
        } else {
          executor
        }
      },
      shutdownTimeout
    )
    ExecutorsRegistry.put(name, restartableExec)

    restartableExec
  }

}
