package com.xebialabs.xlrelease.health

import com.xebialabs.xlplatform.cluster.NodeState
import com.xebialabs.xlrelease.domain.management.ServiceState
import com.xebialabs.xlrelease.service.XlrServiceManager
import org.springframework.stereotype.Controller

import jakarta.ws.rs._
import jakarta.ws.rs.core.{MediaType, Response}

@Path("/ha/health")
@Controller
class HealthCheck(serviceManager: XlrServiceManager) {

  @HEAD
  @GET
  @Produces(Array(MediaType.APPLICATION_JSON))
  def health(): Response = {
    val serviceStatuses = serviceManager.getServicesStatus
    val isRunning = serviceStatuses.forall(_.state == ServiceState.Running)
    if (NodeState.isActive && isRunning) {
      Response.ok("{ \"status\": \"OK\" }").build()
    } else {
      Response.status(404).entity("I'm not here, see my friend").build()
    }
  }
}
